/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtility {
    private static Logger _log = LoggerFactory.getLogger(FileUtility.class);

    public void copy(InputStream source, String destinationFileName) {
        DataOutputStream destination = null;
        try {
            destination = new DataOutputStream(new FileOutputStream(destinationFileName));
            IOUtils.copy((InputStream)source, (OutputStream)destination);
        }
        catch (Exception any) {
            _log.error(any.toString(), (Throwable)any);
            throw new RuntimeException(any);
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (Exception exception) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void copyDir(String sourceDirectoryPath, String destinationDirectoryPath) throws IOException {
        File sourceDir = new File(sourceDirectoryPath);
        File destinationDir = new File(destinationDirectoryPath);
        FileUtils.copyDirectoryToDirectory((File)sourceDir, (File)destinationDir);
    }

    public void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    this.delete(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    public void unTargz(File inputFile, File outputDir) throws FileNotFoundException, IOException, ArchiveException {
        Process process = null;
        try {
            String[] cmds = new String[]{"tar", "zxC", outputDir.toString(), "-f", inputFile.toString()};
            process = Runtime.getRuntime().exec(cmds);
            process.waitFor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<File> unTar(File inputFile, File outputDir) throws FileNotFoundException, IOException, ArchiveException {
        _log.info(String.format("Untaring %s to dir %s.", inputFile.getAbsolutePath(), outputDir.getAbsolutePath()));
        LinkedList<File> untaredFiles = new LinkedList<File>();
        FileInputStream is = new FileInputStream(inputFile);
        TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
        TarArchiveEntry entry = null;
        while ((entry = debInputStream.getNextEntry()) != null) {
            File outputFile = new File(outputDir, entry.getName());
            if (entry.isDirectory()) {
                _log.info(String.format("Attempting to write output directory %s.", outputFile.getAbsolutePath()));
                if (!outputFile.exists()) {
                    _log.info(String.format("Attempting to create output directory %s.", outputFile.getAbsolutePath()));
                    if (!outputFile.mkdirs()) {
                        throw new IllegalStateException(String.format("CHUNouldn't create directory %s.", outputFile.getAbsolutePath()));
                    }
                }
            } else {
                _log.info(String.format("Creating output file %s.", outputFile.getAbsolutePath()));
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                IOUtils.copy((InputStream)debInputStream, (OutputStream)outputFileStream);
                ((OutputStream)outputFileStream).close();
            }
            untaredFiles.add(outputFile);
        }
        debInputStream.close();
        return untaredFiles;
    }

    public File unGzip(File inputFile, File outputDir) throws FileNotFoundException, IOException {
        _log.info(String.format("Ungzipping %s to dir %s.", inputFile.getAbsolutePath(), outputDir.getAbsolutePath()));
        File outputFile = new File(outputDir, inputFile.getName().substring(0, inputFile.getName().length() - 3));
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(inputFile));
        FileOutputStream out = new FileOutputStream(outputFile);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.close();
        return outputFile;
    }

    public void moveFile(String srcFileName, String destFileName) throws Exception {
        FileUtils.moveFile((File)new File(srcFileName), (File)new File(destFileName));
    }

    public void moveDir(String sourceDirectoryPath, String destinationDirectoryPath) throws IOException {
        File sourceDir = new File(sourceDirectoryPath);
        File destinationDir = new File(destinationDirectoryPath);
        FileUtils.moveDirectoryToDirectory((File)sourceDir, (File)destinationDir, (boolean)true);
    }

    public void zip(String filename, String basePath, final String includeExpression) throws Exception {
        _log.info("creating zip file " + filename);
        FileOutputStream fos = new FileOutputStream(filename);
        ZipOutputStream zos = new ZipOutputStream(fos);
        File basePathDir = new File(basePath);
        String[] files = basePathDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(includeExpression);
            }
        });
        if (files == null) {
            zos.close();
            throw new FileNotFoundException("no files selected for basePath=" + basePath + " and includeExpression=" + includeExpression);
        }
        for (String file : files) {
            _log.info("compressing " + file);
            ZipEntry ze = new ZipEntry(file);
            zos.putNextEntry(ze);
            FileInputStream in = new FileInputStream(new File(basePath, file));
            IOUtils.copy((InputStream)in, (OutputStream)zos);
            in.close();
            zos.closeEntry();
        }
        zos.close();
    }

    public int deleteFilesInFolder(String basePath, final String includeExpression) {
        String[] files = new File(basePath).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(includeExpression);
            }
        });
        if (files == null) {
            return 0;
        }
        int count = 0;
        for (String file : files) {
            File toDelete = new File(basePath, file);
            toDelete.delete();
            ++count;
        }
        return count;
    }
}

