/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.impl;

import java.util.List;
import java.util.Map;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.impl.AbstractFederatedServiceCollectionWrapperImpl;
import org.onebusaway.federations.impl.FederatedServiceCollectionImpl;
import org.onebusaway.federations.impl.FederatedServiceLibrary;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyFederatedServiceCollectionImpl
extends AbstractFederatedServiceCollectionWrapperImpl {
    private Logger _logger = LoggerFactory.getLogger(LazyFederatedServiceCollectionImpl.class);
    private List<? extends FederatedService> _serviceProviders;
    private Class<? extends FederatedService> _serviceInterface;
    private volatile FederatedServiceCollection _registry = null;

    public void setServiceProviders(List<? extends FederatedService> serviceProviders) {
        this._serviceProviders = serviceProviders;
    }

    public void setServiceInterface(Class<? extends FederatedService> serviceInterface) {
        this._serviceInterface = serviceInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FederatedServiceCollection getCollection() {
        if (this._registry == null) {
            LazyFederatedServiceCollectionImpl lazyFederatedServiceCollectionImpl = this;
            synchronized (lazyFederatedServiceCollectionImpl) {
                if (this._registry == null) {
                    this._logger.info("instantiating FederatedServiceRegistry");
                    Map<FederatedService, Map<String, List<CoordinateBounds>>> coverage = FederatedServiceLibrary.getFederatedServiceAgencyCoverage(this._serviceProviders, this._serviceInterface);
                    this._registry = new FederatedServiceCollectionImpl(coverage);
                }
            }
        }
        return this._registry;
    }
}

