/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.onebusaway.federations.FederatedServiceRegistry;
import org.onebusaway.federations.FederatedServiceRegistryEntry;
import org.onebusaway.federations.impl.FederatedServiceEntryImpl;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederatedServiceRegistryImpl
implements FederatedServiceRegistry {
    private static Logger _log = LoggerFactory.getLogger(FederatedServiceRegistryImpl.class);
    private ConcurrentMap<String, Boolean> _persistentStatusByUrl = new ConcurrentHashMap<String, Boolean>();
    private ConcurrentMap<String, FederatedServiceEntryImpl> _servicesByUrl = new ConcurrentHashMap<String, FederatedServiceEntryImpl>();
    private Map<String, Map<String, FederatedServiceEntryImpl>> _servicesByTypeAndUrl = new HashMap<String, Map<String, FederatedServiceEntryImpl>>();
    private ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor();
    private int _updateFrequency = 60;

    public void setUpdateFrequency(int updateFrequencyInSeconds) {
        this._updateFrequency = updateFrequencyInSeconds;
    }

    public void start() {
        this._executor.scheduleAtFixedRate(new ServiceUpdateImpl(), 0L, this._updateFrequency, TimeUnit.SECONDS);
    }

    public void stop() {
        this._executor.shutdown();
    }

    @Override
    public synchronized List<FederatedServiceRegistryEntry> getAllServices() {
        ArrayList<FederatedServiceRegistryEntry> entries = new ArrayList<FederatedServiceRegistryEntry>();
        for (FederatedServiceEntryImpl entry : this._servicesByUrl.values()) {
            entries.add(entry.getAsEntry());
        }
        return entries;
    }

    @Override
    public synchronized List<FederatedServiceRegistryEntry> getServices(String serviceClass, Map<String, String> properties) {
        ArrayList<FederatedServiceRegistryEntry> results = new ArrayList<FederatedServiceRegistryEntry>();
        Map<String, FederatedServiceEntryImpl> entries = this._servicesByTypeAndUrl.get(serviceClass);
        if (entries != null) {
            for (FederatedServiceEntryImpl entry : entries.values()) {
                if (!entry.isEnabled() || !entry.isApplicable(properties) || entry.isExpired()) continue;
                results.add(entry.getAsEntry());
            }
        }
        return results;
    }

    @Override
    public synchronized void addService(String url, String serviceClass, Map<String, String> properties) {
        FederatedServiceEntryImpl existing = (FederatedServiceEntryImpl)this._servicesByUrl.get(url);
        this.removeService(url);
        FederatedServiceEntryImpl entry = new FederatedServiceEntryImpl(url, serviceClass, properties);
        String expiresAfter = properties.get("registration_expires_after");
        if (expiresAfter != null) {
            int epiresAfterMS = Integer.parseInt(expiresAfter) * 1000;
            entry.setExpiresAfter(SystemTime.currentTimeMillis() + (long)epiresAfterMS);
        }
        boolean enabled = true;
        if (existing != null) {
            enabled = existing.isEnabled();
        } else if (this._persistentStatusByUrl.containsKey(url)) {
            enabled = (Boolean)this._persistentStatusByUrl.get(url);
        } else {
            String initiallyEnabledValue = properties.get("initially_enabled");
            if (initiallyEnabledValue != null) {
                enabled = Boolean.parseBoolean(initiallyEnabledValue);
            }
        }
        entry.setEnabled(enabled);
        this._persistentStatusByUrl.put(url, enabled);
        this._servicesByUrl.put(url, entry);
        Map<String, FederatedServiceEntryImpl> entries = this._servicesByTypeAndUrl.get(serviceClass);
        if (entries == null) {
            entries = new HashMap<String, FederatedServiceEntryImpl>();
            this._servicesByTypeAndUrl.put(serviceClass, entries);
        }
        entries.put(url, entry);
    }

    @Override
    public synchronized void removeService(String url) {
        Map<String, FederatedServiceEntryImpl> byUrl;
        FederatedServiceEntryImpl entry = (FederatedServiceEntryImpl)this._servicesByUrl.remove(url);
        if (entry != null && (byUrl = this._servicesByTypeAndUrl.get(entry.getServiceClass())) != null) {
            byUrl.remove(url);
        }
    }

    @Override
    public synchronized void removeAllServices() {
        ArrayList urls = new ArrayList(this._servicesByUrl.keySet());
        for (String url : urls) {
            this.removeService(url);
        }
    }

    @Override
    public synchronized void setServiceStatus(String url, boolean enabled) {
        FederatedServiceEntryImpl entry = (FederatedServiceEntryImpl)this._servicesByUrl.get(url);
        if (entry != null) {
            entry.setEnabled(enabled);
        }
        this._persistentStatusByUrl.put(url, enabled);
    }

    private synchronized void pruneExpiredServices() {
        HashSet<String> expiredUrls = new HashSet<String>();
        for (FederatedServiceEntryImpl entry : this._servicesByUrl.values()) {
            if (!entry.isExpired()) continue;
            expiredUrls.add(entry.getServiceUrl());
        }
        for (String expiredUrl : expiredUrls) {
            _log.info("expiring service url: " + expiredUrl);
            this.removeService(expiredUrl);
        }
    }

    private class ServiceUpdateImpl
    implements Runnable {
        private ServiceUpdateImpl() {
        }

        @Override
        public void run() {
            FederatedServiceRegistryImpl.this.pruneExpiredServices();
        }
    }
}

