/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.geospatial.model.CoordinateBounds;

public class FederatedServiceLibrary {
    public static Map<FederatedService, Map<String, List<CoordinateBounds>>> getFederatedServiceAgencyCoverage(List<? extends FederatedService> federatedServiceInstances, Class<? extends FederatedService> federatedServiceInterface) {
        HashMap<FederatedService, Map<String, List<CoordinateBounds>>> byProvider = new HashMap<FederatedService, Map<String, List<CoordinateBounds>>>();
        for (FederatedService federatedService : federatedServiceInstances) {
            if (!federatedServiceInterface.isAssignableFrom(federatedService.getClass())) {
                throw new IllegalArgumentException("service provider " + federatedService + " not instance of " + federatedServiceInterface.getName());
            }
            Map<String, List<CoordinateBounds>> agencyIdsWithCoverageArea = federatedService.getAgencyIdsWithCoverageArea();
            for (Map.Entry<String, List<CoordinateBounds>> entry : agencyIdsWithCoverageArea.entrySet()) {
                String agencyId = entry.getKey();
                List<CoordinateBounds> coverage = entry.getValue();
                FederatedServiceLibrary.checkAgencyAndCoverageAgainstExisting(byProvider, agencyId, coverage, federatedServiceInterface, true);
            }
            byProvider.put(federatedService, agencyIdsWithCoverageArea);
        }
        return byProvider;
    }

    public static boolean checkAgencyAndCoverageAgainstExisting(Map<FederatedService, Map<String, List<CoordinateBounds>>> byProvider, String agencyId, List<CoordinateBounds> coverage, Class<?> serviceInterface, boolean failHard) {
        for (Map<String, List<CoordinateBounds>> other : byProvider.values()) {
            if (other.containsKey(agencyId)) {
                if (failHard) {
                    throw new IllegalArgumentException("agency \"" + agencyId + "\" is handled by multiple providers for service " + serviceInterface.getName());
                }
                return false;
            }
            for (Map.Entry<String, List<CoordinateBounds>> otherEntry : other.entrySet()) {
                String otherAgencyId = otherEntry.getKey();
                List<CoordinateBounds> otherCoverage = otherEntry.getValue();
                for (CoordinateBounds otherRectangle : otherCoverage) {
                    for (CoordinateBounds rectangle : coverage) {
                        if (!rectangle.intersects(otherRectangle)) continue;
                        if (failHard) {
                            throw new IllegalArgumentException("agency \"" + agencyId + "\" has overlap with agency \"" + otherAgencyId + "\" in separate service providers of type " + serviceInterface.getName());
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

