/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.federations.FederatedServiceRegistryEntry;
import org.onebusaway.util.SystemTime;

public class FederatedServiceEntryImpl {
    private final String _serviceUrl;
    private String _serviceClass;
    private final HashMap<String, String> _properties;
    private boolean _enabled = true;
    private long _expiresAfter = 0L;

    public FederatedServiceEntryImpl(String serviceUrl, String serviceClass, Map<String, String> properties) {
        this._serviceUrl = serviceUrl;
        this._serviceClass = serviceClass;
        this._properties = new HashMap<String, String>(properties);
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean isApplicable(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value = this._properties.get(entry.getKey());
            if (value == null) {
                return false;
            }
            if (value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public long getExpiresAfter() {
        return this._expiresAfter;
    }

    public void setExpiresAfter(long expiresAfter) {
        this._expiresAfter = expiresAfter;
    }

    public boolean isExpired() {
        return this._expiresAfter > 0L && SystemTime.currentTimeMillis() > this._expiresAfter;
    }

    public String getServiceUrl() {
        return this._serviceUrl;
    }

    public String getServiceClass() {
        return this._serviceClass;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public FederatedServiceRegistryEntry getAsEntry() {
        return new FederatedServiceRegistryEntry(this._serviceUrl, this._serviceClass, this._properties, this._enabled);
    }
}

