/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.strtree.STRtree;
import org.onebusaway.exceptions.MultipleServiceAreasServiceException;
import org.onebusaway.exceptions.NoSuchAgencyServiceException;
import org.onebusaway.exceptions.OutOfServiceAreaServiceException;
import org.onebusaway.exceptions.ServiceAreaServiceException;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.impl.FederatedServiceLibrary;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;

public class FederatedServiceCollectionImpl
implements FederatedServiceCollection {
    private Set<FederatedService> _services;
    private Map<String, FederatedService> _servicesByAgencyId = new HashMap<String, FederatedService>();
    private STRtree _tree;

    public static <T extends FederatedService> FederatedServiceCollectionImpl create(List<T> serviceProviders, Class<T> serviceInterface) {
        Map<FederatedService, Map<String, List<CoordinateBounds>>> map = FederatedServiceLibrary.getFederatedServiceAgencyCoverage(serviceProviders, serviceInterface);
        return new FederatedServiceCollectionImpl(map);
    }

    public FederatedServiceCollectionImpl(Map<FederatedService, Map<String, List<CoordinateBounds>>> services) {
        this._services = Collections.unmodifiableSet(services.keySet());
        this._tree = new STRtree();
        for (Map.Entry<FederatedService, Map<String, List<CoordinateBounds>>> entry : services.entrySet()) {
            FederatedService service = entry.getKey();
            Map<String, List<CoordinateBounds>> agencyIdsAndCoverage = entry.getValue();
            for (Map.Entry<String, List<CoordinateBounds>> acEntry : agencyIdsAndCoverage.entrySet()) {
                String agencyId = acEntry.getKey();
                List<CoordinateBounds> coverage = acEntry.getValue();
                this._servicesByAgencyId.put(agencyId, service);
                for (CoordinateBounds rc : coverage) {
                    Envelope env = new Envelope(rc.getMinLon(), rc.getMaxLon(), rc.getMinLat(), rc.getMaxLat());
                    this._tree.insert(env, (Object)service);
                }
            }
        }
        this._tree.build();
    }

    public FederatedServiceCollectionImpl() {
        this(new HashMap<FederatedService, Map<String, List<CoordinateBounds>>>());
    }

    @Override
    public Set<FederatedService> getAllServices() {
        return this._services;
    }

    @Override
    public FederatedService getServiceForAgencyId(String agencyId) throws ServiceAreaServiceException {
        FederatedService provider = this._servicesByAgencyId.get(agencyId);
        if (provider == null) {
            throw new NoSuchAgencyServiceException(agencyId);
        }
        return provider;
    }

    @Override
    public FederatedService getServiceForAgencyIds(Iterable<String> agencyIds) throws ServiceAreaServiceException {
        HashSet<FederatedService> providers = new HashSet<FederatedService>();
        for (String id : agencyIds) {
            FederatedService provider = this.getServiceForAgencyId(id);
            if (provider == null) {
                throw new NoSuchAgencyServiceException(id);
            }
            providers.add(provider);
        }
        return this.getProviderFromProviders(providers);
    }

    @Override
    public FederatedService getServiceForBounds(CoordinateBounds bounds) throws ServiceAreaServiceException {
        return this.getServiceForBounds(bounds.getMinLat(), bounds.getMinLon(), bounds.getMaxLat(), bounds.getMaxLon());
    }

    @Override
    public FederatedService getServiceForBounds(double lat1, double lon1, double lat2, double lon2) throws ServiceAreaServiceException {
        Envelope rectangle = new Envelope(lon1, lon2, lat1, lat2);
        return this.getProviderForRectangle(rectangle);
    }

    @Override
    public FederatedService getServiceForLocation(double lat, double lon) throws ServiceAreaServiceException {
        return this.getServiceForBounds(lat, lon, lat, lon);
    }

    @Override
    public FederatedService getServiceForLocations(List<CoordinatePoint> points) throws ServiceAreaServiceException {
        FederatedService service = null;
        for (CoordinatePoint point : points) {
            FederatedService provider = this.getServiceForLocation(point.getLat(), point.getLon());
            if (service == null) {
                service = provider;
                continue;
            }
            if (service == provider) continue;
            throw new MultipleServiceAreasServiceException();
        }
        if (service == null) {
            throw new OutOfServiceAreaServiceException();
        }
        return service;
    }

    private FederatedService getProviderForRectangle(Envelope env) throws ServiceAreaServiceException {
        ProviderCollector collector = new ProviderCollector();
        if (this._tree.size() != 0) {
            this._tree.query(env, (ItemVisitor)collector);
        }
        Set<FederatedService> providers = collector.getProviders();
        return this.getProviderFromProviders(providers);
    }

    private FederatedService getProviderFromProviders(Set<FederatedService> providers) throws OutOfServiceAreaServiceException, MultipleServiceAreasServiceException {
        if (providers.size() == 1) {
            return providers.iterator().next();
        }
        if (providers.size() == 0) {
            throw new OutOfServiceAreaServiceException();
        }
        throw new MultipleServiceAreasServiceException();
    }

    private class ProviderCollector
    implements ItemVisitor {
        private Set<FederatedService> _providers = new HashSet<FederatedService>();

        private ProviderCollector() {
        }

        public Set<FederatedService> getProviders() {
            return this._providers;
        }

        public void visitItem(Object item) {
            this._providers.add((FederatedService)item);
        }
    }
}

