/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.impl;

import com.caucho.hessian.client.HessianConnectionException;
import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianRuntimeException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.FederatedServiceRegistry;
import org.onebusaway.federations.FederatedServiceRegistryEntry;
import org.onebusaway.federations.impl.AbstractFederatedServiceCollectionWrapperImpl;
import org.onebusaway.federations.impl.FederatedServiceCollectionImpl;
import org.onebusaway.federations.impl.FederatedServiceLibrary;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFederatedServiceCollectionImpl
extends AbstractFederatedServiceCollectionWrapperImpl {
    private static Logger _log = LoggerFactory.getLogger(DynamicFederatedServiceCollectionImpl.class);
    private HessianProxyFactory _proxyFactory = new HessianProxyFactory();
    private ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor();
    private volatile FederatedServiceCollection _collection = new FederatedServiceCollectionImpl();
    private volatile Set<String> _activeUrls = new HashSet<String>();
    private FederatedServiceRegistry _registry;
    private int _updateFrequency = 60;
    private Class<?> _serviceInterface;
    private Map<String, String> _queryProperties = new HashMap<String, String>();

    public void setRegistry(FederatedServiceRegistry registry) {
        this._registry = registry;
    }

    public void setUpdateFrequency(int updateFrequencyInSeconds) {
        this._updateFrequency = updateFrequencyInSeconds;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        this._serviceInterface = serviceInterface;
    }

    public void setQueryProperties(Map<String, String> queryProperties) {
        this._queryProperties = queryProperties;
    }

    @PostConstruct
    public void start() {
        _log.debug("start");
        this._executor.scheduleAtFixedRate(new ServiceUpdateImpl(), 0L, this._updateFrequency, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        _log.debug("stop");
        this._executor.shutdown();
    }

    @Override
    protected FederatedServiceCollection getCollection() {
        return this._collection;
    }

    private class ServiceUpdateImpl
    implements Runnable {
        private ServiceUpdateImpl() {
        }

        @Override
        public void run() {
            try {
                HashSet<String> activeUrls = new HashSet<String>();
                List<FederatedServiceRegistryEntry> entries = DynamicFederatedServiceCollectionImpl.this._registry.getServices(DynamicFederatedServiceCollectionImpl.this._serviceInterface.getName(), DynamicFederatedServiceCollectionImpl.this._queryProperties);
                HashMap<FederatedService, Map<String, List<CoordinateBounds>>> byProvider = new HashMap<FederatedService, Map<String, List<CoordinateBounds>>>();
                for (FederatedServiceRegistryEntry serviceEntry : entries) {
                    String url = serviceEntry.getServiceUrl();
                    _log.debug("querying url: {}", (Object)url);
                    try {
                        FederatedService service = (FederatedService)DynamicFederatedServiceCollectionImpl.this._proxyFactory.create(DynamicFederatedServiceCollectionImpl.this._serviceInterface, url);
                        Map<String, List<CoordinateBounds>> agencyIdsWithCoverageArea = service.getAgencyIdsWithCoverageArea();
                        boolean allGood = true;
                        for (Map.Entry<String, List<CoordinateBounds>> entry : agencyIdsWithCoverageArea.entrySet()) {
                            List<CoordinateBounds> coverage;
                            String agencyId = entry.getKey();
                            boolean validService = FederatedServiceLibrary.checkAgencyAndCoverageAgainstExisting(byProvider, agencyId, coverage = entry.getValue(), DynamicFederatedServiceCollectionImpl.this._serviceInterface, false);
                            if (validService) continue;
                            allGood = false;
                            _log.warn("error in agency coverage overlap: url=" + url + " agencyId=" + agencyId);
                        }
                        if (!allGood) continue;
                        _log.debug("adding service...");
                        byProvider.put(service, agencyIdsWithCoverageArea);
                        activeUrls.add(url);
                    }
                    catch (HessianRuntimeException ex) {
                        _log.warn("error querying service url: " + url);
                    }
                    catch (HessianConnectionException ex) {
                        _log.warn("error connecting to service url: " + url);
                    }
                    catch (MalformedURLException e) {
                        _log.warn("malformed service url: " + url);
                    }
                }
                HashSet<String> allUrls = new HashSet<String>();
                allUrls.addAll(DynamicFederatedServiceCollectionImpl.this._activeUrls);
                allUrls.addAll(activeUrls);
                for (String url : allUrls) {
                    boolean a = DynamicFederatedServiceCollectionImpl.this._activeUrls.contains(url);
                    boolean b = activeUrls.contains(url);
                    if (a && !b) {
                        _log.info("service removed: " + url);
                        continue;
                    }
                    if (a || !b) continue;
                    _log.info("service added: " + url);
                }
                DynamicFederatedServiceCollectionImpl.this._collection = new FederatedServiceCollectionImpl(byProvider);
                DynamicFederatedServiceCollectionImpl.this._activeUrls = activeUrls;
            }
            catch (Throwable ex) {
                _log.warn("error refreshing services", ex);
            }
        }
    }
}

