/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.annotations.AgencyIdSupport;
import org.onebusaway.federations.annotations.FederatedServiceMethodInvocationHandler;

class FederatedByEntityIdsMethodInvocationHandlerImpl
implements FederatedServiceMethodInvocationHandler {
    private int _argumentIndex;

    public FederatedByEntityIdsMethodInvocationHandlerImpl(int argumentIndex) {
        this._argumentIndex = argumentIndex;
    }

    public int getArgumentIndex() {
        return this._argumentIndex;
    }

    @Override
    public Object invoke(FederatedServiceCollection collection, Method method, Object[] args) throws ServiceException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Iterable entityIds = (Iterable)args[this._argumentIndex];
        HashSet<String> agencyIds = new HashSet<String>();
        for (String entityId : entityIds) {
            agencyIds.add(AgencyIdSupport.getAgencyIdFromEntityId(entityId));
        }
        FederatedService service = collection.getServiceForAgencyIds(agencyIds);
        return method.invoke((Object)service, args);
    }
}

