/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.onebusaway.collections.beans.PropertyPathExpression;
import org.onebusaway.exceptions.ServiceAreaServiceException;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.annotations.FederatedServiceMethodInvocationHandler;
import org.onebusaway.geospatial.model.CoordinatePoint;

class FederatedByCoordinatePointsMethodInvocationHandlerImpl
implements FederatedServiceMethodInvocationHandler {
    private int[] _argumentIndices;
    private PropertyPathExpression[] _expressions;

    public int[] getArgumentIndices() {
        return this._argumentIndices;
    }

    public PropertyPathExpression[] getExpressions() {
        return this._expressions;
    }

    public FederatedByCoordinatePointsMethodInvocationHandlerImpl(Method method, int[] argumentIndices, String[] expressions) {
        if (argumentIndices.length != expressions.length) {
            throw new IllegalArgumentException("the number of argument indices and expressions must be the same");
        }
        this._argumentIndices = argumentIndices;
        this._expressions = new PropertyPathExpression[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            String expression = expressions[i];
            if (expression == null || expression.length() <= 0) continue;
            this._expressions[i] = new PropertyPathExpression(expression);
            Class<?>[] parameterTypes = method.getParameterTypes();
            this._expressions[i].initialize(parameterTypes[argumentIndices[i]]);
        }
    }

    @Override
    public Object invoke(FederatedServiceCollection collection, Method method, Object[] args) throws ServiceAreaServiceException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<CoordinatePoint> points = new ArrayList<CoordinatePoint>();
        for (int i = 0; i < this._argumentIndices.length; ++i) {
            Object value = args[this._argumentIndices[i]];
            PropertyPathExpression expression = this._expressions[i];
            if (expression != null) {
                value = expression.invoke(value);
            }
            CoordinatePoint point = (CoordinatePoint)value;
            points.add(point);
        }
        FederatedService service = collection.getServiceForLocations(points);
        return method.invoke((Object)service, args);
    }
}

