/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.onebusaway.collections.beans.PropertyPathExpression;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.annotations.AgencyIdSupport;
import org.onebusaway.federations.annotations.FederatedServiceMethodInvocationHandler;

class FederatedByAnyEntityIdMethodInvocationHandlerImpl
implements FederatedServiceMethodInvocationHandler {
    private final int _argumentIndex;
    private final List<PropertyPathExpression> _expressions;
    private final List<PropertyPathExpression> _agencyIdExpressions;

    public FederatedByAnyEntityIdMethodInvocationHandlerImpl(Method method, int argumentIndex, String[] properties, String[] agencyIdProperties) {
        if (properties.length == 0 && agencyIdProperties.length == 0) {
            throw new IllegalArgumentException("you must specify at least one property expression");
        }
        this._argumentIndex = argumentIndex;
        this._expressions = this.compileExpressions(method, argumentIndex, properties);
        this._agencyIdExpressions = this.compileExpressions(method, argumentIndex, agencyIdProperties);
    }

    public int getArgumentIndex() {
        return this._argumentIndex;
    }

    @Override
    public Object invoke(FederatedServiceCollection collection, Method method, Object[] args) throws ServiceException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object target = args[this._argumentIndex];
        HashSet<String> agencyIds = new HashSet<String>();
        for (PropertyPathExpression expression : this._expressions) {
            String entityId = (String)expression.invoke(target);
            if (entityId == null) continue;
            agencyIds.add(AgencyIdSupport.getAgencyIdFromEntityId(entityId));
        }
        for (PropertyPathExpression expression : this._agencyIdExpressions) {
            String agencyId = (String)expression.invoke(target);
            if (agencyId == null) continue;
            agencyIds.add(agencyId);
        }
        FederatedService service = collection.getServiceForAgencyIds(agencyIds);
        return method.invoke((Object)service, args);
    }

    private List<PropertyPathExpression> compileExpressions(Method method, int argumentIndex, String[] properties) {
        ArrayList<PropertyPathExpression> expressions = new ArrayList<PropertyPathExpression>(properties.length);
        for (String property : properties) {
            PropertyPathExpression expression = new PropertyPathExpression(property);
            Class<?>[] parameterTypes = method.getParameterTypes();
            expression.initialize(parameterTypes[argumentIndex]);
            expressions.add(expression);
        }
        return expressions;
    }
}

