/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.exceptions.ServiceAreaServiceException;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.annotations.EMethodAggregationType;
import org.onebusaway.federations.annotations.FederatedServiceMethodInvocationHandler;

class FederatedByAggregateMethodInvocationHandlerImpl
implements FederatedServiceMethodInvocationHandler {
    private EMethodAggregationType _aggregationType;

    public FederatedByAggregateMethodInvocationHandlerImpl(EMethodAggregationType aggregationType) {
        this._aggregationType = aggregationType;
    }

    public EMethodAggregationType getAggregationType() {
        return this._aggregationType;
    }

    @Override
    public Object invoke(FederatedServiceCollection collection, Method method, Object[] args) throws ServiceAreaServiceException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<Object> results = new ArrayList<Object>();
        for (FederatedService service : collection.getAllServices()) {
            results.add(method.invoke((Object)service, args));
        }
        return this.aggregateResults(results);
    }

    private Object aggregateResults(List<Object> results) {
        switch (this._aggregationType) {
            case LIST: {
                return this.aggregateResultsAsList(results);
            }
            case MAP: {
                return this.aggregateResultsAsMap(results);
            }
        }
        throw new IllegalStateException("unknown aggregation type: " + this._aggregationType);
    }

    private Object aggregateResultsAsList(List<Object> results) {
        ArrayList asList = new ArrayList();
        for (Object result : results) {
            List values = (List)result;
            asList.addAll(values);
        }
        return asList;
    }

    private Object aggregateResultsAsMap(List<Object> results) {
        HashMap asMap = new HashMap();
        for (Object result : results) {
            Map values = (Map)result;
            asMap.putAll(values);
        }
        return asMap;
    }
}

