/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.onebusaway.collections.beans.PropertyPathExpression;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.annotations.FederatedServiceMethodInvocationHandler;

class FederatedByAgencyIdMethodInvocationHandlerImpl
implements FederatedServiceMethodInvocationHandler {
    private int _argumentIndex;
    private PropertyPathExpression _expression = null;

    public FederatedByAgencyIdMethodInvocationHandlerImpl(Method method, int argumentIndex, String expression) {
        this._argumentIndex = argumentIndex;
        if (expression != null && expression.length() > 0) {
            this._expression = new PropertyPathExpression(expression);
            Class<?>[] parameterTypes = method.getParameterTypes();
            this._expression.initialize(parameterTypes[argumentIndex]);
        }
    }

    public int getArgumentIndex() {
        return this._argumentIndex;
    }

    @Override
    public Object invoke(FederatedServiceCollection collection, Method method, Object[] args) throws ServiceException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object value = args[this._argumentIndex];
        if (this._expression != null) {
            value = this._expression.invoke(value);
        }
        String agencyId = (String)value;
        FederatedService service = collection.getServiceForAgencyId(agencyId);
        return method.invoke((Object)service, args);
    }
}

