/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.onebusaway.federations.FederatedServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederatedServiceRegistration {
    private static Logger _log = LoggerFactory.getLogger(FederatedServiceRegistration.class);
    private FederatedServiceRegistry _registry;
    private String _serviceUrl;
    private String _serviceClass;
    private Map<String, String> _properties = new HashMap<String, String>();
    private boolean _initiallyEnabled = true;
    private int _updateFrequency = 60;
    private ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor();

    public void setRegistry(FederatedServiceRegistry registry) {
        this._registry = registry;
    }

    public void setServiceUrl(String url) {
        this._serviceUrl = url;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this._serviceClass = serviceClass.getName();
    }

    public void setProperties(Map<String, String> properties) {
        this._properties = properties;
    }

    public void setUpdateFrequency(int updateFrequencyInSeconds) {
        this._updateFrequency = updateFrequencyInSeconds;
    }

    public void setInitiallyEnabled(boolean initiallyEnabled) {
        this._initiallyEnabled = initiallyEnabled;
    }

    public void start() {
        this._executor.scheduleAtFixedRate(new ServiceUpdateImpl(), 0L, this._updateFrequency, TimeUnit.SECONDS);
    }

    public void stop() {
        this._executor.shutdown();
        try {
            this._registry.removeService(this._serviceUrl);
        }
        catch (Throwable ex) {
            _log.warn("error removing service registration", ex);
        }
    }

    private class ServiceUpdateImpl
    implements Runnable {
        private ServiceUpdateImpl() {
        }

        @Override
        public void run() {
            try {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("registration_expires_after", Integer.toString(FederatedServiceRegistration.this._updateFrequency * 2));
                properties.put("initially_enabled", Boolean.toString(FederatedServiceRegistration.this._initiallyEnabled));
                properties.putAll(FederatedServiceRegistration.this._properties);
                FederatedServiceRegistration.this._registry.addService(FederatedServiceRegistration.this._serviceUrl, FederatedServiceRegistration.this._serviceClass, properties);
            }
            catch (Throwable ex) {
                _log.warn("error adding service registration", ex);
            }
        }
    }
}

