/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.annotations.FederatedServiceMethodInvocationHandler;

class FederatedServiceInvocationHandler
implements InvocationHandler {
    private Map<Method, FederatedServiceMethodInvocationHandler> _methodHandlers = new HashMap<Method, FederatedServiceMethodInvocationHandler>();
    private FederatedServiceCollection _collection;

    public FederatedServiceInvocationHandler(Map<Method, FederatedServiceMethodInvocationHandler> methodHandlers, FederatedServiceCollection collection) {
        this._methodHandlers = methodHandlers;
        this._collection = collection;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        FederatedServiceMethodInvocationHandler methodHandler = this._methodHandlers.get(method);
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        try {
            return methodHandler.invoke(this._collection, method, args);
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)ex;
                ex = ite.getTargetException();
            }
            throw ex;
        }
    }
}

