/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.federations;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.federations.FederatedService;
import org.onebusaway.federations.FederatedServiceCollection;
import org.onebusaway.federations.FederatedServiceInvocationHandler;
import org.onebusaway.federations.annotations.FederatedServiceMethodInvocationHandler;
import org.onebusaway.federations.annotations.FederatedServiceMethodInvocationHandlerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class FederatedServiceFactoryBean
extends AbstractFactoryBean<Object> {
    private static FederatedServiceMethodInvocationHandlerFactory _handlerFactory = new FederatedServiceMethodInvocationHandlerFactory();
    private Class<?> _serviceInterface;
    private FederatedServiceCollection _collection;

    public void setServiceInterface(Class<?> serviceInterface) {
        this._serviceInterface = serviceInterface;
    }

    public void setCollection(FederatedServiceCollection collection) {
        this._collection = collection;
    }

    public Class<?> getObjectType() {
        return this._serviceInterface;
    }

    protected Object createInstance() throws Exception {
        if (!this._serviceInterface.isInterface()) {
            throw new IllegalArgumentException("service " + this._serviceInterface.getName() + " is not an interface");
        }
        if (!FederatedService.class.isAssignableFrom(this._serviceInterface)) {
            throw new IllegalArgumentException("service interface " + this._serviceInterface.getName() + " does not implement " + FederatedService.class);
        }
        Map<Method, FederatedServiceMethodInvocationHandler> methodHandlers = this.getMethodHandlers();
        FederatedServiceInvocationHandler handler = new FederatedServiceInvocationHandler(methodHandlers, this._collection);
        Class[] interfaces = new Class[]{this._serviceInterface};
        return Proxy.newProxyInstance(this._serviceInterface.getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    private Map<Method, FederatedServiceMethodInvocationHandler> getMethodHandlers() {
        HashMap<Method, FederatedServiceMethodInvocationHandler> handlers = new HashMap<Method, FederatedServiceMethodInvocationHandler>();
        for (Method method : this._serviceInterface.getDeclaredMethods()) {
            FederatedServiceMethodInvocationHandler handler = _handlerFactory.getHandlerForMethod(method);
            handlers.put(method, handler);
        }
        return handlers;
    }
}

