/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.SessionFactory;
import org.onebusaway.gtfs.impl.HibernateOperationsImpl;
import org.onebusaway.gtfs.impl.MultipleCalendarsForServiceIdException;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.HibernateOperation;
import org.onebusaway.gtfs.services.HibernateOperations;

public class HibernateGtfsRelationalDaoImpl
implements GtfsMutableRelationalDao {
    protected HibernateOperations _ops;

    public HibernateGtfsRelationalDaoImpl() {
    }

    public HibernateGtfsRelationalDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this._ops = new HibernateOperationsImpl(sessionFactory);
    }

    public SessionFactory getSessionFactory() {
        if (this._ops == null) {
            return null;
        }
        return this._ops.getSessionFactory();
    }

    public Object execute(HibernateOperation callback) {
        return this._ops.execute(callback);
    }

    public <T> Collection<T> getAllEntitiesForType(Class<T> type) {
        return this._ops.find("from " + type.getName());
    }

    public <T> T getEntityForId(Class<T> type, Serializable id) {
        return this._ops.get(type, id);
    }

    public List<Agency> getAllAgencies() {
        return this._ops.find("from Agency");
    }

    public List<ServiceCalendar> getAllCalendars() {
        return this._ops.find("FROM ServiceCalendar");
    }

    public List<ServiceCalendarDate> getAllCalendarDates() {
        return this._ops.find("FROM ServiceCalendarDate");
    }

    public Collection<FareAttribute> getAllFareAttributes() {
        return this._ops.find("FROM FareAttribute");
    }

    public Collection<FareRule> getAllFareRules() {
        return this._ops.find("FROM FareRule");
    }

    public Collection<FeedInfo> getAllFeedInfos() {
        return this._ops.find("FROM FeedInfo");
    }

    public Collection<Frequency> getAllFrequencies() {
        return this._ops.find("FROM Frequency");
    }

    public List<Route> getAllRoutes() {
        return this._ops.find("FROM Route route");
    }

    public List<Stop> getAllStops() {
        return this._ops.find("FROM Stop");
    }

    public List<Pathway> getAllPathways() {
        return this._ops.find("FROM Pathway");
    }

    public List<Trip> getAllTrips() {
        return this._ops.find("FROM Trip");
    }

    public List<StopTime> getAllStopTimes() {
        return this._ops.find("FROM StopTime");
    }

    public Collection<ShapePoint> getAllShapePoints() {
        return this._ops.find("FROM ShapePoint");
    }

    public Collection<Transfer> getAllTransfers() {
        return this._ops.find("FROM Transfer");
    }

    public Agency getAgencyForId(String id) {
        return this._ops.get(Agency.class, (Serializable)((Object)id));
    }

    public FareAttribute getFareAttributeForId(AgencyAndId id) {
        return this._ops.get(FareAttribute.class, (Serializable)id);
    }

    public FareRule getFareRuleForId(int id) {
        return this._ops.get(FareRule.class, Integer.valueOf(id));
    }

    public FeedInfo getFeedInfoForId(int id) {
        return this._ops.get(FeedInfo.class, Integer.valueOf(id));
    }

    public Frequency getFrequencyForId(int id) {
        return this._ops.get(Frequency.class, Integer.valueOf(id));
    }

    public Pathway getPathwayForId(AgencyAndId agencyAndId) {
        return this._ops.get(Pathway.class, (Serializable)agencyAndId);
    }

    public Route getRouteForId(AgencyAndId id) {
        return this._ops.get(Route.class, (Serializable)id);
    }

    public ServiceCalendar getCalendarForId(int id) {
        return this._ops.get(ServiceCalendar.class, Integer.valueOf(id));
    }

    public ServiceCalendarDate getCalendarDateForId(int id) {
        return this._ops.get(ServiceCalendarDate.class, Integer.valueOf(id));
    }

    public ShapePoint getShapePointForId(int id) {
        return this._ops.get(ShapePoint.class, Integer.valueOf(id));
    }

    public Stop getStopForId(AgencyAndId agencyAndId) {
        return this._ops.get(Stop.class, (Serializable)agencyAndId);
    }

    public StopTime getStopTimeForId(int id) {
        return this._ops.get(StopTime.class, Integer.valueOf(id));
    }

    public Transfer getTransferForId(int id) {
        return this._ops.get(Transfer.class, Integer.valueOf(id));
    }

    public Trip getTripForId(AgencyAndId id) {
        return this._ops.get(Trip.class, (Serializable)id);
    }

    public List<String> getTripAgencyIdsReferencingServiceId(AgencyAndId serviceId) {
        return this._ops.findByNamedQueryAndNamedParam("agencyIdsReferencingServiceId", "serviceId", serviceId);
    }

    public List<Route> getRoutesForAgency(Agency agency) {
        return this._ops.findByNamedQueryAndNamedParam("routesForAgency", "agency", agency);
    }

    public List<Stop> getStopsForStation(Stop station) {
        String[] names = new String[]{"stationId", "agencyId"};
        Object[] values = new Object[]{station.getId().getId(), station.getId().getAgencyId()};
        return this._ops.findByNamedQueryAndNamedParams("stopsForStation", names, values);
    }

    public List<Trip> getTripsForRoute(Route route) {
        return this._ops.findByNamedQueryAndNamedParam("tripsByRoute", "route", route);
    }

    public List<Trip> getTripsForBlockId(AgencyAndId blockId) {
        String[] names = new String[]{"agencyId", "blockId"};
        Object[] values = new Object[]{blockId.getAgencyId(), blockId.getId()};
        return this._ops.findByNamedQueryAndNamedParams("tripsByBlockId", names, values);
    }

    public List<StopTime> getStopTimesForTrip(Trip trip) {
        return this._ops.findByNamedQueryAndNamedParam("stopTimesByTrip", "trip", trip);
    }

    public List<StopTime> getStopTimesForStop(Stop stop) {
        return this._ops.findByNamedQueryAndNamedParam("stopTimesByStop", "stop", stop);
    }

    public List<AgencyAndId> getAllShapeIds() {
        return this._ops.findByNamedQuery("allShapeIds");
    }

    public List<ShapePoint> getShapePointsForShapeId(AgencyAndId shapeId) {
        return this._ops.findByNamedQueryAndNamedParam("shapePointsForShapeId", "shapeId", shapeId);
    }

    public List<Frequency> getFrequenciesForTrip(Trip trip) {
        return this._ops.findByNamedQueryAndNamedParam("frequenciesForTrip", "trip", trip);
    }

    public List<ServiceCalendarDate> getCalendarDatesForServiceId(AgencyAndId serviceId) {
        return this._ops.findByNamedQueryAndNamedParam("calendarDatesForServiceId", "serviceId", serviceId);
    }

    public ServiceCalendar getCalendarForServiceId(AgencyAndId serviceId) {
        List calendars = this._ops.findByNamedQueryAndNamedParam("calendarsForServiceId", "serviceId", serviceId);
        switch (calendars.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (ServiceCalendar)calendars.get(0);
            }
        }
        throw new MultipleCalendarsForServiceIdException(serviceId);
    }

    public List<FareRule> getFareRulesForFareAttribute(FareAttribute fareAttribute) {
        return this._ops.findByNamedQueryAndNamedParam("fareRulesForFareAttribute", "fareAttribute", fareAttribute);
    }

    public void open() {
        this._ops.open();
    }

    public void close() {
        this._ops.close();
    }

    public void flush() {
        this._ops.flush();
    }

    public <K extends Serializable, T extends IdentityBean<K>> void removeEntity(T entity) {
        this._ops.removeEntity(entity);
    }

    public void updateEntity(Object entity) {
        this._ops.update(entity);
    }

    public void saveEntity(Object entity) {
        this._ops.save(entity);
    }

    public void saveOrUpdateEntity(Object entity) {
        this._ops.saveOrUpdate(entity);
    }

    public <T> void clearAllEntitiesForType(Class<T> type) {
        this._ops.clearAllEntitiesForType(type);
    }
}

