/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.onebusaway.gtfs.services.HibernateOperation;
import org.onebusaway.gtfs.services.HibernateOperations;

public class HibernateOperationsImpl
implements HibernateOperations {
    private static final int BUFFER_SIZE = 1000;
    private SessionFactory _sessionFactory;
    private org.hibernate.Session _session;
    private int _count = 0;

    public HibernateOperationsImpl() {
    }

    public HibernateOperationsImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    @Override
    public void open() {
        this._session = this._sessionFactory.openSession();
        this._session.beginTransaction();
    }

    @Override
    public void close() {
        Transaction tx = this._session.getTransaction();
        tx.commit();
        this._session.close();
        this._session = null;
    }

    @Override
    public Object execute(HibernateOperation callback) {
        if (this._session == null) {
            Session session = this._sessionFactory.openSession();
            Transaction tx = session.beginTransaction();
            tx.begin();
            try {
                Object result = callback.doInHibernate((org.hibernate.Session)session);
                tx.commit();
                Object object = result;
                return object;
            }
            catch (Exception ex) {
                tx.rollback();
                throw new IllegalStateException(ex);
            }
            finally {
                session.close();
            }
        }
        try {
            return callback.doInHibernate(this._session);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public <T> List<T> find(String queryString) {
        return this.findWithNamedParams(queryString, null, null);
    }

    @Override
    public <T> List<T> findWithNamedParam(String queryString, String paramName, Object value) {
        return this.findWithNamedParams(queryString, new String[]{paramName}, new Object[]{value});
    }

    @Override
    public <T> List<T> findWithNamedParams(final String queryString, final String[] paramNames, final Object[] values) {
        return (List)this.execute(new HibernateOperation(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateOperationsImpl.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public <T> List<T> findByNamedQuery(String namedQuery) {
        return this.findByNamedQueryAndNamedParams(namedQuery, null, null);
    }

    @Override
    public <T> List<T> findByNamedQueryAndNamedParam(String namedQuery, String paramName, Object paramValue) {
        return this.findByNamedQueryAndNamedParams(namedQuery, new String[]{paramName}, new Object[]{paramValue});
    }

    @Override
    public <T> List<T> findByNamedQueryAndNamedParams(final String namedQuery, final String[] paramNames, final Object[] values) {
        return (List)this.execute(new HibernateOperation(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(namedQuery);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateOperationsImpl.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
                    }
                }
                return queryObject.list();
            }
        });
    }

    @Override
    public <T> T get(final Class<T> entityType, final Serializable id) {
        return (T)this.execute(new HibernateOperation(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException {
                return session.get(entityType, id);
            }
        });
    }

    @Override
    public void save(final Object entity) {
        this.execute(new HibernateOperation(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Serializable obj = session.save(entity);
                HibernateOperationsImpl.this._count++;
                if (HibernateOperationsImpl.this._count >= 1000) {
                    session.flush();
                    session.clear();
                    HibernateOperationsImpl.this._count = 0;
                }
                return obj;
            }
        });
    }

    @Override
    public <T> void clearAllEntitiesForType(final Class<T> type) {
        this.execute(new HibernateOperation(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query query = session.createQuery("delete from " + type.getName());
                return query.executeUpdate();
            }
        });
    }

    @Override
    public <T> void removeEntity(final T entity) {
        this.execute(new HibernateOperation(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                session.delete(entity);
                return null;
            }
        });
    }

    @Override
    public void flush() {
        this.execute(new HibernateOperation(){

            @Override
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException {
                session.flush();
                HibernateOperationsImpl.this._count = 0;
                return null;
            }
        });
    }

    protected void applyNamedParameterToQuery(Query queryObject, String paramName, Object value) throws HibernateException {
        if (value instanceof Collection) {
            queryObject.setParameterList(paramName, (Collection)value);
        } else if (value instanceof Object[]) {
            queryObject.setParameterList(paramName, (Object[])value);
        } else {
            queryObject.setParameter(paramName, value);
        }
    }
}

