/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.model.dto;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.omnifaces.utils.Lang;

public final class Page {
    public static final Page ALL = Page.of(0, Integer.MAX_VALUE);
    public static final Page ONE = Page.of(0, 1);
    private final int offset;
    private final int limit;
    private final Map<String, Boolean> ordering;
    private final Map<String, Object> requiredCriteria;
    private final Map<String, Object> optionalCriteria;

    public Page(Integer offset, Integer limit, LinkedHashMap<String, Boolean> ordering, Map<String, Object> requiredCriteria, Map<String, Object> optionalCriteria) {
        this.offset = Page.validateIntegerArgument("offset", offset, 0, 0);
        this.limit = Page.validateIntegerArgument("limit", limit, 1, Integer.MAX_VALUE);
        this.ordering = !Lang.isEmpty(ordering) ? Collections.unmodifiableMap(ordering) : Collections.singletonMap("id", false);
        this.requiredCriteria = requiredCriteria != null ? Collections.unmodifiableMap(requiredCriteria) : Collections.emptyMap();
        this.optionalCriteria = optionalCriteria != null ? Collections.unmodifiableMap(optionalCriteria) : Collections.emptyMap();
    }

    private static int validateIntegerArgument(String argumentName, Integer argumentValue, int minValue, int defaultValue) {
        if (argumentValue == null) {
            return defaultValue;
        }
        if (argumentValue < minValue) {
            throw new IllegalArgumentException("Argument " + argumentName + " may not be less than " + minValue);
        }
        return argumentValue;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public Map<String, Boolean> getOrdering() {
        return this.ordering;
    }

    public Map<String, Object> getRequiredCriteria() {
        return this.requiredCriteria;
    }

    public Map<String, Object> getOptionalCriteria() {
        return this.optionalCriteria;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Page)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Page other = (Page)object;
        return Objects.equals(this.offset, other.offset) && Objects.equals(this.limit, other.limit) && Objects.equals(this.ordering, other.ordering) && Objects.equals(this.requiredCriteria, other.requiredCriteria) && Objects.equals(this.optionalCriteria, other.optionalCriteria);
    }

    public int hashCode() {
        return Objects.hash(Page.class, this.offset, this.limit, this.ordering, this.requiredCriteria, this.optionalCriteria);
    }

    public String toString() {
        return "Page[" + this.offset + "," + this.limit + "," + this.ordering + "," + new TreeMap<String, Object>(this.requiredCriteria) + "," + new TreeMap<String, Object>(this.optionalCriteria) + "]";
    }

    public static Builder with() {
        return new Builder();
    }

    public static Page of(int offset, int limit) {
        return Page.with().range(offset, limit).build();
    }

    public static class Builder {
        private Integer offset;
        private Integer limit;
        private LinkedHashMap<String, Boolean> ordering = new LinkedHashMap(2);
        private Map<String, Object> requiredCriteria;
        private Map<String, Object> optionalCriteria;

        public Builder range(int offset, int limit) {
            if (this.offset != null) {
                throw new IllegalStateException("Offset and limit are already set");
            }
            this.offset = offset;
            this.limit = limit;
            return this;
        }

        public Builder orderBy(String field, boolean ascending) {
            this.ordering.put(field, ascending);
            return this;
        }

        public Builder allMatch(Map<String, Object> requiredCriteria) {
            if (this.requiredCriteria != null) {
                throw new IllegalStateException("Required criteria is already set");
            }
            this.requiredCriteria = requiredCriteria;
            return this;
        }

        public Builder anyMatch(Map<String, Object> optionalCriteria) {
            if (this.optionalCriteria != null) {
                throw new IllegalStateException("Optional criteria is already set");
            }
            this.optionalCriteria = optionalCriteria;
            return this;
        }

        public Page build() {
            return new Page(this.offset, this.limit, this.ordering, this.requiredCriteria, this.optionalCriteria);
        }
    }
}

