/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.datasource;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;

public class CommonDataSourceWrapper
implements CommonDataSource {
    private CommonDataSource commonDataSource;
    private Map<String, PropertyDescriptor> dataSourceProperties;

    public void initDataSource(CommonDataSource dataSource) {
        this.commonDataSource = dataSource;
        try {
            HashMap<String, PropertyDescriptor> mutableProperties = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(dataSource.getClass()).getPropertyDescriptors()) {
                mutableProperties.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            this.dataSourceProperties = Collections.unmodifiableMap(mutableProperties);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T get(String name) {
        try {
            return (T)this.dataSourceProperties.get(name).getReadMethod().invoke((Object)this.commonDataSource, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void set(String name, Object value) {
        try {
            this.dataSourceProperties.get(name).getWriteMethod().invoke((Object)this.commonDataSource, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setWithConversion(String name, String value) {
        PropertyDescriptor property = this.dataSourceProperties.get(name);
        PropertyEditor editor = PropertyEditorManager.findEditor(property.getPropertyType());
        editor.setAsText(value);
        try {
            property.getWriteMethod().invoke((Object)this.commonDataSource, editor.getValue());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public CommonDataSource getWrapped() {
        return this.commonDataSource;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return (PrintWriter)this.get("loginWriter");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.set("loginWriter", out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.set("loginTimeout", seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return (Integer)this.get("loginTimeout");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.commonDataSource.getParentLogger();
    }

    public String getServerName() {
        return (String)this.get("serverName");
    }

    public void setServerName(String serverName) {
        this.set("serverName", serverName);
    }

    public String getDatabaseName() {
        return (String)this.get("databaseName");
    }

    public void setDatabaseName(String databaseName) {
        this.set("databaseName", databaseName);
    }

    public int getPortNumber() {
        return (Integer)this.get("serverName");
    }

    public void setPortNumber(int portNumber) {
        this.set("portNumber", portNumber);
    }

    public void setPortNumber(Integer portNumber) {
        this.set("portNumber", portNumber);
    }

    public String getUser() {
        return (String)this.get("serverName");
    }

    public void setUser(String user) {
        this.set("user", user);
    }

    public String getPassword() {
        return (String)this.get("serverName");
    }

    public void setPassword(String password) {
        this.set("password", password);
    }

    public String getCompatible() {
        return (String)this.get("serverName");
    }

    public void setCompatible(String compatible) {
        this.set("compatible", compatible);
    }

    public int getLogLevel() {
        return (Integer)this.get("serverName");
    }

    public void setLogLevel(int logLevel) {
        this.set("logLevel", logLevel);
    }

    public int getProtocolVersion() {
        return (Integer)this.get("serverName");
    }

    public void setProtocolVersion(int protocolVersion) {
        this.set("protocolVersion", protocolVersion);
    }

    public void setPrepareThreshold(int prepareThreshold) {
        this.set("prepareThreshold", prepareThreshold);
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.set("receiveBufferSize", receiveBufferSize);
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.set("sendBufferSize", sendBufferSize);
    }

    public int getPrepareThreshold() {
        return (Integer)this.get("prepareThreshold");
    }

    public void setUnknownLength(int unknownLength) {
        this.set("unknownLength", unknownLength);
    }

    public int getUnknownLength() {
        return (Integer)this.get("unknownLength");
    }

    public void setSocketTimeout(int socketTimeout) {
        this.set("socketTimeout", socketTimeout);
    }

    public int getSocketTimeout() {
        return (Integer)this.get("socketTimeout");
    }

    public void setSsl(boolean ssl) {
        this.set("ssl", ssl);
    }

    public boolean getSsl() {
        return (Boolean)this.get("ssl");
    }

    public void setSslfactory(String sslfactory) {
        this.set("sslfactory", sslfactory);
    }

    public String getSslfactory() {
        return (String)this.get("sslfactory");
    }

    public void setApplicationName(String applicationName) {
        this.set("applicationName", applicationName);
    }

    public String getApplicationName() {
        return (String)this.get("applicationName");
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.set("tcpKeepAlive", tcpKeepAlive);
    }

    public boolean getTcpKeepAlive() {
        return (Boolean)this.get("tcpKeepAlive");
    }

    public void setBinaryTransfer(boolean binaryTransfer) {
        this.set("binaryTransfer", binaryTransfer);
    }

    public boolean getBinaryTransfer() {
        return (Boolean)this.get("binaryTransfer");
    }

    public void setBinaryTransferEnable(String binaryTransferEnable) {
        this.set("binaryTransferEnable", binaryTransferEnable);
    }

    public String getBinaryTransferEnable() {
        return (String)this.get("binaryTransferEnable");
    }

    public void setBinaryTransferDisable(String binaryTransferDisable) {
        this.set("binaryTransferDisable", binaryTransferDisable);
    }

    public String getBinaryTransferDisable() {
        return (String)this.get("binaryTransferDisable");
    }
}

