/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.criteria;

import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.omnifaces.persistence.criteria.Criteria;

public final class Bool
extends Criteria<Boolean> {
    private Bool(Boolean value) {
        super(value);
    }

    public static Bool value(Boolean value) {
        return new Bool(value);
    }

    public static Bool parse(Object searchValue) {
        return new Bool(Bool.parseBoolean(searchValue));
    }

    @Override
    public Predicate build(Expression<?> path, CriteriaBuilder criteriaBuilder, Criteria.ParameterBuilder parameterBuilder) {
        Predicate predicate = criteriaBuilder.isTrue(path);
        return (Boolean)this.getValue() != false ? predicate : criteriaBuilder.not((Expression)predicate);
    }

    @Override
    public boolean applies(Object modelValue) {
        return Objects.equals(Bool.parseBoolean(modelValue), this.getValue());
    }

    private static Boolean parseBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() > 0;
        }
        return Boolean.parseBoolean(value.toString());
    }
}

