/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.omnifaces.persistence.Provider;
import org.omnifaces.persistence.service.BaseEntityService;
import org.omnifaces.utils.Lang;

public enum Database {
    H2(new String[0]),
    MYSQL("MARIA"),
    POSTGRESQL("POSTGRES"),
    UNKNOWN(new String[0]);

    private static final Logger logger;
    private String[] names;

    private Database(String ... aliases) {
        this.names = Stream.concat(Stream.of(this.name()), Arrays.stream(aliases)).collect(Collectors.toList()).toArray(new String[0]);
    }

    public static Database of(EntityManager entityManager) {
        Provider provider = Provider.of(entityManager);
        EntityManagerFactory entityManagerFactory = entityManager.getEntityManagerFactory();
        try {
            String uppercasedDialectName = provider.getDialectName(entityManagerFactory).toUpperCase();
            for (Database database : Database.values()) {
                if (!Lang.startsWithOneOf((String)uppercasedDialectName, (String[])database.names)) continue;
                return database;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot to determine configured Database for " + (Object)((Object)provider) + " by " + entityManagerFactory, e);
        }
        return UNKNOWN;
    }

    public static boolean is(Database database) {
        return BaseEntityService.getCurrentInstance().getDatabase() == database;
    }

    static {
        logger = Logger.getLogger(Database.class.getName());
    }
}

