/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import org.omnifaces.persistence.Database;
import org.omnifaces.persistence.Provider;
import org.omnifaces.persistence.criteria.Bool;
import org.omnifaces.persistence.criteria.Criteria;
import org.omnifaces.persistence.criteria.Enumerated;
import org.omnifaces.persistence.criteria.IgnoreCase;
import org.omnifaces.persistence.criteria.Not;
import org.omnifaces.persistence.criteria.Numeric;
import org.omnifaces.persistence.exception.IllegalEntityStateException;
import org.omnifaces.persistence.exception.NonDeletableEntityException;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.model.NonDeletable;
import org.omnifaces.persistence.model.dto.Page;
import org.omnifaces.persistence.service.EclipseLinkRoot;
import org.omnifaces.persistence.service.RootWrapper;
import org.omnifaces.persistence.service.SubQueryRoot;
import org.omnifaces.utils.Lang;
import org.omnifaces.utils.collection.PartialResultList;
import org.omnifaces.utils.reflect.Getter;
import org.omnifaces.utils.reflect.Reflections;
import org.omnifaces.utils.stream.Streams;

public abstract class BaseEntityService<I extends Comparable<I> & Serializable, E extends BaseEntity<I>> {
    private static final Map<Class<?>, Map.Entry<Class<?>, Class<?>>> TYPE_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<?>, Set<String>> ELEMENT_COLLECTION_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<?>, Set<String>> ONE_TO_MANY_COLLECTION_MAPPINGS = new ConcurrentHashMap();
    private static final String ERROR_ILLEGAL_MAPPING = "You must return a getter-path mapping from MappedQueryBuilder";
    private static final String ERROR_UNSUPPORTED_CRITERIA = "Predicate for %s(%s) = %s(%s) is not supported. Consider wrapping in a Criteria instance or creating a custom one if you want to deal with it.";
    private static final String ERROR_UNSUPPORTED_ONETOMANY_ORDERBY_ECLIPSELINK = "Sorry, EclipseLink does not support sorting a @OneToMany or @ElementCollection relationship. Consider using a DTO instead.";
    private static final String ERROR_UNSUPPORTED_ONETOMANY_ORDERBY_OPENJPA = "Sorry, OpenJPA does not support sorting a @OneToMany or @ElementCollection relationship. Consider using a DTO instead.";
    private static final String ERROR_UNSUPPORTED_ONETOMANY_CRITERIA_ECLIPSELINK = "Sorry, EclipseLink does not support searching in a @OneToMany relationship. Consider using a DTO instead.";
    private static final String ERROR_UNSUPPORTED_ONETOMANY_CRITERIA_OPENJPA = "Sorry, OpenJPA does not support searching in a @OneToMany relationship. Consider using a DTO instead.";
    private final Class<I> identifierType;
    private final Class<E> entityType;
    private Set<String> elementCollections;
    private java.util.function.Predicate<String> oneToManyCollections;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private Provider provider;
    @Inject
    private Database database;

    public BaseEntityService() {
        Map.Entry typeMapping = TYPE_MAPPINGS.computeIfAbsent(this.getClass(), BaseEntityService::computeTypeMapping);
        this.identifierType = (Class)typeMapping.getKey();
        this.entityType = (Class)typeMapping.getValue();
    }

    @PostConstruct
    private void initWithEntityManager() {
        this.elementCollections = ELEMENT_COLLECTION_MAPPINGS.computeIfAbsent(this.entityType, this::computeElementCollectionMapping);
        this.oneToManyCollections = field -> ONE_TO_MANY_COLLECTION_MAPPINGS.computeIfAbsent(this.entityType, this::computeOneToManyCollectionMapping).stream().anyMatch(oneToManyCollection -> field.startsWith(oneToManyCollection + "."));
    }

    private static Map.Entry<Class<?>, Class<?>> computeTypeMapping(Class<?> type) {
        Type actualType = type.getGenericSuperclass();
        HashMap typeMapping = new HashMap();
        while (!(actualType instanceof ParameterizedType) || !BaseEntityService.class.equals((Object)((ParameterizedType)actualType).getRawType())) {
            if (actualType instanceof ParameterizedType) {
                Class rawType = (Class)((ParameterizedType)actualType).getRawType();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; i < typeParameters.length; ++i) {
                    Type typeArgument = ((ParameterizedType)actualType).getActualTypeArguments()[i];
                    typeMapping.put(typeParameters[i], typeArgument instanceof TypeVariable ? (Type)typeMapping.get(typeArgument) : typeArgument);
                }
                actualType = rawType;
            }
            actualType = ((Class)actualType).getGenericSuperclass();
        }
        return new AbstractMap.SimpleEntry(BaseEntityService.getActualTypeArgument(actualType, 0, typeMapping), BaseEntityService.getActualTypeArgument(actualType, 1, typeMapping));
    }

    private static Class<?> getActualTypeArgument(Type type, int index, Map<TypeVariable<?>, Type> typeMapping) {
        Type actualTypeArgument = ((ParameterizedType)type).getActualTypeArguments()[index];
        if (actualTypeArgument instanceof TypeVariable) {
            actualTypeArgument = typeMapping.get(actualTypeArgument);
        }
        return (Class)actualTypeArgument;
    }

    private Set<String> computeElementCollectionMapping(Class<?> type) {
        return this.computeCollectionMapping(type, "", new HashSet(), this.provider::isElementCollection);
    }

    private Set<String> computeOneToManyCollectionMapping(Class<?> type) {
        return this.computeCollectionMapping(type, "", new HashSet(), a -> !this.provider.isElementCollection((Attribute<?, ?>)a) && a.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY);
    }

    private Set<String> computeCollectionMapping(Class<?> type, String basePath, Set<Class<?>> nestedTypes, java.util.function.Predicate<Attribute<?, ?>> attributePredicate) {
        HashSet<String> collectionMapping = new HashSet<String>(1);
        EntityType entity = this.entityManager.getMetamodel().entity(type);
        for (Attribute attribute : entity.getAttributes()) {
            Class nestedType;
            if (attributePredicate.test(attribute)) {
                collectionMapping.add(basePath + attribute.getName());
                continue;
            }
            if (!(attribute instanceof Bindable) || !BaseEntity.class.isAssignableFrom(nestedType = ((Bindable)attribute).getBindableJavaType()) || nestedType == this.entityType || !nestedTypes.add(nestedType)) continue;
            collectionMapping.addAll(this.computeCollectionMapping(nestedType, basePath + attribute.getName() + ".", nestedTypes, attributePredicate));
        }
        return Collections.unmodifiableSet(collectionMapping);
    }

    protected Provider getProvider() {
        return this.provider;
    }

    protected Database getDatabase() {
        return this.database;
    }

    protected TypedQuery<E> createNamedTypedQuery(String name) {
        return this.entityManager.createNamedQuery(name, this.entityType);
    }

    protected Query createNamedQuery(String name) {
        return this.entityManager.createNamedQuery(name);
    }

    public Optional<E> findById(I id) {
        return Optional.ofNullable(this.getById(id));
    }

    public E getById(I id) {
        return (E)((BaseEntity)this.entityManager.find(this.entityType, id));
    }

    public List<E> getAll() {
        return this.entityManager.createQuery("SELECT e FROM " + this.entityType.getSimpleName() + " e ORDER BY e.id DESC", this.entityType).getResultList();
    }

    public I persist(E entity) {
        if (((BaseEntity)entity).getId() != null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has an ID. Use update() instead.");
        }
        this.entityManager.persist(entity);
        return ((BaseEntity)entity).getId();
    }

    public E update(E entity) {
        if (((BaseEntity)entity).getId() == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has no ID. Use persist() instead.");
        }
        return (E)((BaseEntity)this.entityManager.merge(entity));
    }

    public E save(E entity) {
        if (((BaseEntity)entity).getId() == null) {
            this.persist(entity);
            return entity;
        }
        return this.update(entity);
    }

    public void refresh(E entity) {
        if (((BaseEntity)entity).getId() == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has no ID.");
        }
        Object managed = this.getById(((BaseEntity)entity).getId());
        if (managed == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has in meanwhile been deleted.");
        }
        this.entityManager.getMetamodel().entity(managed.getClass()).getAttributes().forEach(a -> Reflections.map((Member)a.getJavaMember(), (Object)managed, (Object)entity));
    }

    public void delete(E entity) {
        if (entity.getClass().isAnnotationPresent(NonDeletable.class)) {
            throw new NonDeletableEntityException((BaseEntity<?>)entity);
        }
        this.entityManager.remove(this.manage(entity));
    }

    protected E manage(E entity) {
        if (((BaseEntity)entity).getId() == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has no ID.");
        }
        if (this.entityManager.contains(entity)) {
            return entity;
        }
        E managed = this.getById(((BaseEntity)entity).getId());
        if (managed == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has in meanwhile been deleted.");
        }
        return managed;
    }

    protected void fetchLazyCollections(E entity, Function<E, Collection<?>> ... getters) {
        if (!Lang.isEmpty((Object[])getters)) {
            Streams.stream((Object[])getters).forEach(getter -> ((Collection)getter.apply(entity)).size());
        } else {
            this.fetchEveryPluralAttribute(entity, type -> type != PluralAttribute.CollectionType.MAP);
        }
    }

    protected void fetchLazyMaps(E entity, Function<E, Map<?, ?>> ... getters) {
        if (!Lang.isEmpty((Object[])getters)) {
            Streams.stream((Object[])getters).forEach(getter -> ((Map)getter.apply(entity)).size());
        } else {
            this.fetchEveryPluralAttribute(entity, type -> type == PluralAttribute.CollectionType.MAP);
        }
    }

    private void fetchEveryPluralAttribute(E entity, java.util.function.Predicate<PluralAttribute.CollectionType> ofType) {
        for (PluralAttribute a : this.entityManager.getMetamodel().entity(entity.getClass()).getPluralAttributes()) {
            if (!ofType.test(a.getCollectionType())) continue;
            String name = Character.toUpperCase(a.getName().charAt(0)) + a.getName().substring(1);
            Reflections.invokeMethod((Object)Reflections.invokeMethod(entity, (String)("get" + name), (Object[])new Object[0]), (String)"size", (Object[])new Object[0]);
        }
    }

    protected void fetchLazyBlobs(E entity) {
        BaseEntity managed = (BaseEntity)this.entityManager.merge(entity);
        for (Attribute a : this.entityManager.getMetamodel().entity(managed.getClass()).getSingularAttributes()) {
            if (a.getJavaType() != byte[].class) continue;
            String name = Character.toUpperCase(a.getName().charAt(0)) + a.getName().substring(1);
            byte[] blob = (byte[])Reflections.invokeMethod((Object)managed, (String)("get" + name), (Object[])new Object[0]);
            Reflections.invokeMethod(entity, (String)("set" + name), (Object[])new Object[]{blob});
        }
    }

    protected Consumer<EntityManager> beforePage() {
        return entityManager -> BaseEntityService.noop();
    }

    protected Consumer<TypedQuery<?>> onPage(Page page, boolean cacheable) {
        return typedQuery -> typedQuery.setHint("org.hibernate.cacheable", (Object)cacheable).setHint("org.hibernate.cacheRegion", (Object)page.toString());
    }

    protected Consumer<EntityManager> afterPage() {
        return entityManager -> BaseEntityService.noop();
    }

    public PartialResultList<E> getPage(Page page, boolean count) {
        return this.getPage(page, count, true, this.entityType, (builder, query, root) -> (LinkedHashMap)BaseEntityService.noop());
    }

    protected PartialResultList<E> getPage(Page page, boolean count, boolean cacheable) {
        return this.getPage(page, count, cacheable, this.entityType, (builder, query, root) -> (LinkedHashMap)BaseEntityService.noop());
    }

    protected PartialResultList<E> getPage(Page page, boolean count, QueryBuilder<E> queryBuilder) {
        return this.getPage(page, count, true, this.entityType, (builder, query, root) -> {
            queryBuilder.build(builder, query, root);
            return (LinkedHashMap)BaseEntityService.noop();
        });
    }

    protected PartialResultList<E> getPage(Page page, boolean count, boolean cacheable, QueryBuilder<E> queryBuilder) {
        return this.getPage(page, count, cacheable, this.entityType, (builder, query, root) -> {
            queryBuilder.build(builder, query, root);
            return (LinkedHashMap)BaseEntityService.noop();
        });
    }

    protected <T extends E> PartialResultList<T> getPage(Page page, boolean count, Class<T> resultType, MappedQueryBuilder<T> mappedQueryBuilder) {
        return this.getPage(page, count, true, resultType, mappedQueryBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends E> PartialResultList<T> getPage(Page page, boolean count, boolean cacheable, Class<T> resultType, MappedQueryBuilder<T> queryBuilder) {
        this.beforePage().accept(this.entityManager);
        try {
            CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(resultType);
            Root<E> root = this.buildRoot((AbstractQuery<T>)criteriaQuery);
            PathResolver pathResolver = this.buildSelection(resultType, (AbstractQuery<T>)criteriaQuery, root, criteriaBuilder, queryBuilder);
            this.buildOrderBy(page, criteriaQuery, criteriaBuilder, pathResolver);
            Map<String, Object> parameterValues = this.buildRestrictions(page, (AbstractQuery<T>)criteriaQuery, criteriaBuilder, pathResolver);
            TypedQuery typedQuery = this.entityManager.createQuery(criteriaQuery);
            this.buildRange(page, typedQuery, root);
            parameterValues.entrySet().forEach(parameter -> typedQuery.setParameter((String)parameter.getKey(), parameter.getValue()));
            this.onPage(page, cacheable).accept(typedQuery);
            List entities = typedQuery.getResultList();
            int estimatedTotalNumberOfResults = -1;
            if (count) {
                CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
                Root countRoot = countQuery.from(this.entityType);
                countQuery.select((Selection)criteriaBuilder.count((Expression)countRoot));
                if (BaseEntityService.hasRestrictions(criteriaQuery)) {
                    Subquery subQuery = countQuery.subquery(resultType);
                    Root<E> subQueryRoot = this.buildRoot((AbstractQuery<T>)subQuery);
                    pathResolver = this.buildSelection(resultType, (AbstractQuery<T>)subQuery, subQueryRoot, criteriaBuilder, queryBuilder);
                    if (this.provider == Provider.HIBERNATE && !BaseEntityService.hasJoins(root)) {
                        BaseEntityService.copyRestrictions(criteriaQuery, subQuery);
                    } else {
                        parameterValues = this.buildRestrictions(page, (AbstractQuery<T>)subQuery, criteriaBuilder, pathResolver);
                    }
                    if (this.provider == Provider.HIBERNATE) {
                        countQuery.where((Expression)criteriaBuilder.in((Expression)countRoot).value((Expression)subQuery));
                    } else if (this.provider == Provider.OPENJPA) {
                        countQuery.where((Expression)criteriaBuilder.in((Expression)countRoot.get("id")).value((Expression)subQuery));
                    } else {
                        countQuery.where((Expression)criteriaBuilder.exists(subQuery.where((Expression)BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, subQuery.getRestriction(), criteriaBuilder.equal(pathResolver.get("id"), (Expression)countRoot.get("id"))))));
                    }
                }
                TypedQuery typedCountQuery = this.entityManager.createQuery(countQuery);
                parameterValues.entrySet().forEach(parameter -> typedCountQuery.setParameter((String)parameter.getKey(), parameter.getValue()));
                this.onPage(page, cacheable).accept(typedCountQuery);
                estimatedTotalNumberOfResults = ((Long)typedCountQuery.getSingleResult()).intValue();
            }
            PartialResultList partialResultList = new PartialResultList(entities, page.getOffset(), estimatedTotalNumberOfResults);
            return partialResultList;
        }
        finally {
            this.afterPage().accept(this.entityManager);
        }
    }

    private <T extends E> Root<E> buildRoot(AbstractQuery<T> query) {
        EclipseLinkRoot root = query.from(this.entityType);
        return query instanceof Subquery ? new SubQueryRoot(root) : (this.provider == Provider.ECLIPSELINK ? new EclipseLinkRoot(root) : root);
    }

    private <T extends E> PathResolver buildSelection(Class<T> resultType, AbstractQuery<T> query, Root<E> root, CriteriaBuilder criteriaBuilder, MappedQueryBuilder<T> queryBuilder) {
        LinkedHashMap<Getter<T>, Expression<?>> mapping = queryBuilder.build(criteriaBuilder, query, root);
        if (query instanceof Subquery) {
            ((Subquery)query).select((Expression)root.get("id"));
        }
        if (!Lang.isEmpty(mapping)) {
            Map paths = Streams.stream(mapping).collect(Collectors.toMap(e -> ((Getter)e.getKey()).getPropertyName(), e -> (Expression)e.getValue(), (l, r) -> l, LinkedHashMap::new));
            if (query instanceof CriteriaQuery) {
                ((CriteriaQuery)query).multiselect(Streams.stream((Map)paths).map(Alias::as).collect(Collectors.toList()));
            }
            if (paths.values().stream().anyMatch(this.provider::isAggregation)) {
                BaseEntityService.groupByIfNecessary(query, root);
            }
            return field -> field == null ? root : (Expression)paths.get(field);
        }
        if (resultType == this.entityType) {
            return new RootPathResolver(root, ELEMENT_COLLECTION_MAPPINGS.get(this.entityType));
        }
        throw new IllegalArgumentException(ERROR_ILLEGAL_MAPPING);
    }

    private <T extends E> void buildRange(Page page, TypedQuery<T> typedQuery, Root<E> root) {
        boolean hasJoins = BaseEntityService.hasJoins(root);
        if (hasJoins || page.getOffset() != 0) {
            typedQuery.setFirstResult(page.getOffset());
        }
        if (hasJoins || page.getLimit() != Integer.MAX_VALUE) {
            typedQuery.setMaxResults(page.getLimit());
        }
        if (hasJoins && root instanceof EclipseLinkRoot) {
            ((EclipseLinkRoot)root).getPostponedFetches().forEach(fetch -> typedQuery.setHint("eclipselink.batch", (Object)("e." + fetch)));
        }
    }

    private <T extends E> void buildOrderBy(Page page, CriteriaQuery<T> criteriaQuery, CriteriaBuilder criteriaBuilder, PathResolver pathResolver) {
        Map<String, Boolean> ordering = page.getOrdering();
        if (ordering.isEmpty() || page.getLimit() - page.getOffset() == 1) {
            return;
        }
        criteriaQuery.orderBy(Streams.stream(ordering).map(order -> this.buildOrder((Map.Entry<String, Boolean>)order, criteriaBuilder, pathResolver)).collect(Collectors.toList()));
    }

    private Order buildOrder(Map.Entry<String, Boolean> order, CriteriaBuilder criteriaBuilder, PathResolver pathResolver) {
        String field = order.getKey();
        if (this.oneToManyCollections.test(field) || this.elementCollections.contains(field)) {
            if (this.provider == Provider.ECLIPSELINK) {
                throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ONETOMANY_ORDERBY_ECLIPSELINK);
            }
            if (this.provider == Provider.OPENJPA) {
                throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ONETOMANY_ORDERBY_OPENJPA);
            }
        }
        Expression<?> path = pathResolver.get(field);
        return order.getValue() != false ? criteriaBuilder.asc(path) : criteriaBuilder.desc(path);
    }

    private <T extends E> Map<String, Object> buildRestrictions(Page page, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>(page.getRequiredCriteria().size() + page.getOptionalCriteria().size());
        List<Predicate> requiredPredicates = this.buildPredicates(page.getRequiredCriteria(), query, criteriaBuilder, pathResolver, parameterValues);
        List<Predicate> optionalPredicates = this.buildPredicates(page.getOptionalCriteria(), query, criteriaBuilder, pathResolver, parameterValues);
        Predicate restriction = null;
        if (!optionalPredicates.isEmpty()) {
            restriction = criteriaBuilder.or(BaseEntityService.toArray(optionalPredicates));
        }
        if (!requiredPredicates.isEmpty()) {
            List<Predicate> wherePredicates = requiredPredicates.stream().filter(Alias::isWhere).collect(Collectors.toList());
            if (!wherePredicates.isEmpty()) {
                restriction = BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, restriction, wherePredicates);
            }
            List inPredicates = wherePredicates.stream().filter(Alias::isIn).collect(Collectors.toList());
            for (Predicate inPredicate : inPredicates) {
                Predicate countPredicate = BaseEntityService.buildCountPredicateIfNecessary(inPredicate, criteriaBuilder, query, pathResolver);
                if (countPredicate == null) continue;
                requiredPredicates.add(countPredicate);
            }
            List<Predicate> havingPredicates = requiredPredicates.stream().filter(Alias::isHaving).collect(Collectors.toList());
            if (!havingPredicates.isEmpty()) {
                BaseEntityService.groupByIfNecessary(query, pathResolver.get(null));
                query.having((Expression)BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, query.getGroupRestriction(), havingPredicates));
            }
        }
        if (restriction != null) {
            query.distinct(BaseEntityService.hasFetches((From)pathResolver.get(null))).where((Expression)BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, query.getRestriction(), restriction));
        }
        return parameterValues;
    }

    private <T extends E> List<Predicate> buildPredicates(Map<String, Object> criteria, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Map<String, Object> parameterValues) {
        return Streams.stream(criteria).map(parameter -> this.buildPredicate((Map.Entry<String, Object>)parameter, query, criteriaBuilder, pathResolver, parameterValues)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T extends E> Predicate buildPredicate(Map.Entry<String, Object> parameter, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Map<String, Object> parameterValues) {
        Expression<?> path;
        String field = parameter.getKey();
        try {
            path = pathResolver.get(field);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
        Object value = parameter.getValue();
        if (this.elementCollections.contains(field)) {
            path = pathResolver.get(pathResolver.join(field));
        }
        Class type = "id".equals(field) ? this.identifierType : path.getJavaType();
        return this.buildTypedPredicate(path, type, field, value, query, criteriaBuilder, pathResolver, new UncheckedParameterBuilder(field, criteriaBuilder, parameterValues));
    }

    private <T extends E> Predicate buildTypedPredicate(Expression<?> path, Class<?> type, String field, Object criteria, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Criteria.ParameterBuilder parameterBuilder) {
        Predicate predicate;
        boolean negated;
        Alias alias;
        block13: {
            alias = Alias.create(this.provider, path, field);
            Object value = criteria;
            negated = value instanceof Not;
            if (negated) {
                value = ((Not)value).getValue();
            }
            if (value instanceof Criteria && ((Criteria)value).getValue() == null) {
                value = null;
            }
            try {
                if (value == null) {
                    predicate = criteriaBuilder.isNull(path);
                    break block13;
                }
                if (this.elementCollections.contains(field)) {
                    predicate = this.buildInPredicate(alias, path, value, parameterBuilder);
                    break block13;
                }
                if (value instanceof Iterable || value.getClass().isArray()) {
                    predicate = this.buildArrayPredicate(path, type, field, value, query, criteriaBuilder, pathResolver, parameterBuilder);
                    break block13;
                }
                if (value instanceof Criteria) {
                    predicate = ((Criteria)value).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                if (type.isEnum()) {
                    predicate = Enumerated.parse(value, type).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                if (Number.class.isAssignableFrom(type)) {
                    predicate = Numeric.parse(value, type).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                if (Boolean.class.isAssignableFrom(type)) {
                    predicate = Bool.parse(value).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                if (String.class.isAssignableFrom(type) || value instanceof String) {
                    predicate = IgnoreCase.value(value.toString()).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                throw new UnsupportedOperationException(String.format(ERROR_UNSUPPORTED_CRITERIA, field, type, value, value.getClass()));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (negated) {
            predicate = criteriaBuilder.not((Expression)predicate);
        }
        alias.set(predicate);
        return predicate;
    }

    private Predicate buildInPredicate(Alias alias, Expression<?> path, Object value, Criteria.ParameterBuilder parameterBuilder) {
        Class type = path.getJavaType();
        List<Expression> in = Streams.stream((Object)value).map(item -> {
            Object searchValue = Criteria.unwrap(item);
            if (type.isEnum()) {
                try {
                    return Enumerated.parse(searchValue, type).getValue();
                }
                catch (IllegalArgumentException ignore) {
                    return null;
                }
            }
            return searchValue;
        }).filter(Objects::nonNull).map(parameterBuilder::create).collect(Collectors.toList());
        if (in.isEmpty()) {
            throw new IllegalArgumentException(value.toString());
        }
        alias.in(in.size());
        return path.in(in.toArray(new Expression[in.size()]));
    }

    private <T extends E> Predicate buildArrayPredicate(Expression<?> path, Class<?> type, String field, Object value, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Criteria.ParameterBuilder parameterBuilder) {
        Expression<?> oneToManyPath;
        Subquery oneToManySubQuery = null;
        if (this.oneToManyCollections.test(field)) {
            if (this.provider == Provider.ECLIPSELINK) {
                throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ONETOMANY_CRITERIA_ECLIPSELINK);
            }
            if (this.provider == Provider.OPENJPA) {
                throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ONETOMANY_CRITERIA_OPENJPA);
            }
            oneToManySubQuery = query.subquery(Long.class);
            Root subQueryRoot = oneToManySubQuery.from(this.entityType);
            oneToManyPath = new RootPathResolver(subQueryRoot, this.elementCollections).get(pathResolver.join(field));
            oneToManySubQuery.select(criteriaBuilder.countDistinct(oneToManyPath)).where((Expression)criteriaBuilder.equal(pathResolver.get("id"), (Expression)subQueryRoot.get("id")));
        } else {
            oneToManyPath = path;
        }
        List<Predicate> predicates = Streams.stream((Object)value).map(item -> this.buildTypedPredicate(oneToManyPath, type, field, item, query, criteriaBuilder, pathResolver, parameterBuilder)).filter(Objects::nonNull).collect(Collectors.toList());
        if (predicates.isEmpty()) {
            throw new IllegalArgumentException(value.toString());
        }
        Predicate predicate = criteriaBuilder.or(BaseEntityService.toArray(predicates));
        if (oneToManySubQuery != null) {
            Long actualCount = predicates.size();
            predicate = criteriaBuilder.equal((Expression)oneToManySubQuery.where((Expression)criteriaBuilder.and((Expression)predicate, (Expression)oneToManySubQuery.getRestriction())), (Object)actualCount);
            Alias.create(this.provider, pathResolver.get(pathResolver.join(field)), field).set(predicate);
        }
        return predicate;
    }

    private static Predicate[] toArray(List<Predicate> predicates) {
        return predicates.toArray(new Predicate[predicates.size()]);
    }

    private static Predicate conjunctRestrictionsIfNecessary(CriteriaBuilder criteriaBuilder, Predicate nullable, Predicate nonnullable) {
        return nullable == null ? nonnullable : criteriaBuilder.and((Expression)nullable, (Expression)nonnullable);
    }

    private static Predicate conjunctRestrictionsIfNecessary(CriteriaBuilder criteriaBuilder, Predicate nullable, List<Predicate> nonnullable) {
        return BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, nullable, criteriaBuilder.and(BaseEntityService.toArray(nonnullable)));
    }

    private static Predicate buildCountPredicateIfNecessary(Predicate inPredicate, CriteriaBuilder criteriaBuilder, AbstractQuery<?> query, PathResolver pathResolver) {
        Map.Entry<String, Long> fieldAndCount = Alias.getFieldAndCount(inPredicate);
        if (fieldAndCount.getValue() > 1L) {
            Expression<?> join = pathResolver.get(pathResolver.join(fieldAndCount.getKey()));
            Predicate countPredicate = criteriaBuilder.equal(criteriaBuilder.countDistinct(join), (Object)fieldAndCount.getValue());
            Alias.setHaving(inPredicate, countPredicate);
            BaseEntityService.groupByIfNecessary(query, pathResolver.get(fieldAndCount.getKey()));
            return countPredicate;
        }
        return null;
    }

    private static void groupByIfNecessary(AbstractQuery<?> query, Expression<?> path) {
        Expression<?> groupByPath;
        Object object = groupByPath = path instanceof RootWrapper ? ((RootWrapper)path).getWrapped() : path;
        if (!query.getGroupList().contains(groupByPath)) {
            ArrayList groupList = new ArrayList(query.getGroupList());
            groupList.add(groupByPath);
            query.groupBy(groupList);
        }
    }

    private static boolean hasRestrictions(AbstractQuery<?> query) {
        return query.getRestriction() != null || !query.getGroupList().isEmpty() || query.getGroupRestriction() != null;
    }

    private static boolean hasJoins(From<?, ?> from) {
        return !from.getJoins().isEmpty() || BaseEntityService.hasFetches(from);
    }

    private static boolean hasFetches(From<?, ?> from) {
        return from.getFetches().stream().anyMatch(fetch -> fetch instanceof Path) || from instanceof EclipseLinkRoot && !((EclipseLinkRoot)from).getPostponedFetches().isEmpty();
    }

    private static Map<String, Path<?>> getJoins(From<?, ?> from) {
        HashMap joins = new HashMap((Map)from.getJoins().stream().collect(org.omnifaces.utils.stream.Collectors.toMap(join -> join.getAttribute().getName())));
        joins.putAll(from.getFetches().stream().filter(fetch -> fetch instanceof Path).collect(Collectors.toMap(fetch -> fetch.getAttribute().getName(), fetch -> (Path)fetch)));
        if (from instanceof EclipseLinkRoot) {
            ((EclipseLinkRoot)from).getPostponedFetches().forEach(fetch -> joins.put((String)fetch, (Path<?>)from.get(fetch)));
        }
        return joins;
    }

    private static void copyRestrictions(AbstractQuery<?> source, AbstractQuery<?> target) {
        if (source.getRestriction() != null) {
            target.where((Expression)source.getRestriction());
        }
        target.groupBy(source.getGroupList());
        if (source.getGroupRestriction() != null) {
            target.having((Expression)source.getGroupRestriction());
        }
    }

    private static <T> T noop() {
        return null;
    }

    private static class UncheckedParameterBuilder
    implements Criteria.ParameterBuilder {
        private String field;
        private CriteriaBuilder criteriaBuilder;
        private Map<String, Object> parameterValues;

        private UncheckedParameterBuilder(String field, CriteriaBuilder criteriaBuilder, Map<String, Object> parameterValues) {
            this.field = field.replace(".", "_") + "_";
            this.criteriaBuilder = criteriaBuilder;
            this.parameterValues = parameterValues;
        }

        @Override
        public <T> ParameterExpression<T> create(Object value) {
            String name = this.field + this.parameterValues.size();
            this.parameterValues.put(name, value);
            return this.criteriaBuilder.parameter(value.getClass(), name);
        }
    }

    private static class Alias {
        private static final String AS = "as_";
        private static final String WHERE = "where_";
        private static final String HAVING = "having_";
        private static final String IN = "_in";
        private String value;

        private Alias(String alias) {
            this.value = alias;
        }

        public static Selection<?> as(Map.Entry<String, Expression<?>> mappingEntry) {
            Selection selection = (Selection)mappingEntry.getValue();
            return selection.getAlias() != null ? selection : selection.alias(AS + mappingEntry.getKey().replace(".", "_"));
        }

        public static Alias create(Provider provider, Expression<?> expression, String field) {
            return new Alias((provider.isAggregation(expression) ? HAVING : WHERE) + field.replace(".", "$"));
        }

        public void in(int count) {
            this.value = this.value + "_" + count + IN;
        }

        public void set(Predicate predicate) {
            predicate.alias(this.value);
        }

        public static boolean isWhere(Predicate predicate) {
            return predicate.getAlias().startsWith(WHERE);
        }

        public static boolean isIn(Predicate predicate) {
            return predicate.getAlias().endsWith(IN);
        }

        public static boolean isHaving(Predicate predicate) {
            return predicate.getAlias().startsWith(HAVING);
        }

        public static Map.Entry<String, Long> getFieldAndCount(Predicate inPredicate) {
            String alias = inPredicate.getAlias();
            String fieldAndCount = alias.substring(alias.indexOf(95) + 1, alias.lastIndexOf(95));
            String field = fieldAndCount.substring(0, fieldAndCount.lastIndexOf(95)).replace('$', '.');
            long count = Long.valueOf(fieldAndCount.substring(field.length() + 1));
            return new AbstractMap.SimpleEntry<String, Long>(field, count);
        }

        public static void setHaving(Predicate inPredicate, Predicate countPredicate) {
            countPredicate.alias(HAVING + inPredicate.getAlias().substring(inPredicate.getAlias().indexOf("_") + 1));
        }
    }

    private static class RootPathResolver
    implements PathResolver {
        private Root<?> root;
        private Map<String, Path<?>> joins;
        private Map<String, Path<?>> paths;
        private Set<String> elementCollections;

        private RootPathResolver(Root<?> root, Set<String> elementCollections) {
            this.root = root;
            this.joins = BaseEntityService.getJoins(root);
            this.paths = new HashMap();
            this.elementCollections = elementCollections;
        }

        @Override
        public Expression<?> get(String field) {
            if (field == null) {
                return this.root;
            }
            Object path = this.paths.get(field);
            if (path != null) {
                return path;
            }
            path = this.root;
            boolean explicitJoin = field.charAt(0) == '@';
            String originalField = explicitJoin ? field.substring(1) : field;
            String[] attributes = originalField.split("\\.");
            int depth = attributes.length;
            for (int i = 0; i < depth; ++i) {
                String attribute = attributes[i];
                path = i + 1 < depth || this.elementCollections.contains(originalField) ? (explicitJoin ? ((From)path).join(attribute) : this.joins.get(attribute)) : path.get(attribute);
            }
            this.paths.put(field, (Path<?>)path);
            return path;
        }
    }

    @FunctionalInterface
    private static interface PathResolver {
        public Expression<?> get(String var1);

        default public String join(String field) {
            return '@' + field;
        }
    }

    @FunctionalInterface
    protected static interface MappedQueryBuilder<T> {
        public LinkedHashMap<Getter<T>, Expression<?>> build(CriteriaBuilder var1, AbstractQuery<T> var2, Root<? super T> var3);
    }

    @FunctionalInterface
    protected static interface QueryBuilder<E> {
        public void build(CriteriaBuilder var1, AbstractQuery<E> var2, Root<E> var3);
    }
}

