/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.omnifaces.persistence.listener.BaseEntityListener;
import org.omnifaces.persistence.model.Identifiable;

@MappedSuperclass
@EntityListeners(value={BaseEntityListener.class})
public abstract class BaseEntity<I extends Comparable<I> & Serializable>
implements Comparable<BaseEntity<I>>,
Identifiable<I>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private I id;

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public void setId(I id) {
        this.id = id;
    }

    public int hashCode() {
        return this.getId() != null ? Objects.hash(this.getClass().getSimpleName(), this.getId()) : super.hashCode();
    }

    public boolean equals(Object other) {
        return other != null && this.getId() != null && other.getClass().isAssignableFrom(this.getClass()) && this.getClass().isAssignableFrom(other.getClass()) ? this.getId().equals(((BaseEntity)other).getId()) : other == this;
    }

    @Override
    public int compareTo(BaseEntity<I> other) {
        return other == null ? -1 : (this.getId() == null ? (other.getId() == null ? 0 : 1) : this.getId().compareTo(other.getId()));
    }

    public String toString() {
        return String.format("%s[id=%d]", this.getClass().getSimpleName(), this.getId());
    }
}

