/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.criteria;

import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.omnifaces.persistence.criteria.Criteria;

public final class Enumerated
extends Criteria<Enum<?>> {
    private Enumerated(Enum<?> value) {
        super(value);
    }

    public static Enumerated value(Enum<?> value) {
        return new Enumerated(value);
    }

    public static Enumerated parse(Object searchValue, Class<Enum<?>> targetType) {
        return new Enumerated(Enumerated.parseEnum(searchValue, targetType));
    }

    @Override
    public Predicate build(Expression<?> path, CriteriaBuilder criteriaBuilder, Criteria.ParameterBuilder parameterBuilder) {
        return criteriaBuilder.equal(path, parameterBuilder.create(this.getValue()));
    }

    @Override
    public boolean applies(Object modelValue) {
        return modelValue != null && Objects.equals(Enumerated.parseEnum(modelValue, ((Enum)this.getValue()).getClass()), this.getValue());
    }

    private static Enum<?> parseEnum(Object searchValue, Class<?> targetType) throws IllegalArgumentException {
        if (searchValue instanceof Enum) {
            return (Enum)searchValue;
        }
        if (targetType.isEnum()) {
            for (Enum enumConstant : (Enum[])targetType.getEnumConstants()) {
                if (!enumConstant.name().equalsIgnoreCase(searchValue.toString())) continue;
                return enumConstant;
            }
        }
        throw new IllegalArgumentException(searchValue.toString());
    }
}

