/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.criteria;

import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;

public abstract class Criteria<T> {
    private T value;

    protected Criteria(T value) {
        this(value, false);
    }

    Criteria(T value, boolean nestable) {
        if (value instanceof Criteria && (!nestable || value.getClass() == this.getClass())) {
            throw new IllegalArgumentException("You cannot nest " + value + " in " + this);
        }
        if (!nestable && value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
    }

    public abstract Predicate build(Expression<?> var1, CriteriaBuilder var2, ParameterBuilder var3);

    public boolean applies(Object modelValue) {
        throw new UnsupportedOperationException("This method is not implemented yet.");
    }

    public T getValue() {
        return this.value;
    }

    public static Object unwrap(Object possibleCriteria) {
        Object value = possibleCriteria;
        while (value instanceof Criteria) {
            value = ((Criteria)possibleCriteria).getValue();
        }
        return value;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.value);
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().isAssignableFrom(object.getClass()) && (object == this || Objects.equals(this.value, ((Criteria)object).value));
    }

    public String toString() {
        return this.getClass().getSimpleName().toUpperCase() + "(" + this.getValue() + ")";
    }

    @FunctionalInterface
    public static interface ParameterBuilder {
        public <T> ParameterExpression<T> create(Object var1);
    }
}

