/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.criteria;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.omnifaces.persistence.criteria.Criteria;
import org.omnifaces.utils.data.Range;

public final class Between<T extends Comparable<T>>
extends Criteria<Range<T>> {
    private Between(Range<T> value) {
        super(value);
    }

    public static <T extends Comparable<T>> Between<T> value(Range<T> value) {
        return new Between<T>(value);
    }

    public static <T extends Comparable<T>> Between<T> range(T min, T max) {
        return new Between<T>(Range.ofClosed(min, max));
    }

    @Override
    public Predicate build(Expression<?> path, CriteriaBuilder criteriaBuilder, Criteria.ParameterBuilder parameterBuilder) {
        return criteriaBuilder.between(path, parameterBuilder.create(((Range)this.getValue()).getMin()), parameterBuilder.create(((Range)this.getValue()).getMax()));
    }

    @Override
    public boolean applies(Object modelValue) {
        return modelValue instanceof Comparable && ((Range)this.getValue()).contains((Object)((Comparable)modelValue));
    }

    @Override
    public String toString() {
        Range range = (Range)this.getValue();
        return "BETWEEN " + range.getMin() + " AND " + range.getMax();
    }
}

