/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.spi.CDI;
import javax.persistence.ElementCollection;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.criteria.Expression;
import javax.persistence.metamodel.Attribute;
import org.omnifaces.utils.Collections;
import org.omnifaces.utils.reflect.Reflections;

public enum Provider {
    HIBERNATE{

        @Override
        public String getDialectName(EntityManagerFactory entityManagerFactory) {
            return Reflections.invokeMethod((Object)Reflections.invokeMethod((Object)entityManagerFactory, (String)"getSessionFactory", (Object[])new Object[0]), (String)"getDialect", (Object[])new Object[0]).getClass().getSimpleName();
        }

        @Override
        public boolean isAggregation(Expression<?> expression) {
            return ((Class)HIBERNATE_BASIC_FUNCTION_EXPRESSION.get()).isInstance(expression) && (Boolean)Reflections.invokeMethod(expression, (String)"isAggregation", (Object[])new Object[0]) != false;
        }

        @Override
        public boolean isProxy(Object object) {
            return ((Class)HIBERNATE_PROXY_CLASS.get()).isInstance(object);
        }

        @Override
        public <E> E dereferenceProxy(E entity) {
            return (E)(this.isProxy(entity) ? Reflections.invokeMethod((Object)Reflections.invokeMethod(entity, (String)"getHibernateLazyInitializer", (Object[])new Object[0]), (String)"getImplementation", (Object[])new Object[0]) : entity);
        }
    }
    ,
    ECLIPSELINK{

        @Override
        public String getDialectName(EntityManagerFactory entityManagerFactory) {
            return Reflections.invokeMethod((Object)Reflections.invokeMethod((Object)entityManagerFactory, (String)"getDatabaseSession", (Object[])new Object[0]), (String)"getDatasourcePlatform", (Object[])new Object[0]).getClass().getSimpleName();
        }

        @Override
        public boolean isAggregation(Expression<?> expression) {
            return ((Class)ECLIPSELINK_FUNCTION_EXPRESSION_IMPL.get()).isInstance(expression) && AGGREGATE_FUNCTIONS.contains(Reflections.invokeMethod(expression, (String)"getOperation", (Object[])new Object[0]));
        }
    }
    ,
    OPENJPA{

        @Override
        public String getDialectName(EntityManagerFactory entityManagerFactory) {
            Optional getDelegate = Reflections.findMethod((Object)entityManagerFactory, (String)"getDelegate", (Object[])new Object[0]);
            EntityManagerFactory openjpaEntityManagerFactory = getDelegate.isPresent() ? Reflections.invokeMethod((Object)entityManagerFactory, (Method)((Method)getDelegate.get()), (Object[])new Object[0]) : entityManagerFactory;
            return Reflections.invokeMethod((Object)Reflections.invokeMethod((Object)openjpaEntityManagerFactory, (String)"getConfiguration", (Object[])new Object[0]), (String)"getDBDictionaryInstance", (Object[])new Object[0]).getClass().getSimpleName();
        }

        @Override
        public boolean isAggregation(Expression<?> expression) {
            return AGGREGATE_FUNCTIONS.contains(expression.getClass().getSimpleName().toUpperCase());
        }

        @Override
        public boolean isElementCollection(Attribute<?, ?> attribute) {
            return ((Field)attribute.getJavaMember()).getAnnotation(ElementCollection.class) != null;
        }
    }
    ,
    UNKNOWN;

    private static final Optional<Class<Object>> HIBERNATE_PROXY_CLASS;
    private static final Optional<Class<Object>> HIBERNATE_BASIC_FUNCTION_EXPRESSION;
    private static final Optional<Class<Object>> ECLIPSELINK_FUNCTION_EXPRESSION_IMPL;
    private static final Set<String> AGGREGATE_FUNCTIONS;

    static Provider of(EntityManager entityManager) {
        String packageName = entityManager.getDelegate().getClass().getPackage().getName();
        if (packageName.startsWith("org.hibernate.")) {
            return HIBERNATE;
        }
        if (packageName.startsWith("org.eclipse.persistence.")) {
            return ECLIPSELINK;
        }
        if (packageName.startsWith("org.apache.openjpa.")) {
            return OPENJPA;
        }
        return UNKNOWN;
    }

    public static boolean is(Provider provider) {
        return Provider.current() == provider;
    }

    public static Provider current() {
        return (Provider)((Object)CDI.current().select(Provider.class, new Annotation[0]).get());
    }

    public String getDialectName(EntityManagerFactory entityManagerFactory) {
        throw new UnsupportedOperationException(String.valueOf(entityManagerFactory));
    }

    public boolean isAggregation(Expression<?> expression) {
        throw new UnsupportedOperationException(String.valueOf(expression));
    }

    public boolean isElementCollection(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }

    public boolean isProxy(Object entity) {
        throw new UnsupportedOperationException(String.valueOf(entity));
    }

    public <E> E dereferenceProxy(E entity) {
        throw new UnsupportedOperationException(String.valueOf(entity));
    }

    static {
        HIBERNATE_PROXY_CLASS = Reflections.findClass((String)"org.hibernate.proxy.HibernateProxy");
        HIBERNATE_BASIC_FUNCTION_EXPRESSION = Reflections.findClass((String)"org.hibernate.jpa.criteria.expression.function.BasicFunctionExpression");
        ECLIPSELINK_FUNCTION_EXPRESSION_IMPL = Reflections.findClass((String)"org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl");
        AGGREGATE_FUNCTIONS = Collections.unmodifiableSet((Object[])new Object[]{"MIN", "MAX", "SUM", "AVG", "COUNT"});
    }
}

