/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.omnifaces.persistence.Database;
import org.omnifaces.persistence.Provider;
import org.omnifaces.utils.reflect.Reflections;
import org.omnifaces.utils.stream.Streams;

public final class JPA {
    public static final String LOAD_GRAPH_HINT_KEY = "javax.persistence.loadgraph";
    public static final String FETCH_GRAPH_HINT_KEY = "javax.persistence.fetchgraph";
    public static final String CACHE_RETRIEVE_MODE_HINT_KEY = "javax.persistence.cache.retrieveMode";
    private static final Optional<Class<Object>> HIBERNATE_PROXY_CLASS = Reflections.findClass((String)"org.hibernate.proxy.HibernateProxy");

    private JPA() {
    }

    public static <T> T getOptionalSingleResult(TypedQuery<T> query) {
        try {
            query.setMaxResults(1);
            return (T)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public static <T> Optional<T> getOptional(TypedQuery<T> query) {
        try {
            query.setMaxResults(1);
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public static <K, T> Map<K, T> getResultMap(TypedQuery<T> query, Function<? super T, ? extends K> keyMapper) {
        return (Map)query.getResultList().stream().collect(org.omnifaces.utils.stream.Collectors.toMap(keyMapper));
    }

    public static <K, T, V> Map<K, V> getResultMap(TypedQuery<T> query, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return query.getResultList().stream().collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public static <T> T getOptionalSingleResult(Query query, Class<T> type) {
        try {
            query.setMaxResults(1);
            return type.cast(query.getSingleResult());
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public static <T, I> Long getForeignKeyReferences(Class<T> entityClass, Class<I> idType, I entityId, EntityManager entityManager) {
        Metamodel metamodel = entityManager.getMetamodel();
        EntityType entityType = metamodel.entity(entityClass);
        SingularAttribute idAttribute = entityType.getId(idType);
        return metamodel.getEntities().stream().flatMap(entity -> JPA.getAttributesOfType(entity, entityClass)).distinct().mapToLong(attribute -> JPA.countReferencesTo(entityManager, attribute, idAttribute, entityId)).sum();
    }

    private static <T, E> Stream<Attribute<?, ?>> getAttributesOfType(EntityType<T> entityType, Class<E> entityClass) {
        return entityType.getAttributes().stream().filter(attribute -> {
            if (attribute instanceof PluralAttribute) {
                return entityClass.equals(((PluralAttribute)attribute).getElementType().getJavaType());
            }
            return entityClass.equals(attribute.getJavaType());
        }).map(attribute -> attribute);
    }

    private static <R, T, I> Long countReferencesTo(EntityManager entityManager, Attribute<R, ?> attribute, SingularAttribute<? super T, I> idAttribute, I id) {
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
        Root root = query.from(attribute.getDeclaringType().getJavaType());
        if (attribute instanceof SingularAttribute) {
            Join relation = root.join((SingularAttribute)attribute);
            query.where((Expression)criteriaBuilder.equal((Expression)relation.get(idAttribute), id));
        } else if (attribute instanceof ListAttribute) {
            ListJoin relation = root.join((ListAttribute)attribute);
            query.where((Expression)criteriaBuilder.equal((Expression)relation.get(idAttribute), id));
        } else if (attribute instanceof SetAttribute) {
            SetJoin relation = root.join((SetAttribute)attribute);
            query.where((Expression)criteriaBuilder.equal((Expression)relation.get(idAttribute), id));
        } else if (attribute instanceof MapAttribute) {
            MapJoin relation = root.join((MapAttribute)attribute);
            query.where((Expression)criteriaBuilder.equal((Expression)relation.get(idAttribute), id));
        } else if (attribute instanceof CollectionAttribute) {
            CollectionJoin relation = root.join((CollectionAttribute)attribute);
            query.where((Expression)criteriaBuilder.equal((Expression)relation.get(idAttribute), id));
        } else {
            return 0L;
        }
        query.select((Selection)criteriaBuilder.count((Expression)root));
        return (Long)entityManager.createQuery(query).getSingleResult();
    }

    @Deprecated
    public static boolean isProxy(Object object) {
        return JPA.isHibernateProxy(object);
    }

    private static boolean isHibernateProxy(Object object) {
        return HIBERNATE_PROXY_CLASS.isPresent() && HIBERNATE_PROXY_CLASS.get().isInstance(object);
    }

    @Deprecated
    public static <E> E dereferenceProxy(E entity) {
        if (JPA.isHibernateProxy(entity)) {
            return (E)Reflections.invokeMethod((Object)Reflections.invokeMethod(entity, (String)"getHibernateLazyInitializer", (Object[])new Object[0]), (String)"getImplementation", (Object[])new Object[0]);
        }
        throw new UnsupportedOperationException();
    }

    public static Expression<String> concat(CriteriaBuilder builder, Object ... expressionsOrStrings) {
        if (expressionsOrStrings.length < 2) {
            throw new IllegalArgumentException("There must be at least 2 expressions or strings");
        }
        List<Expression> expressions = Streams.stream((Object[])expressionsOrStrings).map(expressionOrString -> {
            if (expressionOrString instanceof Expression) {
                return JPA.castAsString(builder, (Expression)expressionOrString);
            }
            return builder.literal(expressionOrString);
        }).collect(Collectors.toList());
        return builder.function("CONCAT", String.class, expressions.toArray(new Expression[expressions.size()]));
    }

    public static Expression<String> castAsString(CriteriaBuilder builder, Expression<?> expression) {
        boolean numeric = Number.class.isAssignableFrom(expression.getJavaType());
        if (!numeric || Provider.is(Provider.HIBERNATE)) {
            return expression.as(String.class);
        }
        if (Database.is(Database.POSTGRESQL)) {
            return builder.function("TO_CHAR", String.class, new Expression[]{expression, builder.literal((Object)"FM999999999999999999")});
        }
        return expression;
    }
}

