/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence;

import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.omnifaces.persistence.Database;
import org.omnifaces.persistence.Provider;

@ApplicationScoped
public class Environment {
    private static final Logger logger = Logger.getLogger(Environment.class.getName());
    private Provider provider;
    private Database database;
    @PersistenceContext
    private EntityManager entityManager;
    @PersistenceUnit
    private EntityManagerFactory entityManagerFactory;

    @PostConstruct
    public void init() {
        this.provider = Provider.of(this.entityManager);
        this.database = Database.of(this.provider, this.entityManagerFactory);
        logger.info("Using OmniPersistence with provider " + (Object)((Object)this.provider) + " and database " + (Object)((Object)this.database));
    }

    @Produces
    public Provider getProvider() {
        return this.provider;
    }

    @Produces
    public Database getDatabase() {
        return this.database;
    }
}

