/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import org.omnifaces.persistence.criteria.Bool;
import org.omnifaces.persistence.criteria.Criteria;
import org.omnifaces.persistence.criteria.Enumerated;
import org.omnifaces.persistence.criteria.IgnoreCase;
import org.omnifaces.persistence.criteria.Like;
import org.omnifaces.persistence.criteria.Not;
import org.omnifaces.persistence.criteria.Numeric;
import org.omnifaces.persistence.exception.IllegalEntityStateException;
import org.omnifaces.persistence.exception.NonDeletableEntityException;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.model.NonDeletable;
import org.omnifaces.persistence.model.dto.Page;
import org.omnifaces.persistence.service.SubQueryRoot;
import org.omnifaces.utils.Lang;
import org.omnifaces.utils.collection.PartialResultList;
import org.omnifaces.utils.reflect.Getter;
import org.omnifaces.utils.reflect.Reflections;
import org.omnifaces.utils.stream.Streams;

public abstract class BaseEntityService<I extends Comparable<I> & Serializable, E extends BaseEntity<I>> {
    private static final Map<Class<?>, AbstractMap.SimpleEntry<Class<?>, Class<?>>> TYPE_MAPPINGS = new ConcurrentHashMap();
    private static final String ERROR_ILLEGAL_MAPPING = "You must return a getter-path mapping from MappedQueryBuilder";
    private static final String ERROR_UNSUPPORTED_CRITERIA = "Predicate for %s(%s) = %s(%s) is not supported. Consider wrapping in a Criteria instance or creating a custom one if you want to deal with it.";
    private final Class<I> identifierType;
    private final Class<E> entityType;
    @PersistenceContext
    private EntityManager entityManager;

    public BaseEntityService() {
        AbstractMap.SimpleEntry typeMapping = TYPE_MAPPINGS.computeIfAbsent(this.getClass(), BaseEntityService::computeTypeMapping);
        this.identifierType = (Class)typeMapping.getKey();
        this.entityType = (Class)typeMapping.getValue();
    }

    private static AbstractMap.SimpleEntry<Class<?>, Class<?>> computeTypeMapping(Class<?> type) {
        Type actualType = type.getGenericSuperclass();
        HashMap typeMapping = new HashMap();
        while (!(actualType instanceof ParameterizedType) || !BaseEntityService.class.equals((Object)((ParameterizedType)actualType).getRawType())) {
            if (actualType instanceof ParameterizedType) {
                Class rawType = (Class)((ParameterizedType)actualType).getRawType();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; i < typeParameters.length; ++i) {
                    Type typeArgument = ((ParameterizedType)actualType).getActualTypeArguments()[i];
                    typeMapping.put(typeParameters[i], typeArgument instanceof TypeVariable ? (Type)typeMapping.get(typeArgument) : typeArgument);
                }
                actualType = rawType;
            }
            actualType = ((Class)actualType).getGenericSuperclass();
        }
        return new AbstractMap.SimpleEntry(BaseEntityService.getActualTypeArgument(actualType, 0, typeMapping), BaseEntityService.getActualTypeArgument(actualType, 1, typeMapping));
    }

    private static Class<?> getActualTypeArgument(Type type, int index, Map<TypeVariable<?>, Type> typeMapping) {
        Type actualTypeArgument = ((ParameterizedType)type).getActualTypeArguments()[index];
        if (actualTypeArgument instanceof TypeVariable) {
            actualTypeArgument = typeMapping.get(actualTypeArgument);
        }
        return (Class)actualTypeArgument;
    }

    protected final TypedQuery<E> createQuery(String jpqlStatement) {
        return this.entityManager.createQuery(jpqlStatement, this.entityType);
    }

    protected final TypedQuery<E> createNamedQuery(String name) {
        return this.entityManager.createNamedQuery(name, this.entityType);
    }

    public Optional<E> findById(I id) {
        return Optional.ofNullable(this.getById(id));
    }

    public E getById(I id) {
        return (E)((BaseEntity)this.entityManager.find(this.entityType, id));
    }

    public List<E> getAll() {
        return this.createQuery("SELECT e FROM " + this.entityType.getSimpleName() + " e ORDER BY id DESC").getResultList();
    }

    public I persist(E entity) {
        if (((BaseEntity)entity).getId() != null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has an ID. Use update() instead.");
        }
        this.entityManager.persist(entity);
        return ((BaseEntity)entity).getId();
    }

    public E update(E entity) {
        if (((BaseEntity)entity).getId() == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has no ID. Use persist() instead.");
        }
        return (E)((BaseEntity)this.entityManager.merge(entity));
    }

    public E save(E entity) {
        if (((BaseEntity)entity).getId() == null) {
            return this.getById(this.persist(entity));
        }
        return this.update(entity);
    }

    public void refresh(E entity) {
        if (((BaseEntity)entity).getId() == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has no ID.");
        }
        Object managed = this.getById(((BaseEntity)entity).getId());
        if (managed == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has in meanwhile been deleted.");
        }
        this.entityManager.getMetamodel().entity(managed.getClass()).getAttributes().forEach(a -> Reflections.map((Member)a.getJavaMember(), (Object)managed, (Object)entity));
    }

    public void delete(E entity) {
        if (entity.getClass().isAnnotationPresent(NonDeletable.class)) {
            throw new NonDeletableEntityException((BaseEntity<?>)entity);
        }
        this.entityManager.remove(this.manage(entity));
    }

    protected final E manage(E entity) {
        if (((BaseEntity)entity).getId() == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has no ID.");
        }
        if (this.entityManager.contains(entity)) {
            return entity;
        }
        E managed = this.getById(((BaseEntity)entity).getId());
        if (managed == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has in meanwhile been deleted.");
        }
        return managed;
    }

    @SafeVarargs
    protected final void fetchLazyCollections(E entity, Function<E, Collection<?>> ... getters) {
        if (!Lang.isEmpty((Object[])getters)) {
            Streams.stream((Object[])getters).forEach(getter -> ((Collection)getter.apply(entity)).size());
        } else {
            this.fetchEveryPluralAttribute(entity, type -> type != PluralAttribute.CollectionType.MAP);
        }
    }

    @SafeVarargs
    protected final void fetchLazyMaps(E entity, Function<E, Map<?, ?>> ... getters) {
        if (!Lang.isEmpty((Object[])getters)) {
            Streams.stream((Object[])getters).forEach(getter -> ((Map)getter.apply(entity)).size());
        } else {
            this.fetchEveryPluralAttribute(entity, type -> type == PluralAttribute.CollectionType.MAP);
        }
    }

    private void fetchEveryPluralAttribute(E entity, java.util.function.Predicate<PluralAttribute.CollectionType> ofType) {
        for (PluralAttribute a : this.entityManager.getMetamodel().entity(entity.getClass()).getPluralAttributes()) {
            if (!ofType.test(a.getCollectionType())) continue;
            String name = Character.toUpperCase(a.getName().charAt(0)) + a.getName().substring(1);
            Reflections.invokeMethod((Object)Reflections.invokeMethod(entity, (String)("get" + name), (Object[])new Object[0]), (String)"size", (Object[])new Object[0]);
        }
    }

    protected final void fetchLazyBlobs(E entity) {
        BaseEntity managed = (BaseEntity)this.entityManager.merge(entity);
        for (Attribute a : this.entityManager.getMetamodel().entity(managed.getClass()).getSingularAttributes()) {
            if (a.getJavaType() != byte[].class) continue;
            String name = Character.toUpperCase(a.getName().charAt(0)) + a.getName().substring(1);
            byte[] blob = (byte[])Reflections.invokeMethod((Object)managed, (String)("get" + name), (Object[])new Object[0]);
            Reflections.invokeMethod(entity, (String)("set" + name), (Object[])new Object[]{blob});
        }
    }

    protected Consumer<EntityManager> beforePage() {
        return entityManager -> BaseEntityService.noop();
    }

    protected Consumer<TypedQuery<?>> onPage(Page page, boolean cacheable) {
        return typedQuery -> typedQuery.setHint("org.hibernate.cacheable", (Object)cacheable).setHint("org.hibernate.cacheRegion", (Object)page.toString());
    }

    protected Consumer<EntityManager> afterPage() {
        return entityManager -> BaseEntityService.noop();
    }

    public PartialResultList<E> getPage(Page page, boolean count) {
        return this.getPage(page, count, true, this.entityType, (builder, query, root) -> (LinkedHashMap)BaseEntityService.noop());
    }

    protected PartialResultList<E> getPage(Page page, boolean count, boolean cacheable) {
        return this.getPage(page, count, cacheable, this.entityType, (builder, query, root) -> (LinkedHashMap)BaseEntityService.noop());
    }

    protected PartialResultList<E> getPage(Page page, boolean count, QueryBuilder<E> queryBuilder) {
        return this.getPage(page, count, true, this.entityType, (builder, query, root) -> {
            queryBuilder.build(builder, query, root);
            return (LinkedHashMap)BaseEntityService.noop();
        });
    }

    protected PartialResultList<E> getPage(Page page, boolean count, boolean cacheable, QueryBuilder<E> queryBuilder) {
        return this.getPage(page, count, cacheable, this.entityType, (builder, query, root) -> {
            queryBuilder.build(builder, query, root);
            return (LinkedHashMap)BaseEntityService.noop();
        });
    }

    protected <T extends E> PartialResultList<T> getPage(Page page, boolean count, Class<T> resultType, MappedQueryBuilder<T> mappedQueryBuilder) {
        return this.getPage(page, count, true, resultType, mappedQueryBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends E> PartialResultList<T> getPage(Page page, boolean count, boolean cacheable, Class<T> resultType, MappedQueryBuilder<T> queryBuilder) {
        this.beforePage().accept(this.entityManager);
        try {
            CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(resultType);
            Root root = criteriaQuery.from(this.entityType);
            PathResolver pathResolver = this.buildSelection(criteriaBuilder, (AbstractQuery<T>)criteriaQuery, (Root<E>)root, resultType, queryBuilder);
            this.buildOrderBy(page, criteriaBuilder, criteriaQuery, pathResolver);
            Map<String, Object> parameterValues = this.buildRestrictions(page, criteriaBuilder, (AbstractQuery<T>)criteriaQuery, pathResolver);
            TypedQuery typedQuery = this.entityManager.createQuery(criteriaQuery);
            this.buildRange(page, typedQuery, root);
            this.onPage(page, cacheable).accept(typedQuery);
            parameterValues.entrySet().forEach(parameter -> typedQuery.setParameter((String)parameter.getKey(), parameter.getValue()));
            List entities = typedQuery.getResultList();
            int estimatedTotalNumberOfResults = -1;
            if (count) {
                CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
                Root countRoot = countQuery.from(this.entityType);
                countQuery.select((Selection)criteriaBuilder.count((Expression)countRoot));
                if (BaseEntityService.hasRestrictions(criteriaQuery)) {
                    Subquery subQuery = countQuery.subquery(resultType);
                    Root subQueryRoot = subQuery.from(this.entityType);
                    pathResolver = this.buildSelection(criteriaBuilder, (AbstractQuery<T>)subQuery, (Root<E>)subQueryRoot, resultType, queryBuilder);
                    if (!BaseEntityService.hasJoins(root)) {
                        BaseEntityService.copyRestrictions(criteriaQuery, subQuery);
                    } else {
                        parameterValues = this.buildRestrictions(page, criteriaBuilder, (AbstractQuery<T>)subQuery, pathResolver);
                    }
                    countQuery.where((Expression)criteriaBuilder.in((Expression)countRoot).value((Expression)subQuery.select((Expression)subQueryRoot.get("id")).distinct(true)));
                }
                TypedQuery typedCountQuery = this.entityManager.createQuery(countQuery);
                this.onPage(page, cacheable).accept(typedCountQuery);
                parameterValues.entrySet().forEach(parameter -> typedCountQuery.setParameter((String)parameter.getKey(), parameter.getValue()));
                estimatedTotalNumberOfResults = ((Long)typedCountQuery.getSingleResult()).intValue();
            }
            PartialResultList partialResultList = new PartialResultList(entities, page.getOffset(), estimatedTotalNumberOfResults);
            return partialResultList;
        }
        finally {
            this.afterPage().accept(this.entityManager);
        }
    }

    private <T extends E> PathResolver buildSelection(CriteriaBuilder criteriaBuilder, AbstractQuery<T> query, Root<E> root, Class<T> resultType, MappedQueryBuilder<T> queryBuilder) {
        LinkedHashMap<Getter<T>, Expression<?>> mapping = queryBuilder.build(criteriaBuilder, query, query instanceof Subquery ? new SubQueryRoot(root) : root);
        if (!Lang.isEmpty(mapping)) {
            if (query instanceof CriteriaQuery) {
                ((CriteriaQuery)query).multiselect(mapping.values().toArray(new Selection[mapping.size()]));
            }
            Map<String, Expression> paths = Streams.stream(mapping).collect(Collectors.toMap(e -> ((Getter)e.getKey()).getPropertyName(), e -> (Expression)e.getValue()));
            PathResolver pathResolver = field -> field == null ? root : (Expression)paths.get(field);
            if (paths.values().stream().anyMatch(BaseEntityService::needsGroupBy)) {
                BaseEntityService.groupByIfNecessary(query, root);
            }
            return pathResolver;
        }
        if (resultType == this.entityType) {
            return new RootPathResolver(root);
        }
        throw new IllegalArgumentException(ERROR_ILLEGAL_MAPPING);
    }

    private <T> void buildRange(Page page, TypedQuery<T> typedQuery, Root<E> root) {
        boolean hasJoins = BaseEntityService.hasJoins(root);
        if (hasJoins || page.getOffset() != 0) {
            typedQuery.setFirstResult(page.getOffset());
        }
        if (hasJoins || page.getLimit() != Integer.MAX_VALUE) {
            typedQuery.setMaxResults(page.getLimit());
        }
    }

    private <T> void buildOrderBy(Page page, CriteriaBuilder criteriaBuilder, CriteriaQuery<T> criteriaQuery, PathResolver pathResolver) {
        Map<String, Boolean> ordering = page.getOrdering();
        if (ordering.isEmpty() || page.getLimit() - page.getOffset() == 1) {
            return;
        }
        criteriaQuery.orderBy(Streams.stream(ordering).map(order -> this.buildOrder((Map.Entry<String, Boolean>)order, criteriaBuilder, pathResolver)).collect(Collectors.toList()));
    }

    private Order buildOrder(Map.Entry<String, Boolean> order, CriteriaBuilder criteriaBuilder, PathResolver pathResolver) {
        Expression<?> path = pathResolver.get(order.getKey());
        if (BaseEntityService.isElementCollection(path.getJavaType())) {
            path = pathResolver.get(pathResolver.forElementCollection(order.getKey()));
        }
        return order.getValue() != false ? criteriaBuilder.asc(path) : criteriaBuilder.desc(path);
    }

    private <T> Map<String, Object> buildRestrictions(Page page, CriteriaBuilder criteriaBuilder, AbstractQuery<T> query, PathResolver pathResolver) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>(page.getRequiredCriteria().size() + page.getOptionalCriteria().size());
        List<Predicate> requiredPredicates = this.buildPredicates(page.getRequiredCriteria(), criteriaBuilder, pathResolver, parameterValues);
        List<Predicate> optionalPredicates = this.buildPredicates(page.getOptionalCriteria(), criteriaBuilder, pathResolver, parameterValues);
        Predicate restriction = null;
        if (!optionalPredicates.isEmpty()) {
            restriction = criteriaBuilder.or(BaseEntityService.toArray(optionalPredicates));
        }
        if (!requiredPredicates.isEmpty()) {
            List<Predicate> wherePredicates = requiredPredicates.stream().filter(Alias::isWhere).collect(Collectors.toList());
            if (!wherePredicates.isEmpty()) {
                restriction = BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, restriction, wherePredicates);
            }
            List inPredicates = wherePredicates.stream().filter(Alias::isIn).collect(Collectors.toList());
            for (Predicate inPredicate : inPredicates) {
                Predicate countPredicate = BaseEntityService.buildCountPredicateIfNecessary(inPredicate, criteriaBuilder, query, pathResolver);
                if (countPredicate == null) continue;
                requiredPredicates.add(countPredicate);
            }
            List<Predicate> havingPredicates = requiredPredicates.stream().filter(Alias::isHaving).collect(Collectors.toList());
            if (!havingPredicates.isEmpty()) {
                BaseEntityService.groupByIfNecessary(query, pathResolver.get(null));
                query.having((Expression)BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, query.getGroupRestriction(), havingPredicates));
            }
        }
        if (restriction != null) {
            query.where((Expression)BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, query.getRestriction(), restriction));
        }
        return parameterValues;
    }

    private <T> List<Predicate> buildPredicates(Map<String, Object> criteria, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Map<String, Object> parameterValues) {
        return Streams.stream(criteria).map(parameter -> this.buildPredicate((Map.Entry<String, Object>)parameter, criteriaBuilder, pathResolver, parameterValues)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Predicate buildPredicate(Map.Entry<String, Object> parameter, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Map<String, Object> parameterValues) {
        Expression<?> path;
        String field = parameter.getKey();
        try {
            path = pathResolver.get(field);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
        Class type = "id".equals(field) ? this.identifierType : path.getJavaType();
        Object value = parameter.getValue();
        if (BaseEntityService.isElementCollection(type)) {
            path = pathResolver.get(pathResolver.inElementCollection(field));
        }
        return this.buildTypedPredicate(path, type, field, value, criteriaBuilder, new UncheckedParameterBuilder(field, criteriaBuilder, parameterValues));
    }

    private Predicate buildTypedPredicate(Expression<?> path, Class<?> type, String field, Object criteria, CriteriaBuilder criteriaBuilder, Criteria.ParameterBuilder parameterBuilder) {
        Predicate predicate;
        boolean negated;
        String alias;
        block14: {
            alias = Alias.create(path, field);
            Object value = criteria;
            negated = value instanceof Not;
            if (negated) {
                value = ((Not)value).getValue();
            }
            if (value instanceof Criteria && ((Criteria)value).getValue() == null) {
                value = null;
            }
            try {
                if (value == null) {
                    predicate = criteriaBuilder.isNull(path);
                    break block14;
                }
                if (BaseEntityService.isElementCollection(type)) {
                    predicate = this.buildInPredicate(path, alias, value, parameterBuilder);
                    break block14;
                }
                if (value instanceof Iterable || value.getClass().isArray()) {
                    predicate = this.buildArrayPredicate(path, type, field, value, criteriaBuilder, parameterBuilder);
                    break block14;
                }
                if (value instanceof Criteria) {
                    predicate = ((Criteria)value).build(path, criteriaBuilder, parameterBuilder);
                    break block14;
                }
                if (type.isEnum()) {
                    predicate = Enumerated.parse(value, type).build(path, criteriaBuilder, parameterBuilder);
                    break block14;
                }
                if (Number.class.isAssignableFrom(type)) {
                    predicate = Numeric.parse(value, type).build(path, criteriaBuilder, parameterBuilder);
                    break block14;
                }
                if (Boolean.class.isAssignableFrom(type)) {
                    predicate = Bool.parse(value).build(path, criteriaBuilder, parameterBuilder);
                    break block14;
                }
                if (String.class.isAssignableFrom(type)) {
                    predicate = IgnoreCase.value(value.toString()).build(path, criteriaBuilder, parameterBuilder);
                    break block14;
                }
                if (value instanceof String) {
                    predicate = Like.contains((String)value).build(path, criteriaBuilder, parameterBuilder);
                    break block14;
                }
                throw new UnsupportedOperationException(String.format(ERROR_UNSUPPORTED_CRITERIA, field, type, value, value.getClass()));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        alias = (String)Lang.coalesce((Object[])new String[]{predicate.getAlias(), alias});
        if (negated) {
            predicate = criteriaBuilder.not((Expression)predicate);
        }
        predicate.alias(alias);
        return predicate;
    }

    private Predicate buildInPredicate(Expression<?> path, String alias, Object value, Criteria.ParameterBuilder parameterBuilder) {
        List<Expression> in = Streams.stream((Object)value).map(parameterBuilder::create).collect(Collectors.toList());
        if (in.isEmpty()) {
            throw new IllegalArgumentException(value.toString());
        }
        Predicate predicate = ((Join)path).in(in.toArray(new Expression[in.size()]));
        predicate.alias(Alias.in(alias, in.size()));
        return predicate;
    }

    private Predicate buildArrayPredicate(Expression<?> path, Class<?> type, String field, Object value, CriteriaBuilder criteriaBuilder, Criteria.ParameterBuilder parameterBuilder) {
        List<Predicate> predicates = Streams.stream((Object)value).map(item -> this.buildTypedPredicate(path, type, field, item, criteriaBuilder, parameterBuilder)).filter(Objects::nonNull).collect(Collectors.toList());
        if (predicates.isEmpty()) {
            throw new IllegalArgumentException(value.toString());
        }
        return criteriaBuilder.or(BaseEntityService.toArray(predicates));
    }

    private static boolean isElementCollection(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    private static Predicate[] toArray(List<Predicate> predicates) {
        return predicates.toArray(new Predicate[predicates.size()]);
    }

    private static Predicate conjunctRestrictionsIfNecessary(CriteriaBuilder criteriaBuilder, Predicate nullable, Predicate nonnullable) {
        return nullable == null ? nonnullable : criteriaBuilder.and((Expression)nullable, (Expression)nonnullable);
    }

    private static Predicate conjunctRestrictionsIfNecessary(CriteriaBuilder criteriaBuilder, Predicate nullable, List<Predicate> nonnullable) {
        return BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, nullable, criteriaBuilder.and(BaseEntityService.toArray(nonnullable)));
    }

    private static Predicate buildCountPredicateIfNecessary(Predicate inPredicate, CriteriaBuilder criteriaBuilder, AbstractQuery<?> query, PathResolver pathResolver) {
        Map.Entry<String, Integer> fieldAndCount = Alias.getFieldAndCount(inPredicate);
        if (fieldAndCount.getValue() > 1) {
            Expression<?> join = pathResolver.get(pathResolver.inElementCollection(fieldAndCount.getKey()));
            Predicate countPredicate = criteriaBuilder.equal(criteriaBuilder.count(join), (Object)fieldAndCount.getValue());
            countPredicate.alias(Alias.having(inPredicate));
            BaseEntityService.groupByIfNecessary(query, pathResolver.get(pathResolver.forElementCollection(fieldAndCount.getKey())));
            return countPredicate;
        }
        return null;
    }

    private static boolean needsGroupBy(Expression<?> expression) {
        return !(expression instanceof Path);
    }

    private static void groupByIfNecessary(AbstractQuery<?> query, Expression<?> path) {
        if (!query.getGroupList().contains(path)) {
            ArrayList groupList = new ArrayList(query.getGroupList());
            groupList.add(path);
            query.groupBy(groupList);
        }
    }

    private static boolean hasRestrictions(AbstractQuery<?> query) {
        return query.getRestriction() != null || !query.getGroupList().isEmpty() || query.getGroupRestriction() != null;
    }

    private static boolean hasJoins(From<?, ?> from) {
        return !from.getJoins().isEmpty() || from.getFetches().stream().anyMatch(fetch -> fetch instanceof Path);
    }

    private static void copyRestrictions(AbstractQuery<?> source, AbstractQuery<?> target) {
        if (source.getRestriction() != null) {
            target.where((Expression)source.getRestriction());
        }
        target.groupBy(source.getGroupList());
        if (source.getGroupRestriction() != null) {
            target.having((Expression)source.getGroupRestriction());
        }
    }

    private static <T> T noop() {
        return null;
    }

    private static class UncheckedParameterBuilder
    implements Criteria.ParameterBuilder {
        private String field;
        private CriteriaBuilder criteriaBuilder;
        private Map<String, Object> parameterValues;

        private UncheckedParameterBuilder(String field, CriteriaBuilder criteriaBuilder, Map<String, Object> parameterValues) {
            this.field = field.replace(".", "_") + "_";
            this.criteriaBuilder = criteriaBuilder;
            this.parameterValues = parameterValues;
        }

        @Override
        public <T> ParameterExpression<T> create(Object value) {
            String name = this.field + this.parameterValues.size();
            this.parameterValues.put(name, value);
            return this.criteriaBuilder.parameter(value.getClass(), name);
        }
    }

    private static class Alias {
        private static final String WHERE = "where_";
        private static final String HAVING = "having_";
        private static final String IN = "_in";

        private Alias() {
        }

        public static String create(Expression<?> expression, String field) {
            return (BaseEntityService.needsGroupBy(expression) ? HAVING : WHERE) + field.replace(".", "_");
        }

        public static String in(String alias, int count) {
            return alias + "_" + count + IN;
        }

        public static String having(Predicate predicate) {
            return HAVING + predicate.getAlias().substring(predicate.getAlias().indexOf("_") + 1);
        }

        public static boolean isWhere(Predicate predicate) {
            return predicate.getAlias().startsWith(WHERE);
        }

        public static boolean isIn(Predicate predicate) {
            return predicate.getAlias().endsWith(IN);
        }

        public static boolean isHaving(Predicate predicate) {
            return predicate.getAlias().startsWith(HAVING);
        }

        public static Map.Entry<String, Integer> getFieldAndCount(Predicate predicate) {
            String alias = predicate.getAlias();
            String[] fieldAndCount = alias.substring(alias.indexOf(95) + 1, alias.lastIndexOf(95)).split("_");
            String field = fieldAndCount[0];
            int count = Integer.valueOf(fieldAndCount[1]);
            return new AbstractMap.SimpleEntry<String, Integer>(field, count);
        }
    }

    private static class RootPathResolver
    implements PathResolver {
        private Root<?> root;
        private Map<String, Path<?>> joins;
        private Map<String, Path<?>> paths;

        private RootPathResolver(Root<?> root) {
            this.root = root;
            this.joins = RootPathResolver.getJoins(root);
            this.paths = new HashMap();
        }

        @Override
        public Expression<?> get(String field) {
            if (field == null) {
                return this.root;
            }
            Object path = this.paths.get(field);
            if (path != null) {
                return path;
            }
            path = this.root;
            String[] attributes = field.split("\\.");
            int depth = attributes.length;
            for (int i = 0; i < depth; ++i) {
                String attribute = attributes[i];
                path = i + 1 < depth ? this.joins.get(attribute) : (!attribute.startsWith("@") ? path.get(attribute) : (!attribute.endsWith("@") ? this.joins.get(attribute.substring(1)) : ((From)path).join(attribute.substring(1, attribute.length() - 1))));
            }
            this.paths.put(field, (Path<?>)path);
            return path;
        }

        private static Map<String, Path<?>> getJoins(From<?, ?> from) {
            HashMap joins = new HashMap((Map)from.getJoins().stream().collect(org.omnifaces.utils.stream.Collectors.toMap(join -> join.getAttribute().getName())));
            joins.putAll(from.getFetches().stream().filter(fetch -> fetch instanceof Path).collect(Collectors.toMap(fetch -> fetch.getAttribute().getName(), fetch -> (Path)fetch)));
            return joins;
        }
    }

    @FunctionalInterface
    private static interface PathResolver {
        public Expression<?> get(String var1);

        default public String forElementCollection(String attribute) {
            return '@' + attribute;
        }

        default public String inElementCollection(String attribute) {
            return '@' + attribute + '@';
        }
    }

    @FunctionalInterface
    protected static interface MappedQueryBuilder<T> {
        public LinkedHashMap<Getter<T>, Expression<?>> build(CriteriaBuilder var1, AbstractQuery<T> var2, Root<? super T> var3);
    }

    @FunctionalInterface
    protected static interface QueryBuilder<E> {
        public void build(CriteriaBuilder var1, AbstractQuery<E> var2, Root<E> var3);
    }
}

