/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.criteria;

import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import org.omnifaces.persistence.criteria.Criteria;

public final class Order<T extends Comparable<T>>
extends Criteria<T> {
    private Type type;

    private Order(Type type, T value) {
        super(value);
        this.type = type;
    }

    public static <T extends Comparable<T>> Order<T> lessThan(T value) {
        return new Order<T>(Type.LT, value);
    }

    public static <T extends Comparable<T>> Order<T> lessThanOrEqualTo(T value) {
        return new Order<T>(Type.LTE, value);
    }

    public static <T extends Comparable<T>> Order<T> greaterThanOrEqualTo(T value) {
        return new Order<T>(Type.GTE, value);
    }

    public static <T extends Comparable<T>> Order<T> greaterThan(T value) {
        return new Order<T>(Type.GT, value);
    }

    public boolean lessThan() {
        return this.type == Type.LT;
    }

    public boolean lessThanOrEqualTo() {
        return this.type == Type.LTE;
    }

    public boolean greaterThanOrEqualTo() {
        return this.type == Type.GTE;
    }

    public boolean greaterThan() {
        return this.type == Type.GT;
    }

    @Override
    public Predicate build(Expression<?> path, CriteriaBuilder criteriaBuilder, Criteria.ParameterBuilder parameterBuilder) {
        Expression<?> typedPath = path;
        ParameterExpression parameter = parameterBuilder.create(this.getValue());
        if (this.lessThan()) {
            return criteriaBuilder.lessThan(typedPath, parameter);
        }
        if (this.lessThanOrEqualTo()) {
            return criteriaBuilder.lessThanOrEqualTo(typedPath, parameter);
        }
        if (this.greaterThanOrEqualTo()) {
            return criteriaBuilder.greaterThanOrEqualTo(typedPath, parameter);
        }
        return criteriaBuilder.greaterThan(typedPath, parameter);
    }

    @Override
    public boolean applies(Object value) {
        if (!(value instanceof Comparable)) {
            return false;
        }
        Comparable typedValue = (Comparable)value;
        if (this.greaterThan()) {
            return typedValue.compareTo(this.getValue()) > 0;
        }
        if (this.greaterThanOrEqualTo()) {
            return typedValue.compareTo(this.getValue()) >= 0;
        }
        if (this.lessThan()) {
            return typedValue.compareTo(this.getValue()) < 0;
        }
        return typedValue.compareTo(this.getValue()) <= 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type});
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Objects.equals((Object)this.type, (Object)((Order)object).type);
    }

    @Override
    public String toString() {
        return (this.type == Type.GT ? ">" : (this.type == Type.GTE ? ">=" : (this.type == Type.LT ? "<" : "<="))) + " " + this.getValue();
    }

    private static enum Type {
        LT,
        LTE,
        GT,
        GTE;

    }
}

