/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.criteria;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.omnifaces.persistence.criteria.Criteria;

public final class Numeric
extends Criteria<Number> {
    private Numeric(Number value) {
        super(value);
    }

    public static Numeric value(Number value) {
        return new Numeric(value);
    }

    public static Numeric parse(Object searchValue, Class<Number> targetType) {
        return new Numeric(Numeric.parseNumber(searchValue, targetType));
    }

    @Override
    public Predicate build(Expression<?> path, CriteriaBuilder criteriaBuilder, Criteria.ParameterBuilder parameterBuilder) {
        return criteriaBuilder.equal(path, parameterBuilder.create(this.getValue()));
    }

    @Override
    public boolean applies(Object modelValue) {
        return modelValue != null && Objects.equals(Numeric.parseNumber(modelValue, ((Number)this.getValue()).getClass()), this.getValue());
    }

    private static Number parseNumber(Object searchValue, Class<?> targetType) throws NumberFormatException {
        if (searchValue instanceof Number) {
            return (Number)searchValue;
        }
        try {
            if (BigDecimal.class.isAssignableFrom(targetType)) {
                return new BigDecimal(searchValue.toString());
            }
            if (BigInteger.class.isAssignableFrom(targetType)) {
                return new BigInteger(searchValue.toString());
            }
            if (Integer.class.isAssignableFrom(targetType)) {
                return Integer.valueOf(searchValue.toString());
            }
            return Long.valueOf(searchValue.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(searchValue.toString(), e);
        }
    }
}

