/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.criteria;

import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.omnifaces.persistence.criteria.Criteria;

public final class Like
extends Criteria<String> {
    private Type type;

    private Like(Type type, String value) {
        super(value);
        this.type = type;
    }

    public static Like startsWith(String value) {
        return new Like(Type.STARTS_WITH, value);
    }

    public static Like endsWith(String value) {
        return new Like(Type.ENDS_WITH, value);
    }

    public static Like contains(String value) {
        return new Like(Type.CONTAINS, value);
    }

    public boolean startsWith() {
        return this.type == Type.STARTS_WITH;
    }

    public boolean endsWith() {
        return this.type == Type.ENDS_WITH;
    }

    public boolean contains() {
        return this.type == Type.CONTAINS;
    }

    @Override
    public Predicate build(Expression<?> path, CriteriaBuilder criteriaBuilder, Criteria.ParameterBuilder parameterBuilder) {
        String searchValue = (this.startsWith() ? "" : "%") + ((String)this.getValue()).toLowerCase() + (this.endsWith() ? "" : "%");
        return criteriaBuilder.like(criteriaBuilder.lower(criteriaBuilder.function("str", String.class, new Expression[]{path})), parameterBuilder.create(searchValue));
    }

    @Override
    public boolean applies(Object modelValue) {
        if (modelValue == null) {
            return false;
        }
        String lowerCasedValue = ((String)this.getValue()).toLowerCase();
        String lowerCasedModelValue = modelValue.toString().toLowerCase();
        if (this.startsWith()) {
            return lowerCasedModelValue.startsWith(lowerCasedValue);
        }
        if (this.endsWith()) {
            return lowerCasedModelValue.endsWith(lowerCasedValue);
        }
        return lowerCasedModelValue.contains(lowerCasedValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type});
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Objects.equals((Object)this.type, (Object)((Like)object).type);
    }

    @Override
    public String toString() {
        return "LIKE " + (this.startsWith() ? "" : "%") + (String)this.getValue() + (this.endsWith() ? "" : "%");
    }

    private static enum Type {
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS;

    }
}

