/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.audit;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.CDI;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.PreUpdate;
import javax.persistence.metamodel.Attribute;
import org.omnifaces.persistence.audit.Audit;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.utils.reflect.Reflections;
import org.omnifaces.utils.stream.Streams;

public abstract class AuditListener<I extends Comparable<I> & Serializable> {
    private static final Map<Class<?>, Map<PropertyDescriptor, Map<?, Object>>> AUDITABLE_PROPERTIES = new ConcurrentHashMap();
    @PersistenceContext
    private EntityManager entityManager;

    @PostLoad
    public void beforeUpdate(BaseEntity<I> entity) {
        this.getAuditableProperties(entity).forEach((property, values) -> values.put(entity.getId(), Reflections.invokeMethod((Object)entity, (Method)property.getReadMethod(), (Object[])new Object[0])));
    }

    @PreUpdate
    public void afterUpdate(BaseEntity<I> entity) {
        this.getAuditableProperties(entity).forEach((property, values) -> {
            if (values.containsKey(entity.getId())) {
                Object newValue = Reflections.invokeMethod((Object)entity, (Method)property.getReadMethod(), (Object[])new Object[0]);
                Object oldValue = values.remove(entity.getId());
                if (!Objects.equals(oldValue, newValue)) {
                    this.saveAuditedChange(entity, (PropertyDescriptor)property, oldValue, newValue);
                }
            }
        });
    }

    private Map<PropertyDescriptor, Map<I, Object>> getAuditableProperties(BaseEntity<I> entity) {
        Map auditableProperties = AUDITABLE_PROPERTIES.computeIfAbsent(entity.getClass(), type -> {
            Set auditablePropertyNames = this.entityManager.getMetamodel().entity(type).getDeclaredAttributes().stream().filter(a -> a.getJavaMember() instanceof Field && ((Field)a.getJavaMember()).getAnnotation(Audit.class) != null).map(Attribute::getName).collect(Collectors.toSet());
            try {
                return Streams.stream((Object[])Introspector.getBeanInfo(type).getPropertyDescriptors()).filter(p -> auditablePropertyNames.contains(p.getName())).collect(Collectors.toConcurrentMap(Function.identity(), v -> new ConcurrentHashMap()));
            }
            catch (IntrospectionException e) {
                throw new UnsupportedOperationException(e);
            }
        });
        return auditableProperties;
    }

    protected abstract void saveAuditedChange(BaseEntity<I> var1, PropertyDescriptor var2, Object var3, Object var4);

    protected static <T> T inject(Class<T> type) {
        return (T)CDI.current().select(type, new Annotation[0]).get();
    }
}

