/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.ParameterExpression;
import org.omnifaces.persistence.criteria.Criteria;

class UncheckedParameterBuilder
implements Criteria.ParameterBuilder {
    private final String field;
    private final CriteriaBuilder criteriaBuilder;
    private final Map<String, Object> parameters;

    public UncheckedParameterBuilder(String field, CriteriaBuilder criteriaBuilder, Map<String, Object> parameters) {
        this.field = field.replace('.', '$') + "_";
        this.criteriaBuilder = criteriaBuilder;
        this.parameters = parameters;
    }

    @Override
    public <T> ParameterExpression<T> create(Object value) {
        String name = this.field + this.parameters.size();
        this.parameters.put(name, value);
        Class type = value == null ? Object.class : value.getClass();
        return this.criteriaBuilder.parameter(type, name);
    }
}

