/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.lang.reflect.Field;
import java.util.List;
import org.omnifaces.persistence.exception.NonSoftDeletableEntityException;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.model.SoftDeletable;
import org.omnifaces.utils.reflect.Reflections;

class SoftDeleteData {
    private static final String ERROR_NOT_SOFT_DELETABLE = "Entity %s cannot be soft deleted. You need to add a @SoftDeletable field first.";
    private static final String ERROR_ILLEGAL_SOFT_DELETABLE = "Entity %s cannot be soft deleted. There should be only one @SoftDeletable field.";
    private Class<?> entityType;
    private final boolean softDeletable;
    private final String fieldName;
    private final String setterName;
    private final boolean typeActive;

    public SoftDeleteData(Class<?> entityType) {
        this.entityType = entityType;
        List softDeletableFields = Reflections.listAnnotatedFields(entityType, (Class[])new Class[]{SoftDeletable.class});
        if (softDeletableFields.isEmpty()) {
            this.softDeletable = false;
            this.fieldName = null;
            this.setterName = null;
            this.typeActive = false;
        } else if (softDeletableFields.size() == 1) {
            Field softDeletableField = (Field)softDeletableFields.get(0);
            this.softDeletable = true;
            this.fieldName = softDeletableField.getName();
            this.setterName = "set" + Character.toUpperCase(this.fieldName.charAt(0)) + this.fieldName.substring(1);
            this.typeActive = softDeletableField.getAnnotation(SoftDeletable.class).type() == SoftDeletable.Type.ACTIVE;
        } else {
            throw new IllegalStateException(String.format(ERROR_ILLEGAL_SOFT_DELETABLE, entityType));
        }
    }

    public void checkSoftDeletable() {
        if (!this.softDeletable) {
            throw new NonSoftDeletableEntityException(null, String.format(ERROR_NOT_SOFT_DELETABLE, this.entityType));
        }
    }

    public boolean isSoftDeleted(BaseEntity<?> entity) {
        if (!this.softDeletable) {
            return false;
        }
        boolean value = (Boolean)Reflections.accessField(entity, (String)this.fieldName);
        return this.typeActive ? !value : value;
    }

    public void setSoftDeleted(BaseEntity<?> entity, boolean deleted) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.typeActive ? !deleted : deleted;
        Reflections.invokeMethod(entity, (String)this.setterName, (Object[])objectArray);
    }

    public String getWhereClause(boolean includeSoftDeleted) {
        if (!this.softDeletable) {
            return "";
        }
        return " WHERE " + this.fieldName + (includeSoftDeleted ? "=" : "!=") + (this.typeActive ? "false" : "true");
    }

    public String toString() {
        return String.format("SoftDeleteData[softDeletable=%s, fieldName=%s, setterName=%s, typeActive=%s]", this.softDeletable, this.fieldName, this.setterName, this.typeActive);
    }
}

