/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.omnifaces.persistence.service.EclipseLinkRoot;
import org.omnifaces.persistence.service.PathResolver;

class RootPathResolver
implements PathResolver {
    private static final String ERROR_UNKNOWN_FIELD = "Field %s cannot be found on %s. If this represents a transient field, make sure that it is delegating to @ManyToOne/@OneToOne children.";
    private final Root<?> root;
    private final Map<String, Path<?>> joins;
    private final Map<String, Path<?>> paths;
    private final Set<String> elementCollections;
    private final Set<String> manyOrOneToOnes;

    public RootPathResolver(Root<?> root, Set<String> elementCollections, Set<String> manyOrOneToOnes) {
        this.root = root;
        this.joins = RootPathResolver.getJoins(root);
        this.paths = new HashMap();
        this.elementCollections = elementCollections;
        this.manyOrOneToOnes = manyOrOneToOnes;
    }

    @Override
    public Expression<?> get(String field) {
        if (field == null) {
            return this.root;
        }
        Path<?> path = this.paths.get(field);
        if (path != null) {
            return path;
        }
        path = this.root;
        boolean explicitJoin = field.charAt(0) == '@';
        String originalField = explicitJoin ? field.substring(1) : field;
        String[] attributes = originalField.split("\\.");
        int depth = attributes.length;
        for (int i = 0; i < depth; ++i) {
            String attribute = attributes[i];
            if (i + 1 < depth || this.elementCollections.contains(originalField)) {
                path = explicitJoin || !this.joins.containsKey(attribute) ? ((From)path).join(attribute) : this.joins.get(attribute);
                continue;
            }
            try {
                path = path.get(attribute);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (depth == 1 && this.isTransient(path.getModel().getBindableJavaType(), attribute)) {
                    path = this.guessManyOrOneToOnePath(attribute);
                }
                if (depth == 1 && path != null) continue;
                throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_FIELD, field, this.root.getJavaType()), e);
            }
        }
        this.paths.put(field, path);
        return path;
    }

    private boolean isTransient(Class<?> type, String property) {
        return true;
    }

    private Path<?> guessManyOrOneToOnePath(String attribute) {
        for (String manyOrOneToOne : this.manyOrOneToOnes) {
            try {
                return (Path)this.get(manyOrOneToOne + "." + attribute);
            }
            catch (IllegalArgumentException ignore) {
            }
        }
        return null;
    }

    private static Map<String, Path<?>> getJoins(From<?, ?> from) {
        HashMap joins = new HashMap();
        RootPathResolver.collectJoins(from, joins);
        if (from instanceof EclipseLinkRoot) {
            ((EclipseLinkRoot)from).collectPostponedFetches(joins);
        }
        return joins;
    }

    private static void collectJoins(Path<?> path, Map<String, Path<?>> joins) {
        if (path instanceof From) {
            ((From)path).getJoins().forEach(join -> RootPathResolver.collectJoins(join, joins));
        }
        if (path instanceof FetchParent) {
            try {
                ((FetchParent)path).getFetches().stream().filter(fetch -> fetch instanceof Path).forEach(fetch -> RootPathResolver.collectJoins((Path)fetch, joins));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (path instanceof Join) {
            joins.put(((Join)path).getAttribute().getName(), path);
        } else if (path instanceof Fetch) {
            joins.put(((Fetch)path).getAttribute().getName(), path);
        }
    }
}

