/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import org.omnifaces.persistence.model.dto.Page;
import org.omnifaces.persistence.service.BaseEntityService;

class PageBuilder<T> {
    private final Page page;
    private final boolean cacheable;
    private final Class<T> resultType;
    private final BaseEntityService.MappedQueryBuilder<T> queryBuilder;
    private boolean shouldBuildCountSubquery;
    private boolean canBuildValueBasedPagingPredicate;

    public PageBuilder(Page page, boolean cacheable, Class<T> resultType, BaseEntityService.MappedQueryBuilder<T> queryBuilder) {
        this.page = page;
        this.cacheable = cacheable;
        this.resultType = resultType;
        this.queryBuilder = queryBuilder;
        this.canBuildValueBasedPagingPredicate = page.getLast() != null && page.getOffset() > 0;
    }

    public void shouldBuildCountSubquery(boolean yes) {
        this.shouldBuildCountSubquery |= yes;
    }

    public boolean shouldBuildCountSubquery() {
        return this.shouldBuildCountSubquery;
    }

    public void canBuildValueBasedPagingPredicate(boolean yes) {
        this.canBuildValueBasedPagingPredicate &= yes;
    }

    public boolean canBuildValueBasedPagingPredicate() {
        return this.canBuildValueBasedPagingPredicate;
    }

    public Page getPage() {
        return this.page;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public BaseEntityService.MappedQueryBuilder<T> getQueryBuilder() {
        return this.queryBuilder;
    }
}

