/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EnumType;
import javax.persistence.PersistenceUnit;
import javax.transaction.UserTransaction;
import org.omnifaces.persistence.model.EnumMapping;
import org.omnifaces.persistence.model.EnumMappingTable;
import org.omnifaces.utils.reflect.Reflections;

@Singleton
@Startup
@TransactionManagement(value=TransactionManagementType.BEAN)
public class EnumMappingTableService {
    private static final Logger logger = Logger.getLogger(EnumMappingTableService.class.getName());
    private static final String LOG_WARNING_INVALID_ENUM_FIELD_NAME = "Field name %s specified within the annotation was not found on enum %s";
    private static final String LOG_WARNING_INVALID_ENUM_FIELD_TYPE = "Declared enum %s contains wrong type of field %s: expected %s, got %s";
    private static final String LOG_WARNING_UNMODIFIABLE_ENUM_FIELD = "Field name %s could not be used to modify enum %s";
    private static final String LOG_WARNING_CANNOT_ACCESS_ENUM_CONSTRUCTOR = "Cannot get access to create new instance method of enum %s";
    private static final String LOG_WARNING_CANNOT_INSTANTIATE_NEW_ENUM = "New constants for enum %s could not be instantiated";
    private static final String LOG_WARNING_CANNOT_MODIFY_ENUM_DATA = "Data for enum %s could not be modified: %s could not be performed";
    private static final String LOG_WARNING_ENUM_MAPPING_TABLE_CONNECTION_ERROR = "Couldn't connect to the target table %s: either table with name %s doesn't exist, or column name%s %s %s incorrect";
    private static final String LOG_WARNING_ENUM_MAPPING_TABLE_CREATION_ERROR = "Couldn't create the target table %s: check table names for possible collisions";
    private static final String LOG_WARNING_ENUM_MAPPING_TABLE_READ_ERROR = "Couldn't read from the target table %s: check column type%s (%s) for column name%s (%s)";
    private static final String LOG_WARNING_ENUM_MAPPING_TABLE_MODIFICATION_ERROR = "Couldn't modify the target table %s: %s was not performed successfully (%d %s actions needed%s)";
    private static final String LOG_WARNING_DIFFERENCE_IN_ENUM_AND_TABLE_DATA = "Difference in enum %s and table data detected: %s %s in %s%s";
    private static final String LOG_INFO_ENUM_MAPPING_TABLE_MODIFIED = "Data for table %s was modified basing on enum %s data: %d number of %s was performed";
    private static final String LOG_INFO_ENUM_DATA_MODIFIED = "Data for enum %s was modified: %d number of %s was performed";
    @PersistenceUnit
    private EntityManagerFactory emf;
    @Resource
    UserTransaction ut;

    public Map<Class<? extends Enum<?>>, Boolean> computeModifiedEnumMappingTable(List<Class<? extends Enum<?>>> enumsToUpdate) {
        return enumsToUpdate.stream().collect(Collectors.toMap(Function.identity(), this::modifyEnumMappingTable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modifyEnumMappingTable(Class<? extends Enum<?>> enumeratedType) {
        block99: {
            String idEnumColumn;
            Optional secondaryEnumFieldOptional;
            Optional codeEnumFieldOptional;
            Optional idEnumFieldOptional;
            EnumMapping mapping = enumeratedType.getAnnotation(EnumMapping.class);
            boolean ordinal = mapping.type() == EnumType.ORDINAL;
            String fieldName = mapping.fieldName();
            EnumMappingTable mappingTable = mapping.enumMappingTable();
            boolean enumPrecedence = mappingTable.mappingType() == EnumMappingTable.MappingType.ENUM;
            boolean doDeletes = mappingTable.deleteType() != EnumMappingTable.DeleteAction.NO_ACTION;
            boolean doSoftDeletes = mappingTable.deleteType() == EnumMappingTable.DeleteAction.SOFT_DELETE;
            boolean doInserts = mappingTable.doInserts();
            boolean oneFieldMapping = mappingTable.oneFieldMapping();
            String idFieldName = mappingTable.ordinalFieldName();
            String codeFieldName = mappingTable.stringFieldName();
            Optional optional = ordinal ? Reflections.findField(enumeratedType, (String)fieldName) : (idEnumFieldOptional = oneFieldMapping ? Optional.empty() : Reflections.findField(enumeratedType, (String)idFieldName));
            Optional optional2 = !ordinal ? Reflections.findField(enumeratedType, (String)fieldName) : (codeEnumFieldOptional = oneFieldMapping ? Optional.empty() : Reflections.findField(enumeratedType, (String)codeFieldName));
            Optional optional3 = oneFieldMapping ? Optional.empty() : (secondaryEnumFieldOptional = ordinal ? codeEnumFieldOptional : idEnumFieldOptional);
            String string = ordinal ? mappingTable.ordinalColumnName() : (idEnumColumn = oneFieldMapping ? "" : mappingTable.ordinalColumnName());
            String codeEnumColumn = !ordinal ? mappingTable.stringColumnName() : (oneFieldMapping ? "" : mappingTable.stringColumnName());
            String tableName = mappingTable.tableName();
            String enumTable = "".equals(tableName) ? EnumMappingTableService.toSnakeCase(enumeratedType.getSimpleName()) + "_info" : tableName;
            String deletedColumn = doSoftDeletes && !enumPrecedence ? mappingTable.deletedColumnName() : "";
            String historyTable = doSoftDeletes && enumPrecedence ? enumTable + "_history" : "";
            try (EntityManager entityManager = this.emf.createEntityManager();){
                List<Enum> valuesToUpdate;
                boolean existsTable = false;
                boolean existsHistoryTable = false;
                try {
                    String countTableQuery = "SELECT " + ("".equals(idEnumColumn) ? "" : "COUNT(et." + idEnumColumn + ")") + ("".equals(codeEnumColumn) ? "" : (oneFieldMapping ? "" : ", ") + "COUNT(et." + codeEnumColumn + ")") + ("".equals(deletedColumn) ? "" : ", COUNT(et." + deletedColumn + ")") + " FROM " + enumTable + " et;";
                    entityManager.createNativeQuery(countTableQuery).getSingleResult();
                    existsTable = true;
                }
                catch (Exception ex) {
                    existsTable = false;
                }
                if (!"".equals(historyTable)) {
                    try {
                        String countHistoryTableQuery = "SELECT " + ("".equals(idEnumColumn) ? "" : "COUNT(et." + idEnumColumn + ")") + ("".equals(codeEnumColumn) ? "" : (oneFieldMapping ? "" : ", ") + "COUNT(et." + codeEnumColumn + ")") + " FROM " + historyTable + " et;";
                        entityManager.createNativeQuery(countHistoryTableQuery).getSingleResult();
                        existsHistoryTable = true;
                    }
                    catch (Exception ex) {
                        existsHistoryTable = false;
                    }
                }
                boolean createdTable = false;
                boolean createdHistoryTable = false;
                if (!existsTable) {
                    if (!enumPrecedence) {
                        logger.log(Level.WARNING, () -> {
                            Object[] objectArray = new Object[5];
                            objectArray[0] = enumTable;
                            objectArray[1] = enumTable;
                            Object object = objectArray[2] = oneFieldMapping ? "" : "s";
                            objectArray[3] = oneFieldMapping ? (ordinal ? idEnumColumn : codeEnumColumn) : idEnumColumn + ", " + codeEnumColumn;
                            objectArray[4] = oneFieldMapping ? "is" : "are";
                            return String.format(LOG_WARNING_ENUM_MAPPING_TABLE_CONNECTION_ERROR, objectArray);
                        });
                        boolean bl = false;
                        return bl;
                    }
                    String createTableQuery = "CREATE TABLE " + enumTable + " (" + ("".equals(idEnumColumn) ? "" : idEnumColumn + " INT NOT NULL, ") + ("".equals(codeEnumColumn) ? "" : codeEnumColumn + " VARCHAR(32) NOT NULL, ") + "PRIMARY KEY (" + (ordinal ? idEnumColumn : codeEnumColumn) + ")" + (oneFieldMapping ? "" : ", CONSTRAINT " + enumTable + "_" + (ordinal ? codeEnumColumn : idEnumColumn) + "_UNIQUE UNIQUE (" + (ordinal ? codeEnumColumn : idEnumColumn) + ")") + ");";
                    try {
                        this.ut.begin();
                        entityManager.createNativeQuery(createTableQuery).executeUpdate();
                        this.ut.commit();
                        createdTable = true;
                    }
                    catch (Exception ex) {
                        try {
                            this.ut.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        createdTable = false;
                    }
                    if (!createdTable) {
                        logger.log(Level.WARNING, () -> String.format(LOG_WARNING_ENUM_MAPPING_TABLE_CREATION_ERROR, enumTable));
                        boolean ex = false;
                        return ex;
                    }
                }
                if (!existsHistoryTable && !"".equals(historyTable)) {
                    String createHistoryTableQuery = "CREATE TABLE " + historyTable + " (" + ("".equals(idEnumColumn) ? "" : idEnumColumn + " INT NOT NULL, ") + ("".equals(codeEnumColumn) ? "" : codeEnumColumn + " VARCHAR(32) NOT NULL, ") + "PRIMARY KEY (" + (oneFieldMapping ? (ordinal ? idEnumColumn : codeEnumColumn) : idEnumColumn + ", " + codeEnumColumn) + ")" + ");";
                    try {
                        this.ut.begin();
                        entityManager.createNativeQuery(createHistoryTableQuery).executeUpdate();
                        this.ut.commit();
                        createdHistoryTable = true;
                    }
                    catch (Exception ex) {
                        try {
                            this.ut.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        createdHistoryTable = false;
                    }
                    if (!createdHistoryTable) {
                        logger.log(Level.WARNING, () -> String.format(LOG_WARNING_ENUM_MAPPING_TABLE_CREATION_ERROR, historyTable));
                        boolean ex = false;
                        return ex;
                    }
                }
                EnumData databaseData = new EnumData(ordinal, oneFieldMapping, enumeratedType);
                if (existsTable && !createdTable) {
                    try {
                        String getDatabaseDataQuery = "SELECT " + (ordinal ? "et." + idEnumColumn : "et." + codeEnumColumn) + (oneFieldMapping ? "" : (ordinal ? ", et." + codeEnumColumn : ", et." + idEnumColumn)) + " FROM " + enumTable + " et" + ("".equals(deletedColumn) ? ";" : " WHERE et." + deletedColumn + " = 0;");
                        List databaseValues = entityManager.createNativeQuery(getDatabaseDataQuery).getResultList();
                        for (Object object : databaseValues) {
                            if (oneFieldMapping) {
                                if (ordinal) {
                                    databaseData.addDataElement((Integer)object);
                                    continue;
                                }
                                databaseData.addDataElement((String)object);
                                continue;
                            }
                            Object[] array = (Object[])object;
                            Integer integer = (Integer)(ordinal ? array[0] : array[1]);
                            String string2 = (String)(ordinal ? array[1] : array[0]);
                            databaseData.addDataElement(integer, string2);
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, () -> {
                            Object[] objectArray = new Object[5];
                            objectArray[0] = enumTable;
                            Object object = objectArray[1] = oneFieldMapping ? "" : "s";
                            objectArray[2] = oneFieldMapping ? (ordinal ? "Integer" : "String") : "Integer, String";
                            Object object2 = objectArray[3] = oneFieldMapping ? "" : "s";
                            objectArray[4] = oneFieldMapping ? (ordinal ? idEnumColumn : codeEnumColumn) : idEnumColumn + ", " + codeEnumColumn;
                            return String.format(LOG_WARNING_ENUM_MAPPING_TABLE_READ_ERROR, objectArray);
                        });
                        boolean databaseValues = false;
                        entityManager.close();
                        return databaseValues;
                    }
                }
                EnumData enumData = new EnumData(ordinal, oneFieldMapping, enumeratedType);
                Field secondaryEnumField = secondaryEnumFieldOptional.orElse(null);
                if (!oneFieldMapping) {
                    boolean validSecondaryFieldType;
                    if (!secondaryEnumFieldOptional.isPresent()) {
                        logger.log(Level.WARNING, () -> String.format(LOG_WARNING_INVALID_ENUM_FIELD_NAME, ordinal ? codeFieldName : idFieldName, enumeratedType));
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = ordinal ? secondaryEnumField.getType() == String.class : (validSecondaryFieldType = secondaryEnumField.getType() == Integer.class || secondaryEnumField.getType() == Integer.TYPE);
                    if (!validSecondaryFieldType) {
                        logger.log(Level.WARNING, () -> String.format(LOG_WARNING_INVALID_ENUM_FIELD_TYPE, enumeratedType, secondaryEnumField.getName(), ordinal ? "String" : "Integer", secondaryEnumField.getType()));
                        boolean object = false;
                        return object;
                    }
                }
                Arrays.asList(enumeratedType.getEnumConstants()).stream().filter(Objects::nonNull).forEach(enumConstant -> {
                    int id = enumConstant.ordinal();
                    String code = enumConstant.name();
                    if (oneFieldMapping) {
                        if (ordinal) {
                            enumData.addDataElement(id);
                        } else {
                            enumData.addDataElement(code);
                        }
                    } else {
                        Field field = secondaryEnumField;
                        Object value = Reflections.accessField((Object)enumConstant, (Field)field);
                        if (ordinal) {
                            code = (String)value;
                        } else {
                            id = (Integer)value;
                        }
                        enumData.addDataElement(id, code);
                    }
                });
                LinkedHashSet<EnumData.EnumDataEntry> common = new LinkedHashSet<EnumData.EnumDataEntry>();
                LinkedHashSet<EnumData.EnumDataEntry> absentInBase = new LinkedHashSet<EnumData.EnumDataEntry>();
                LinkedHashSet<EnumData.EnumDataEntry> absentInTarget = new LinkedHashSet<EnumData.EnumDataEntry>();
                LinkedHashMap<EnumData.EnumDataEntry, EnumData.EnumDataEntry> different = new LinkedHashMap<EnumData.EnumDataEntry, EnumData.EnumDataEntry>();
                EnumData.compareEnumData(enumData, databaseData, common, absentInBase, absentInTarget, different);
                if (!absentInBase.isEmpty()) {
                    logger.log(Level.WARNING, () -> String.format(LOG_WARNING_DIFFERENCE_IN_ENUM_AND_TABLE_DATA, enumeratedType, absentInBase, "absent", "enum", ""));
                }
                if (!absentInTarget.isEmpty()) {
                    logger.log(Level.WARNING, () -> String.format(LOG_WARNING_DIFFERENCE_IN_ENUM_AND_TABLE_DATA, enumeratedType, absentInTarget, "absent", "table", ""));
                }
                if (!different.isEmpty()) {
                    logger.log(Level.WARNING, () -> String.format(LOG_WARNING_DIFFERENCE_IN_ENUM_AND_TABLE_DATA, enumeratedType, different.keySet(), "different", "enum, values in table are ", different.values()));
                }
                boolean mustUpdateSecondaryField = false;
                List<Enum> newValuesField = null;
                int numDeletes = 0;
                int numInserts = 0;
                if (enumPrecedence) {
                    if (doDeletes && !absentInBase.isEmpty()) {
                        StringBuilder deleteQuery = new StringBuilder();
                        Iterator iter = absentInBase.iterator();
                        while (iter.hasNext()) {
                            EnumData.EnumDataEntry ede = (EnumData.EnumDataEntry)iter.next();
                            deleteQuery.append("DELETE FROM " + enumTable + " WHERE " + (ordinal ? idEnumColumn : codeEnumColumn) + " = " + (ordinal ? ede.getId() : "'" + ede.getCode() + "'") + (iter.hasNext() ? "; " : ";"));
                        }
                        try {
                            this.ut.begin();
                            int deletes = numDeletes = entityManager.createNativeQuery(deleteQuery.toString()).executeUpdate();
                            logger.log(Level.INFO, () -> String.format(LOG_INFO_ENUM_MAPPING_TABLE_MODIFIED, enumTable, enumeratedType.getSimpleName(), deletes, "deletes"));
                            this.ut.commit();
                        }
                        catch (Exception ex) {
                            try {
                                this.ut.rollback();
                            }
                            catch (Exception ede) {
                                // empty catch block
                            }
                            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_ENUM_MAPPING_TABLE_MODIFICATION_ERROR, enumTable, "delete", absentInBase.size(), "delete", ""));
                            boolean ede = false;
                            entityManager.close();
                            return ede;
                        }
                        if (doSoftDeletes) {
                            String insertHistoryQueryBase = "INSERT INTO " + historyTable + " (" + (ordinal ? idEnumColumn : codeEnumColumn) + (oneFieldMapping ? "" : (ordinal ? ", " + codeEnumColumn : ", " + idEnumColumn)) + ") VALUES ";
                            int inserts = 0;
                            for (EnumData.EnumDataEntry ede : absentInBase) {
                                String insertHistoryQuery = insertHistoryQueryBase + "(" + (ordinal ? ede.getId() : "'" + ede.getCode() + "'") + (oneFieldMapping ? "" : (ordinal ? ", '" + ede.getCode() + "'" : ", " + ede.getId())) + ");";
                                try {
                                    this.ut.begin();
                                    inserts += entityManager.createNativeQuery(insertHistoryQuery).executeUpdate();
                                    this.ut.commit();
                                }
                                catch (Exception ex) {
                                    try {
                                        this.ut.rollback();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    logger.log(Level.INFO, () -> String.format(LOG_WARNING_ENUM_MAPPING_TABLE_MODIFICATION_ERROR, historyTable, "insert", 1, "insert", ", possible duplicate entry with key " + (ordinal ? ede.getId() : "'" + ede.getCode() + "'")));
                                }
                            }
                            int number = inserts;
                            if (inserts > 0) {
                                logger.log(Level.INFO, () -> String.format(LOG_INFO_ENUM_MAPPING_TABLE_MODIFIED, historyTable, enumeratedType.getSimpleName(), number, "inserts in history table"));
                            }
                            if (inserts != absentInBase.size()) {
                                logger.log(Level.INFO, () -> String.format(LOG_WARNING_ENUM_MAPPING_TABLE_MODIFICATION_ERROR, historyTable, "insert", absentInBase.size(), "insert", ", but only " + number + " of inserts was successful"));
                            }
                        }
                    }
                    if (doInserts && !absentInTarget.isEmpty()) {
                        StringBuilder insertQuery = new StringBuilder("INSERT INTO " + enumTable + " (" + (ordinal ? idEnumColumn : codeEnumColumn) + (oneFieldMapping ? "" : (ordinal ? ", " + codeEnumColumn : ", " + idEnumColumn)) + ") VALUES ");
                        Iterator iter = absentInTarget.iterator();
                        while (iter.hasNext()) {
                            EnumData.EnumDataEntry ede = (EnumData.EnumDataEntry)iter.next();
                            insertQuery.append("(" + (ordinal ? ede.getId() : "'" + ede.getCode() + "'") + (oneFieldMapping ? "" : (ordinal ? ", '" + ede.getCode() + "'" : ", " + ede.getId())) + (iter.hasNext() ? "), " : ");"));
                        }
                        try {
                            this.ut.begin();
                            int inserts = numInserts = entityManager.createNativeQuery(insertQuery.toString()).executeUpdate();
                            logger.log(Level.INFO, () -> String.format(LOG_INFO_ENUM_MAPPING_TABLE_MODIFIED, enumTable, enumeratedType.getSimpleName(), inserts, "inserts"));
                            this.ut.commit();
                        }
                        catch (Exception ex) {
                            try {
                                this.ut.rollback();
                            }
                            catch (Exception ede) {
                                // empty catch block
                            }
                            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_ENUM_MAPPING_TABLE_MODIFICATION_ERROR, enumTable, "insert", absentInTarget.size(), "insert", ""));
                            boolean ede = false;
                            entityManager.close();
                            return ede;
                        }
                    }
                    if (!different.isEmpty()) {
                        StringBuilder updateQuery = new StringBuilder();
                        Iterator iter = different.keySet().iterator();
                        while (iter.hasNext()) {
                            EnumData.EnumDataEntry ede = (EnumData.EnumDataEntry)iter.next();
                            updateQuery.append("UPDATE " + enumTable + " SET " + (ordinal ? codeEnumColumn : idEnumColumn) + " = " + (ordinal ? "'" + ede.getCode() + "'" : ede.getId()) + " WHERE " + (ordinal ? idEnumColumn : codeEnumColumn) + " = " + (ordinal ? ede.getId() : "'" + ede.getCode() + "'") + (iter.hasNext() ? "; " : ";"));
                        }
                        try {
                            this.ut.begin();
                            int updates = entityManager.createNativeQuery(updateQuery.toString()).executeUpdate();
                            logger.log(Level.INFO, () -> String.format(LOG_INFO_ENUM_MAPPING_TABLE_MODIFIED, enumTable, enumeratedType.getSimpleName(), updates, "updates"));
                            this.ut.commit();
                        }
                        catch (Exception ex) {
                            try {
                                this.ut.rollback();
                            }
                            catch (Exception ede) {
                                // empty catch block
                            }
                            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_ENUM_MAPPING_TABLE_MODIFICATION_ERROR, enumTable, "update", different.size(), "update", ""));
                            boolean ede = false;
                            entityManager.close();
                            return ede;
                        }
                    }
                    mustUpdateSecondaryField = !oneFieldMapping;
                } else {
                    boolean hasErrorsWhileModifyingEnums;
                    int inserts;
                    List newValues = Arrays.asList(enumeratedType.getEnumConstants()).stream().filter(Objects::nonNull).collect(Collectors.toList());
                    if (doDeletes && !absentInTarget.isEmpty()) {
                        numDeletes = absentInTarget.stream().mapToInt(del -> {
                            Optional<Enum> enumToDeleteOptional = newValues.stream().filter(enumConstant -> Objects.equals(ordinal ? del.id : del.code, ordinal ? Integer.valueOf(enumConstant.ordinal()) : enumConstant.name())).findFirst();
                            if (enumToDeleteOptional.isPresent()) {
                                Enum enumToDelete = enumToDeleteOptional.get();
                                newValues.remove(enumToDelete);
                                Optional<Field> staticEnumConstantOptional = Arrays.asList(enumeratedType.getDeclaredFields()).stream().filter(field -> {
                                    try {
                                        return field.isEnumConstant() && field.get(null) == enumToDelete;
                                    }
                                    catch (Exception ex) {
                                        return false;
                                    }
                                }).findFirst();
                                if (staticEnumConstantOptional.isPresent()) {
                                    try {
                                        Reflections.modifyField(null, (Field)staticEnumConstantOptional.get(), null);
                                    }
                                    catch (Exception ex) {
                                        logger.log(Level.INFO, () -> String.format(LOG_WARNING_UNMODIFIABLE_ENUM_FIELD, ((Field)staticEnumConstantOptional.get()).getName(), enumeratedType));
                                    }
                                }
                                return 1;
                            }
                            return 0;
                        }).sum();
                        if (doSoftDeletes) {
                            StringBuilder insertHistoryQueryBase = new StringBuilder("INSERT INTO " + enumTable + " (" + ("".equals(idEnumColumn) ? "" : idEnumColumn) + ("".equals(codeEnumColumn) ? "" : (oneFieldMapping ? "" : ", ") + codeEnumColumn) + ", " + deletedColumn + ")" + " VALUES ");
                            inserts = 0;
                            for (EnumData.EnumDataEntry ede : absentInTarget) {
                                String insertHistoryQuery = insertHistoryQueryBase + "(" + ("".equals(idEnumColumn) ? "" : ede.getId()) + ("".equals(codeEnumColumn) ? "" : (oneFieldMapping ? "" : ", ") + "'" + ede.getCode() + "'") + ", 1);";
                                try {
                                    this.ut.begin();
                                    inserts += entityManager.createNativeQuery(insertHistoryQuery).executeUpdate();
                                    this.ut.commit();
                                }
                                catch (Exception ex) {
                                    try {
                                        this.ut.rollback();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    logger.log(Level.INFO, () -> String.format(LOG_WARNING_ENUM_MAPPING_TABLE_MODIFICATION_ERROR, enumTable, "insert", 1, "insert", ", possible duplicate entry with key " + (ordinal ? ede.getId() : ede.getCode())));
                                }
                            }
                            int number = inserts;
                            if (inserts > 0) {
                                logger.log(Level.INFO, () -> String.format(LOG_INFO_ENUM_MAPPING_TABLE_MODIFIED, enumTable, enumeratedType.getSimpleName(), number, "number of inserts in history table"));
                            }
                            if (inserts != absentInTarget.size()) {
                                logger.log(Level.INFO, () -> String.format(LOG_WARNING_ENUM_MAPPING_TABLE_MODIFICATION_ERROR, enumTable, "insert", absentInBase.size(), "number of inserts in history table", ", but only " + number + " number of inserts was successful"));
                            }
                        }
                        if (numDeletes != absentInTarget.size()) {
                            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_CANNOT_MODIFY_ENUM_DATA, enumeratedType, "removal of enum values"));
                            boolean insertHistoryQueryBase = false;
                            return insertHistoryQueryBase;
                        }
                        newValuesField = newValues;
                    }
                    if (doInserts && !absentInBase.isEmpty()) {
                        boolean hasErrorsWhileCreatingEnums;
                        Optional<Object> constructorAccessorOptional = EnumMappingTableService.getEnumConstructorAccessor(enumeratedType);
                        if (!constructorAccessorOptional.isPresent()) {
                            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_CANNOT_ACCESS_ENUM_CONSTRUCTOR, enumeratedType));
                            inserts = 0;
                            return inserts != 0;
                        }
                        Object constructorAccessor = constructorAccessorOptional.get();
                        Optional<Method> newInstanceMethodOptional = this.getEnumNewInstanceMethod(enumeratedType, constructorAccessor);
                        if (!newInstanceMethodOptional.isPresent()) {
                            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_CANNOT_ACCESS_ENUM_CONSTRUCTOR, enumeratedType));
                            boolean ede = false;
                            return ede;
                        }
                        Method newInstanceMethod = newInstanceMethodOptional.get();
                        numInserts = absentInBase.stream().mapToInt(insert -> {
                            int id = insert.id == null ? (newValues.isEmpty() ? 0 : newValues.stream().map(enumConstant -> enumConstant.ordinal()).mapToInt(Integer::intValue).max().getAsInt() + 1) : insert.id;
                            String code = insert.code == null ? "DEFAULT_" + id : insert.code;
                            try {
                                Enum newEnum = (Enum)enumeratedType.cast(newInstanceMethod.invoke(constructorAccessor, new Object[]{new Object[]{code, id}}));
                                newValues.add(newEnum);
                                if (idEnumFieldOptional.isPresent()) {
                                    Reflections.modifyField((Object)newEnum, (Field)((Field)idEnumFieldOptional.get()), (Object)id);
                                }
                                if (codeEnumFieldOptional.isPresent()) {
                                    Reflections.modifyField((Object)newEnum, (Field)((Field)codeEnumFieldOptional.get()), (Object)code);
                                }
                            }
                            catch (Exception ex) {
                                return 0;
                            }
                            return 1;
                        }).sum();
                        boolean bl = hasErrorsWhileCreatingEnums = numInserts != absentInBase.size();
                        if (hasErrorsWhileCreatingEnums) {
                            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_CANNOT_INSTANTIATE_NEW_ENUM, enumeratedType));
                            boolean ex = false;
                            return ex;
                        }
                        newValuesField = newValues;
                    }
                    if (!different.isEmpty() && (hasErrorsWhileModifyingEnums = different.entrySet().stream().map(entry -> {
                        EnumData.EnumDataEntry target = (EnumData.EnumDataEntry)entry.getValue();
                        Object primaryValue = ordinal ? target.id : target.code;
                        Object secondaryValue = ordinal ? target.code : target.id;
                        Optional<Enum> enumToModifyOptional = newValues.stream().filter(enumConstant -> Objects.equals(primaryValue, ordinal ? Integer.valueOf(enumConstant.ordinal()) : enumConstant.name())).findFirst();
                        if (enumToModifyOptional.isPresent()) {
                            try {
                                Reflections.modifyField((Object)enumToModifyOptional.get(), (Field)secondaryEnumField, (Object)secondaryValue);
                            }
                            catch (Exception ex) {
                                logger.log(Level.WARNING, () -> String.format(LOG_WARNING_UNMODIFIABLE_ENUM_FIELD, secondaryEnumField.getName(), enumeratedType));
                                return true;
                            }
                        }
                        return false;
                    }).anyMatch(e -> e))) {
                        logger.log(Level.WARNING, () -> String.format(LOG_WARNING_CANNOT_MODIFY_ENUM_DATA, enumeratedType, "modification of secondary values"));
                        boolean constructorAccessor = false;
                        return constructorAccessor;
                    }
                    if (!different.isEmpty() || !oneFieldMapping && !common.isEmpty()) {
                        mustUpdateSecondaryField = true;
                    }
                }
                List<Enum> list = valuesToUpdate = newValuesField == null ? Arrays.asList(enumeratedType.getEnumConstants()).stream().filter(Objects::nonNull).collect(Collectors.toList()) : newValuesField;
                if (mustUpdateSecondaryField) {
                    Field targetSecondaryField = (Field)Reflections.findField(enumeratedType.getSuperclass(), (String)(ordinal ? "name" : "ordinal")).get();
                    boolean hasErrorsWhileModifyingEnums = valuesToUpdate.stream().map(constant -> {
                        try {
                            Object value = Reflections.accessField((Object)constant, (Field)secondaryEnumField);
                            Reflections.modifyField((Object)constant, (Field)targetSecondaryField, (Object)value);
                        }
                        catch (Exception ex) {
                            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_UNMODIFIABLE_ENUM_FIELD, targetSecondaryField.getName(), enumeratedType));
                            return true;
                        }
                        return false;
                    }).anyMatch(e -> e);
                    if (hasErrorsWhileModifyingEnums) {
                        logger.log(Level.WARNING, () -> String.format(LOG_WARNING_CANNOT_MODIFY_ENUM_DATA, enumeratedType, "modification of " + (ordinal ? "name values" : "ordinal values")));
                        boolean newInstanceMethodOptional = false;
                        return newInstanceMethodOptional;
                    }
                    logger.log(Level.INFO, () -> String.format(LOG_INFO_ENUM_DATA_MODIFIED, enumeratedType, valuesToUpdate.size(), "modification of " + (ordinal ? "name values" : "ordinal values")));
                }
                if (newValuesField == null && (!mustUpdateSecondaryField || ordinal)) break block99;
                try {
                    int number;
                    int maxOrdinal = valuesToUpdate.stream().mapToInt(Enum::ordinal).max().orElse(0);
                    Object values = Array.newInstance(enumeratedType, maxOrdinal + 1);
                    valuesToUpdate.forEach(constant -> Array.set(values, constant.ordinal(), constant));
                    Object nonBlankValues = Array.newInstance(enumeratedType, valuesToUpdate.size());
                    int i = 0;
                    for (Enum e2 : valuesToUpdate) {
                        Array.set(nonBlankValues, i++, e2);
                    }
                    Field enumValues = enumeratedType.getDeclaredField("$VALUES");
                    Reflections.modifyField(null, (Field)enumValues, (Object)values);
                    Field enumConstants = (Field)Reflections.findField(Class.class, (String)"enumConstants").get();
                    Reflections.modifyField(enumeratedType, (Field)enumConstants, null);
                    Enum<?>[] constants = enumeratedType.getEnumConstants();
                    Field enumConstantDirectory = (Field)Reflections.findField(Class.class, (String)"enumConstantDirectory").get();
                    Reflections.modifyField(enumeratedType, (Field)enumConstantDirectory, Arrays.asList(constants).stream().filter(Objects::nonNull).collect(Collectors.toMap(Enum::name, Function.identity())));
                    Reflections.modifyField(null, (Field)enumValues, (Object)nonBlankValues);
                    if (!enumPrecedence && numInserts > 0) {
                        number = numInserts;
                        logger.log(Level.INFO, () -> String.format(LOG_INFO_ENUM_DATA_MODIFIED, enumeratedType, number, "inserts"));
                    }
                    if (!enumPrecedence && numDeletes > 0) {
                        number = numDeletes;
                        logger.log(Level.INFO, () -> String.format(LOG_INFO_ENUM_DATA_MODIFIED, enumeratedType, number, "deletes"));
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, () -> String.format(LOG_WARNING_CANNOT_MODIFY_ENUM_DATA, enumeratedType, "replacement of enum values"));
                    boolean bl = false;
                    entityManager.close();
                    return bl;
                }
            }
        }
        return true;
    }

    static boolean modifyEnumMapping(Class<? extends Enum<?>> enumeratedType) {
        boolean validFieldType;
        boolean mappedByOrdinal;
        EnumMapping enumMapping = enumeratedType.getAnnotation(EnumMapping.class);
        boolean bl = mappedByOrdinal = enumMapping.type() == EnumType.ORDINAL;
        String fieldName = "".equals(enumMapping.fieldName()) ? (mappedByOrdinal ? "id" : "code") : enumMapping.fieldName();
        Optional optionalField = Reflections.findField(enumeratedType, (String)fieldName);
        if (!optionalField.isPresent()) {
            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_INVALID_ENUM_FIELD_NAME, enumeratedType, fieldName));
            return false;
        }
        Field field = (Field)optionalField.get();
        boolean bl2 = mappedByOrdinal ? field.getType() == Integer.class || field.getType() == Integer.TYPE : (validFieldType = field.getType() == String.class);
        if (!validFieldType) {
            logger.log(Level.WARNING, () -> String.format(LOG_WARNING_INVALID_ENUM_FIELD_TYPE, enumeratedType, field.getName(), mappedByOrdinal ? "Integer" : "String", field.getType()));
            return false;
        }
        Field targetField = (Field)Reflections.findField(enumeratedType.getSuperclass(), (String)(mappedByOrdinal ? "ordinal" : "name")).get();
        List<Enum<?>> constants = Arrays.asList(enumeratedType.getEnumConstants());
        int maxOrdinal = constants.stream().map(constant -> {
            Object value = Reflections.accessField((Object)constant, (Field)field);
            Reflections.modifyField((Object)constant, (Field)targetField, (Object)value);
            return mappedByOrdinal ? (Integer)value : 0;
        }).mapToInt(Integer::intValue).max().orElse(0);
        if (mappedByOrdinal) {
            try {
                Object values = Array.newInstance(enumeratedType, maxOrdinal + 1);
                constants.forEach(constant -> Array.set(values, constant.ordinal(), constant));
                Field enumValues = (Field)Reflections.findField(enumeratedType, (String)"$VALUES").get();
                Object oldValues = Reflections.modifyField(null, (Field)enumValues, (Object)values);
                Field enumConstants = (Field)Reflections.findField(Class.class, (String)"enumConstants").get();
                Reflections.modifyField(enumeratedType, (Field)enumConstants, null);
                Enum<?>[] enumeratedConstants = enumeratedType.getEnumConstants();
                Field enumConstantDirectory = (Field)Reflections.findField(Class.class, (String)"enumConstantDirectory").get();
                Reflections.modifyField(enumeratedType, (Field)enumConstantDirectory, Arrays.asList(enumeratedConstants).stream().filter(Objects::nonNull).collect(Collectors.toMap(Enum::name, Function.identity())));
                Reflections.modifyField(null, (Field)enumValues, (Object)oldValues);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e, () -> String.format(LOG_WARNING_UNMODIFIABLE_ENUM_FIELD, enumeratedType, fieldName));
                return false;
            }
        }
        return true;
    }

    private static String toSnakeCase(String camelCase) {
        if (camelCase == null) {
            return null;
        }
        return camelCase.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }

    public static Optional<Object> getEnumConstructorAccessor(Class<? extends Enum<?>> enumeratedType) {
        Object constructorAccessor = null;
        try {
            Constructor<Enum<?>> noArgumentEnumConstructor = enumeratedType.getDeclaredConstructor(String.class, Integer.TYPE);
            Method acquireConstructorAccessorMethod = Arrays.asList(noArgumentEnumConstructor.getClass().getDeclaredMethods()).stream().filter(method -> method.getName().equals("acquireConstructorAccessor")).findFirst().orElseThrow(NoSuchMethodException::new);
            acquireConstructorAccessorMethod.setAccessible(true);
            acquireConstructorAccessorMethod.invoke(noArgumentEnumConstructor, new Object[0]);
            Field constructorAccessorField = Arrays.asList(noArgumentEnumConstructor.getClass().getDeclaredFields()).stream().filter(field -> field.getName().equals("constructorAccessor")).findFirst().orElseThrow(NoSuchFieldException::new);
            constructorAccessorField.setAccessible(true);
            constructorAccessor = constructorAccessorField.get(noArgumentEnumConstructor);
            return Optional.of(constructorAccessor);
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private Optional<Method> getEnumNewInstanceMethod(Class<? extends Enum<?>> enumeratedType, Object constructorAccessor) {
        try {
            Method newInstanceMethod = constructorAccessor.getClass().getMethod("newInstance", Object[].class);
            newInstanceMethod.setAccessible(true);
            return Optional.of(newInstanceMethod);
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private static class EnumData {
        private Set<EnumDataEntry> data = new LinkedHashSet<EnumDataEntry>();
        private boolean ordinal;
        private boolean oneField;
        private Class<? extends Enum<?>> enumClass;

        public EnumData(boolean ordinal, boolean oneField, Class<? extends Enum<?>> enumClass) {
            this.ordinal = ordinal;
            this.oneField = oneField;
            this.enumClass = enumClass;
        }

        public void addDataElement(Integer id, String code) {
            this.addDataElementInternal(id, code);
        }

        public void addDataElement(Integer id) {
            this.addDataElementInternal(id, null);
        }

        public void addDataElement(String code) {
            this.addDataElementInternal(null, code);
        }

        private void addDataElementInternal(Integer id, String code) {
            this.data.add(new EnumDataEntry(id, code, this));
        }

        public static void compareEnumData(EnumData base, EnumData target, Set<EnumDataEntry> common, Set<EnumDataEntry> absentInBase, Set<EnumDataEntry> absentInTarget, Map<EnumDataEntry, EnumDataEntry> different) {
            Set<EnumDataEntry> baseEnumData = base.data;
            Set<EnumDataEntry> targetEnumData = target.data;
            common.clear();
            absentInBase.clear();
            absentInTarget.clear();
            different.clear();
            absentInBase.addAll(targetEnumData);
            int tries = targetEnumData.size();
            for (EnumDataEntry baseData : baseEnumData) {
                boolean found = false;
                if (tries != 0) {
                    Iterator<EnumDataEntry> targetIter = absentInBase.iterator();
                    while (targetIter.hasNext()) {
                        EnumDataEntry targetData = targetIter.next();
                        if (!Objects.equals(baseData, targetData)) continue;
                        found = true;
                        --tries;
                        if (base.oneField) {
                            common.add(baseData);
                        } else if (baseData.compareComplementary(targetData)) {
                            common.add(baseData);
                        } else {
                            different.put(baseData, targetData);
                        }
                        targetIter.remove();
                        break;
                    }
                }
                if (found) continue;
                absentInTarget.add(baseData);
            }
        }

        private static class EnumDataEntry {
            Integer id;
            String code;
            EnumData enumData;

            public EnumDataEntry(Integer id, String code, EnumData enumData) {
                this.id = id;
                this.code = code;
                this.enumData = enumData;
            }

            public Integer getId() {
                return this.id;
            }

            public String getCode() {
                return this.code;
            }

            public boolean compareComplementary(EnumDataEntry ede) {
                return Objects.equals(this.enumData.ordinal ? this.code : this.id, ede.enumData.ordinal ? ede.code : ede.id);
            }

            public int hashCode() {
                int hash = 7;
                hash = this.enumData.ordinal ? 89 * hash + Objects.hashCode(this.id) : 89 * hash + Objects.hashCode(this.code);
                return hash;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                EnumDataEntry other = (EnumDataEntry)obj;
                return this.enumData.ordinal ? Objects.equals(this.id, other.id) : Objects.equals(this.code, other.code);
            }

            public String toString() {
                return "{id = " + this.id + ", code = " + this.code + "}";
            }
        }
    }
}

