/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.omnifaces.persistence.service.PostponedFetch;
import org.omnifaces.persistence.service.RootWrapper;

class EclipseLinkRoot<X>
extends RootWrapper<X> {
    private Set<String> postponedFetches = new HashSet<String>(2);

    public EclipseLinkRoot(Root<X> wrapped) {
        super(wrapped);
    }

    @Override
    public <X, Y> Fetch<X, Y> fetch(String attributeName) {
        return new PostponedFetch(this.postponedFetches, attributeName);
    }

    public boolean hasPostponedFetches() {
        return !this.postponedFetches.isEmpty();
    }

    public void runPostponedFetches(Query query) {
        this.postponedFetches.forEach(fetch -> query.setHint("eclipselink.batch", (Object)("e." + fetch)));
    }

    public void collectPostponedFetches(Map<String, Path<?>> paths) {
        this.postponedFetches.forEach(fetch -> {
            EclipseLinkRoot path = this;
            for (String attribute : fetch.split("\\.")) {
                path = path.get(attribute);
            }
            paths.put((String)fetch, (Path<?>)path);
        });
    }
}

