/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import javax.ejb.SessionContext;
import javax.enterprise.inject.spi.CDI;
import javax.naming.InitialContext;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.Entity;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.ValidationMode;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.omnifaces.persistence.Database;
import org.omnifaces.persistence.JPA;
import org.omnifaces.persistence.Provider;
import org.omnifaces.persistence.criteria.Bool;
import org.omnifaces.persistence.criteria.Criteria;
import org.omnifaces.persistence.criteria.IgnoreCase;
import org.omnifaces.persistence.criteria.Not;
import org.omnifaces.persistence.criteria.Numeric;
import org.omnifaces.persistence.exception.IllegalEntityStateException;
import org.omnifaces.persistence.exception.NonDeletableEntityException;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.model.EnumMapping;
import org.omnifaces.persistence.model.EnumMappingTable;
import org.omnifaces.persistence.model.GeneratedIdEntity;
import org.omnifaces.persistence.model.NonDeletable;
import org.omnifaces.persistence.model.dto.Page;
import org.omnifaces.persistence.service.Alias;
import org.omnifaces.persistence.service.EclipseLinkRoot;
import org.omnifaces.persistence.service.EnumMappingTableService;
import org.omnifaces.persistence.service.MappedPathResolver;
import org.omnifaces.persistence.service.PageBuilder;
import org.omnifaces.persistence.service.PathResolver;
import org.omnifaces.persistence.service.RootPathResolver;
import org.omnifaces.persistence.service.RootWrapper;
import org.omnifaces.persistence.service.SoftDeleteData;
import org.omnifaces.persistence.service.SubqueryRoot;
import org.omnifaces.persistence.service.UncheckedParameterBuilder;
import org.omnifaces.utils.Lang;
import org.omnifaces.utils.collection.PartialResultList;
import org.omnifaces.utils.reflect.Getter;
import org.omnifaces.utils.reflect.Reflections;
import org.omnifaces.utils.stream.Streams;

public abstract class BaseEntityService<I extends Comparable<I> & Serializable, E extends BaseEntity<I>> {
    private static final Logger logger = Logger.getLogger(BaseEntityService.class.getName());
    private static final String LOG_FINER_GET_PAGE = "Get page: %s, count=%s, cacheable=%s, resultType=%s";
    private static final String LOG_FINER_SET_PARAMETER_VALUES = "Set parameter values: %s";
    private static final String LOG_FINER_QUERY_RESULT = "Query result: %s, estimatedTotalNumberOfResults=%s";
    private static final String LOG_FINE_COMPUTED_TYPE_MAPPING = "Computed type mapping for %s: <%s, %s>";
    private static final String LOG_FINE_COMPUTED_GENERATED_ID_MAPPING = "Computed generated ID mapping for %s: %s";
    private static final String LOG_FINE_COMPUTED_SOFT_DELETE_MAPPING = "Computed soft delete mapping for %s: %s";
    private static final String LOG_FINE_COMPUTED_ELEMENTCOLLECTION_MAPPING = "Computed @ElementCollection mapping for %s: %s";
    private static final String LOG_FINE_COMPUTED_MANY_OR_ONE_TO_ONE_MAPPING = "Computed @ManyToOne/@OneToOne mapping for %s: %s";
    private static final String LOG_FINE_COMPUTED_ONE_TO_MANY_MAPPING = "Computed @OneToMany mapping for %s: %s";
    private static final String LOG_INFO_COMPUTED_MODIFIED_ENUM_MAPPING = "Enum mapping for enum %s: was %smodified";
    private static final String LOG_INFO_COMPUTED_MODIFIED_ENUM_MAPPING_TABLE = "Enum mapping table for enum %s: was %smodified";
    private static final String LOG_WARNING_ILLEGAL_CRITERIA_VALUE = "Cannot parse predicate for %s(%s) = %s(%s), skipping!";
    private static final String LOG_SEVERE_CONSTRAINT_VIOLATION = "javax.validation.ConstraintViolation: @%s %s#%s %s on %s";
    private static final String ERROR_ILLEGAL_MAPPING = "You must return a getter-path mapping from MappedQueryBuilder";
    private static final String ERROR_UNSUPPORTED_CRITERIA = "Predicate for %s(%s) = %s(%s) is not supported. Consider wrapping in a Criteria instance or creating a custom one if you want to deal with it.";
    private static final String ERROR_UNSUPPORTED_ONETOMANY_ORDERBY_ECLIPSELINK = "Sorry, EclipseLink does not support sorting a @OneToMany or @ElementCollection relationship. Consider using a DTO or a DB view instead.";
    private static final String ERROR_UNSUPPORTED_ONETOMANY_ORDERBY_OPENJPA = "Sorry, OpenJPA does not support sorting a @OneToMany or @ElementCollection relationship. Consider using a DTO or a DB view instead.";
    private static final String ERROR_UNSUPPORTED_ONETOMANY_CRITERIA_ECLIPSELINK = "Sorry, EclipseLink does not support searching in a @OneToMany relationship. Consider using a DTO or a DB view instead.";
    private static final String ERROR_UNSUPPORTED_ONETOMANY_CRITERIA_OPENJPA = "Sorry, OpenJPA does not support searching in a @OneToMany relationship. Consider using a DTO or a DB view instead.";
    private static final Map<Class<? extends BaseEntityService>, Map.Entry<Class<?>, Class<?>>> TYPE_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<? extends BaseEntity<?>>, Boolean> GENERATED_ID_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<? extends BaseEntity<?>>, SoftDeleteData> SOFT_DELETE_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<? extends BaseEntity<?>>, Set<String>> ELEMENT_COLLECTION_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<? extends BaseEntity<?>>, Set<String>> MANY_OR_ONE_TO_ONE_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<? extends BaseEntity<?>>, Set<String>> ONE_TO_MANY_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<? extends BaseEntity<?>>, Boolean> CHECKED_ENUM_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<? extends Enum<?>>, Boolean> MODIFIED_ENUM_MAPPINGS = new ConcurrentHashMap();
    private static final Map<Class<? extends Enum<?>>, Boolean> MODIFIED_ENUM_TABLE_MAPPINGS = new ConcurrentHashMap();
    private final Class<I> identifierType;
    private final Class<E> entityType;
    private final boolean generatedId;
    private final SoftDeleteData softDeleteData;
    private Provider provider;
    private Database database;
    private Set<String> elementCollections;
    private Set<String> manyOrOneToOnes;
    private java.util.function.Predicate<String> oneToManys;
    private Validator validator;
    @PersistenceContext
    private EntityManager entityManager;

    public BaseEntityService() {
        Map.Entry typeMapping = TYPE_MAPPINGS.computeIfAbsent(this.getClass(), BaseEntityService::computeTypeMapping);
        this.identifierType = (Class)typeMapping.getKey();
        this.entityType = (Class)typeMapping.getValue();
        this.generatedId = GENERATED_ID_MAPPINGS.computeIfAbsent(this.entityType, BaseEntityService::computeGeneratedIdMapping);
        this.softDeleteData = SOFT_DELETE_MAPPINGS.computeIfAbsent(this.entityType, BaseEntityService::computeSoftDeleteMapping);
        CHECKED_ENUM_MAPPINGS.computeIfAbsent(this.entityType, BaseEntityService::computeModifiedEnumMapping);
    }

    @PostConstruct
    private void initWithEntityManager() {
        this.provider = Provider.of(this.getEntityManager());
        this.database = Database.of(this.getEntityManager());
        this.elementCollections = ELEMENT_COLLECTION_MAPPINGS.computeIfAbsent(this.entityType, this::computeElementCollectionMapping);
        this.manyOrOneToOnes = MANY_OR_ONE_TO_ONE_MAPPINGS.computeIfAbsent(this.entityType, this::computeManyOrOneToOneMapping);
        this.oneToManys = field -> ONE_TO_MANY_MAPPINGS.computeIfAbsent(this.entityType, this::computeOneToManyMapping).stream().anyMatch(oneToMany -> field.startsWith(oneToMany + '.'));
        if (JPA.getValidationMode(this.getEntityManager()) == ValidationMode.CALLBACK) {
            this.validator = (Validator)CDI.current().select(Validator.class, new Annotation[0]).get();
        }
    }

    private static Map.Entry<Class<?>, Class<?>> computeTypeMapping(Class<? extends BaseEntityService> subclass) {
        List actualTypeArguments = Reflections.getActualTypeArguments(subclass, BaseEntityService.class);
        Class identifierType = (Class)actualTypeArguments.get(0);
        Class entityType = (Class)actualTypeArguments.get(1);
        logger.log(Level.FINE, () -> String.format(LOG_FINE_COMPUTED_TYPE_MAPPING, subclass, identifierType, entityType));
        return new AbstractMap.SimpleEntry(identifierType, entityType);
    }

    private static boolean computeGeneratedIdMapping(Class<?> entityType) {
        boolean generatedId = GeneratedIdEntity.class.isAssignableFrom(entityType) || !Reflections.listAnnotatedFields(entityType, (Class[])new Class[]{Id.class, GeneratedValue.class}).isEmpty();
        logger.log(Level.FINE, () -> String.format(LOG_FINE_COMPUTED_GENERATED_ID_MAPPING, entityType, generatedId));
        return generatedId;
    }

    private static SoftDeleteData computeSoftDeleteMapping(Class<?> entityType) {
        SoftDeleteData softDeleteData = new SoftDeleteData(entityType);
        logger.log(Level.FINE, () -> String.format(LOG_FINE_COMPUTED_SOFT_DELETE_MAPPING, entityType, softDeleteData));
        return softDeleteData;
    }

    private static boolean computeModifiedEnumMapping(Class<?> entityType) {
        List<Class<Enum<?>>> enumsToUpdate = Reflections.listAnnotatedEnumFields(entityType, (Class[])new Class[]{Enumerated.class}).stream().filter(enumeratedType -> enumeratedType.isAnnotationPresent(EnumMapping.class) && !MODIFIED_ENUM_MAPPINGS.containsKey(enumeratedType)).peek(enumeratedType -> {
            boolean modified = EnumMappingTableService.modifyEnumMapping(enumeratedType);
            logger.log(Level.INFO, () -> String.format(LOG_INFO_COMPUTED_MODIFIED_ENUM_MAPPING, enumeratedType, modified ? "" : "not "));
            MODIFIED_ENUM_MAPPINGS.put((Class<Enum<?>>)enumeratedType, modified);
        }).filter(enumeratedType -> !MODIFIED_ENUM_TABLE_MAPPINGS.containsKey(enumeratedType) && enumeratedType.getAnnotation(EnumMapping.class).enumMappingTable().mappingType() != EnumMappingTable.MappingType.NO_ACTION).collect(Collectors.toList());
        if (!enumsToUpdate.isEmpty()) {
            EnumMappingTableService emts = (EnumMappingTableService)CDI.current().select(EnumMappingTableService.class, new Annotation[0]).get();
            emts.computeModifiedEnumMappingTable(enumsToUpdate).forEach((enumeratedType, modified) -> {
                logger.log(Level.INFO, () -> String.format(LOG_INFO_COMPUTED_MODIFIED_ENUM_MAPPING_TABLE, enumeratedType, modified != false ? "" : "not "));
                MODIFIED_ENUM_TABLE_MAPPINGS.put((Class<Enum<?>>)enumeratedType, (Boolean)modified);
            });
        }
        return true;
    }

    private Set<String> computeElementCollectionMapping(Class<? extends BaseEntity<?>> entityType) {
        Set<String> elementCollectionMapping = this.computeEntityMapping(entityType, "", new HashSet(), this.provider::isElementCollection);
        logger.log(Level.FINE, () -> String.format(LOG_FINE_COMPUTED_ELEMENTCOLLECTION_MAPPING, entityType, elementCollectionMapping));
        return elementCollectionMapping;
    }

    private Set<String> computeManyOrOneToOneMapping(Class<? extends BaseEntity<?>> entityType) {
        Set<String> manyOrOneToOneMapping = this.computeEntityMapping(entityType, "", new HashSet(), this.provider::isManyOrOneToOne);
        logger.log(Level.FINE, () -> String.format(LOG_FINE_COMPUTED_MANY_OR_ONE_TO_ONE_MAPPING, entityType, manyOrOneToOneMapping));
        return manyOrOneToOneMapping;
    }

    private Set<String> computeOneToManyMapping(Class<? extends BaseEntity<?>> entityType) {
        Set<String> oneToManyMapping = this.computeEntityMapping(entityType, "", new HashSet(), this.provider::isOneToMany);
        logger.log(Level.FINE, () -> String.format(LOG_FINE_COMPUTED_ONE_TO_MANY_MAPPING, entityType, oneToManyMapping));
        return oneToManyMapping;
    }

    private Set<String> computeEntityMapping(Class<?> type, String basePath, Set<Class<?>> nestedTypes, java.util.function.Predicate<Attribute<?, ?>> attributePredicate) {
        HashSet<String> entityMapping = new HashSet<String>(2);
        EntityType entity = this.getEntityManager().getMetamodel().entity(type);
        for (Attribute attribute : entity.getAttributes()) {
            Class nestedType;
            if (attributePredicate.test(attribute)) {
                entityMapping.add(basePath + attribute.getName());
            }
            if (!(attribute instanceof Bindable) || !BaseEntity.class.isAssignableFrom(nestedType = ((Bindable)attribute).getBindableJavaType()) || nestedType == this.entityType || !nestedTypes.add(nestedType)) continue;
            entityMapping.addAll(this.computeEntityMapping(nestedType, basePath + attribute.getName() + '.', nestedTypes, attributePredicate));
        }
        return Collections.unmodifiableSet(entityMapping);
    }

    public Provider getProvider() {
        return this.provider;
    }

    public Database getDatabase() {
        return this.database;
    }

    protected Class<I> getIdentifierType() {
        return this.identifierType;
    }

    protected Class<E> getEntityType() {
        return this.entityType;
    }

    protected boolean isGeneratedId() {
        return this.generatedId;
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected EntityType<E> getMetamodel() {
        return this.getEntityManager().getMetamodel().entity(this.entityType);
    }

    public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> EntityType<E> getMetamodel(E entity) {
        return this.getEntityManager().getMetamodel().entity(entity.getClass());
    }

    protected TypedQuery<E> createNamedTypedQuery(String name) {
        return this.getEntityManager().createNamedQuery(name, this.entityType);
    }

    protected Query createNamedQuery(String name) {
        return this.getEntityManager().createNamedQuery(name);
    }

    protected TypedQuery<E> createTypedQuery(String jpql) {
        return this.getEntityManager().createQuery(jpql, this.entityType);
    }

    protected TypedQuery<Long> createLongQuery(String jpql) {
        return this.getEntityManager().createQuery(jpql, Long.class);
    }

    protected Query createQuery(String jpql) {
        return this.getEntityManager().createQuery(jpql);
    }

    protected Optional<E> find(String jpql, Object ... parameters) {
        return this.getOptionalSingleResult(this.list(jpql, parameters));
    }

    protected Optional<E> find(String jpql, Consumer<Map<String, Object>> parameters) {
        return this.getOptionalSingleResult(this.list(jpql, parameters));
    }

    protected Optional<E> find(CriteriaQueryBuilder<E> queryBuilder, Consumer<Map<String, Object>> parameters) {
        return this.getOptionalSingleResult(this.list(queryBuilder, parameters));
    }

    private Optional<E> getOptionalSingleResult(List<E> results) {
        if (results.isEmpty()) {
            return Optional.empty();
        }
        if (results.size() == 1) {
            return Optional.of(results.get(0));
        }
        throw new NonUniqueResultException();
    }

    protected Optional<E> findFirst(String jpql, Object ... parameters) {
        return JPA.getOptionalFirstResult(this.createQuery(jpql, parameters));
    }

    protected Optional<E> findFirst(String jpql, Consumer<Map<String, Object>> parameters) {
        return JPA.getOptionalFirstResult(this.createQuery(jpql, parameters));
    }

    protected Optional<E> findFirst(CriteriaQueryBuilder<E> queryBuilder, Consumer<Map<String, Object>> parameters) {
        return JPA.getOptionalFirstResult(this.createQuery(queryBuilder, parameters));
    }

    public Optional<E> findById(I id) {
        return Optional.ofNullable(this.getById(id, false));
    }

    protected Optional<E> findById(I id, boolean includeSoftDeleted) {
        return Optional.ofNullable(this.getById(id, includeSoftDeleted));
    }

    public Optional<E> findSoftDeletedById(I id) {
        return Optional.ofNullable(this.getSoftDeletedById(id));
    }

    public E getById(I id) {
        return this.getById(id, false);
    }

    protected E getById(I id, boolean includeSoftDeleted) {
        BaseEntity entity = (BaseEntity)this.getEntityManager().find(this.entityType, id);
        if (entity != null && !includeSoftDeleted && this.softDeleteData.isSoftDeleted(entity)) {
            return null;
        }
        return (E)entity;
    }

    public E getByIdWithLoadGraph(I id, String entityGraphName) {
        EntityGraph entityGraph = this.entityManager.getEntityGraph(entityGraphName);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.persistence.loadgraph", entityGraph);
        properties.put("javax.persistence.cache.retrieveMode", CacheRetrieveMode.BYPASS);
        return (E)((BaseEntity)this.getEntityManager().find(this.entityType, id, properties));
    }

    public E getSoftDeletedById(I id) {
        this.softDeleteData.checkSoftDeletable();
        BaseEntity entity = (BaseEntity)this.getEntityManager().find(this.entityType, id);
        if (entity != null && !this.softDeleteData.isSoftDeleted(entity)) {
            return null;
        }
        return (E)entity;
    }

    public List<E> getByIds(Iterable<I> ids) {
        return this.getByIds(ids, false);
    }

    protected List<E> getByIds(Iterable<I> ids, boolean includeSoftDeleted) {
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        String whereClause = this.softDeleteData.getWhereClause(includeSoftDeleted);
        return this.list("SELECT e FROM " + this.entityType.getSimpleName() + " e" + whereClause + (whereClause.isEmpty() ? " WHERE" : " AND") + " e.id IN (:ids) ORDER BY e.id DESC", (Map<String, Object> p) -> p.put("ids", ids));
    }

    protected boolean exists(E entity) {
        Object id = this.provider.getIdentifier(entity);
        return id != null && ((Long)this.createLongQuery("SELECT COUNT(e) FROM " + this.entityType.getSimpleName() + " e WHERE e.id = :id").setParameter("id", id).getSingleResult()).intValue() > 0;
    }

    public List<E> list() {
        return this.list(false);
    }

    protected List<E> list(boolean includeSoftDeleted) {
        return this.list("SELECT e FROM " + this.entityType.getSimpleName() + " e" + this.softDeleteData.getWhereClause(includeSoftDeleted) + " ORDER BY e.id DESC", new Object[0]);
    }

    public List<E> listSoftDeleted() {
        this.softDeleteData.checkSoftDeletable();
        return this.list("SELECT e FROM " + this.entityType.getSimpleName() + " e" + this.softDeleteData.getWhereClause(true) + " ORDER BY e.id DESC", new Object[0]);
    }

    protected List<E> list(String jpql, Object ... parameters) {
        return this.createQuery(jpql, parameters).getResultList();
    }

    protected List<E> list(String jpql, Consumer<Map<String, Object>> parameters) {
        return this.createQuery(jpql, parameters).getResultList();
    }

    protected List<E> list(CriteriaQueryBuilder<E> queryBuilder, Consumer<Map<String, Object>> parameters) {
        return this.createQuery(queryBuilder, parameters).getResultList();
    }

    private TypedQuery<E> createQuery(String jpql, Object ... parameters) {
        TypedQuery query = this.getEntityManager().createQuery(jpql, this.entityType);
        this.setPositionalParameters(query, parameters);
        return query;
    }

    private TypedQuery<E> createQuery(String jpql, Consumer<Map<String, Object>> parameters) {
        TypedQuery query = this.getEntityManager().createQuery(jpql, this.entityType);
        this.setSuppliedParameters(query, parameters);
        return query;
    }

    private TypedQuery<E> createQuery(CriteriaQueryBuilder<E> queryBuilder, Consumer<Map<String, Object>> parameters) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityType);
        Root<E> root = this.buildRoot((AbstractQuery)criteriaQuery);
        queryBuilder.build(criteriaBuilder, criteriaQuery, root);
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        if (root instanceof EclipseLinkRoot) {
            ((EclipseLinkRoot)root).runPostponedFetches((Query)query);
        }
        this.setSuppliedParameters(query, parameters);
        return query;
    }

    public I persist(E entity) {
        return this.persist(entity, true);
    }

    private I persist(E entity, boolean checkExists) {
        if (entity.getId() != null) {
            if (this.generatedId || checkExists && this.exists(entity)) {
                throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity is already persisted. Use update() instead.");
            }
        } else if (!this.generatedId) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has no generated ID. You need to manually set it.");
        }
        try {
            this.getEntityManager().persist(entity);
        }
        catch (ConstraintViolationException e) {
            this.logConstraintViolations(e.getConstraintViolations());
            throw e;
        }
        this.getEntityManager().flush();
        return entity.getId();
    }

    public E update(E entity) {
        return this.update(entity, true);
    }

    private E update(E entity, boolean checkExists) {
        if (entity.getId() == null) {
            if (this.generatedId) {
                throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity is not persisted. Use persist() instead.");
            }
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has no generated ID. You need to manually set it.");
        }
        if (checkExists && !this.exists(entity)) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity is not persisted. Use persist() instead.");
        }
        if (this.validator != null) {
            this.logConstraintViolations(this.validator.validate(entity, new Class[0]));
        }
        return (E)((BaseEntity)this.getEntityManager().merge(entity));
    }

    protected E updateAndFlush(E entity) {
        E updatedEntity = this.update(entity);
        this.getEntityManager().flush();
        return updatedEntity;
    }

    private void logConstraintViolations(Set<? extends ConstraintViolation<?>> constraintViolations) {
        constraintViolations.forEach(violation -> {
            String constraintName = violation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
            String beanName = violation.getRootBeanClass().getSimpleName();
            String propertyName = violation.getPropertyPath().toString();
            String violationMessage = violation.getMessage();
            Object beanInstance = violation.getRootBean();
            logger.severe(String.format(LOG_SEVERE_CONSTRAINT_VIOLATION, constraintName, beanName, propertyName, violationMessage, beanInstance));
        });
    }

    public List<E> update(Iterable<E> entities) {
        return Streams.stream(entities).map(this::update).collect(Collectors.toList());
    }

    protected int update(String jpql, Object ... parameters) {
        return this.createQuery(jpql, parameters).executeUpdate();
    }

    protected int update(String jpql, Consumer<Map<String, Object>> parameters) {
        return this.createQuery(jpql, parameters).executeUpdate();
    }

    public E save(E entity) {
        if (this.generatedId && entity.getId() == null || !this.generatedId && !this.exists(entity)) {
            this.persist(entity, false);
            return entity;
        }
        E update = this.update(entity, false);
        return update;
    }

    protected E saveAndFlush(E entity) {
        E savedEntity = this.save(entity);
        this.getEntityManager().flush();
        return savedEntity;
    }

    public void delete(E entity) {
        if (entity.getClass().isAnnotationPresent(NonDeletable.class)) {
            throw new NonDeletableEntityException((BaseEntity<?>)entity);
        }
        this.getEntityManager().remove(this.manage(entity));
        entity.setId(null);
    }

    public void softDelete(E entity) {
        this.softDeleteData.checkSoftDeletable();
        this.softDeleteData.setSoftDeleted((BaseEntity<?>)this.manage(entity), true);
    }

    public void softUndelete(E entity) {
        this.softDeleteData.checkSoftDeletable();
        this.softDeleteData.setSoftDeleted((BaseEntity<?>)this.manage(entity), false);
    }

    public void delete(Iterable<E> entities) {
        entities.forEach(this::delete);
    }

    public void softDelete(Iterable<E> entities) {
        entities.forEach(this::softDelete);
    }

    public void softUndelete(Iterable<E> entities) {
        entities.forEach(this::softUndelete);
    }

    protected E manage(E entity) {
        if (entity == null) {
            throw new NullPointerException("Entity is null.");
        }
        Object id = this.provider.getIdentifier(entity);
        if (id == null) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Entity has no ID.");
        }
        if (entity.getClass().getAnnotation(Entity.class) != null && this.getEntityManager().contains(entity)) {
            return entity;
        }
        BaseEntity managed = (BaseEntity)this.getEntityManager().find(this.provider.getEntityType(entity), id);
        if (managed == null) {
            throw new EntityNotFoundException("Entity has in meanwhile been deleted.");
        }
        return (E)managed;
    }

    protected <E> E manageIfNecessary(E entity) {
        if (entity == null) {
            return null;
        }
        if (!(entity instanceof BaseEntity)) {
            throw new IllegalArgumentException();
        }
        BaseEntity baseEntity = (BaseEntity)entity;
        Object id = this.provider.getIdentifier(baseEntity);
        if (id == null || entity.getClass().getAnnotation(Entity.class) != null && this.getEntityManager().contains(entity)) {
            return entity;
        }
        return (E)Lang.coalesce((Object[])new Object[]{this.getEntityManager().find(this.provider.getEntityType(baseEntity), id), entity});
    }

    public void reset(E entity) {
        if (!this.provider.isProxy(entity) && this.getEntityManager().contains(entity)) {
            throw new IllegalEntityStateException((BaseEntity<?>)entity, "Only unmanaged entities can be resetted.");
        }
        Object managed = this.manage(entity);
        this.getMetamodel(entity).getAttributes().forEach(attribute -> Reflections.map((Member)attribute.getJavaMember(), (Object)managed, (Object)entity));
    }

    protected long countForeignKeyReferencesTo(E entity) {
        return JPA.countForeignKeyReferences(this.getEntityManager(), this.entityType, this.identifierType, this.manage(entity).getId());
    }

    protected E fetchLazyCollections(E entity, Function<E, Collection<?>> ... getters) {
        return this.fetchPluralAttributes(entity, type -> type != PluralAttribute.CollectionType.MAP, getters);
    }

    protected Optional<E> fetchLazyCollections(Optional<E> entity, Function<E, Collection<?>> ... getters) {
        return Optional.ofNullable(entity.isPresent() ? this.fetchLazyCollections((BaseEntity)entity.get(), getters) : null);
    }

    protected E fetchLazyMaps(E entity, Function<E, Map<?, ?>> ... getters) {
        return this.fetchPluralAttributes(entity, type -> type == PluralAttribute.CollectionType.MAP, getters);
    }

    protected Optional<E> fetchLazyMaps(Optional<E> entity, Function<E, Map<?, ?>> ... getters) {
        return Optional.ofNullable(entity.isPresent() ? this.fetchLazyMaps((BaseEntity)entity.get(), getters) : null);
    }

    protected E fetchLazyBlobs(E entity) {
        return this.fetchSingularAttributes(entity, type -> type == byte[].class);
    }

    protected Optional<E> fetchLazyBlobs(Optional<E> entity) {
        return Optional.ofNullable(entity.isPresent() ? this.fetchLazyBlobs((BaseEntity)entity.get()) : null);
    }

    private E fetchPluralAttributes(E entity, java.util.function.Predicate<PluralAttribute.CollectionType> ofType, Function<E, ?> ... getters) {
        if (Lang.isEmpty((Object[])getters)) {
            for (PluralAttribute a : this.getMetamodel().getPluralAttributes()) {
                if (!ofType.test(a.getCollectionType())) continue;
                Optional.ofNullable(Reflections.invokeGetter(entity, (String)a.getName())).ifPresent(c -> Reflections.invokeMethod((Object)c, (String)"size", (Object[])new Object[0]));
            }
        } else {
            Streams.stream((Object[])getters).forEach(getter -> Optional.ofNullable(getter.apply(entity)).ifPresent(c -> Reflections.invokeMethod((Object)c, (String)"size", (Object[])new Object[0])));
        }
        return entity;
    }

    private E fetchSingularAttributes(E entity, java.util.function.Predicate<Class<?>> ofType) {
        E managed = this.getById(entity.getId());
        for (Attribute a : this.getMetamodel().getSingularAttributes()) {
            if (!ofType.test(a.getJavaType())) continue;
            String name = Lang.capitalize((String)a.getName());
            Reflections.invokeSetter(entity, (String)name, (Object)Reflections.invokeGetter(managed, (String)name));
        }
        return entity;
    }

    protected Consumer<EntityManager> beforePage() {
        return entityManager -> BaseEntityService.noop();
    }

    protected <T extends E> Consumer<TypedQuery<?>> onPage(Class<T> resultType, boolean cacheable) {
        return typedQuery -> {
            if (this.provider == Provider.HIBERNATE) {
                typedQuery.setHint("org.hibernate.cacheable", (Object)cacheable);
            } else if (this.provider == Provider.ECLIPSELINK) {
                typedQuery.setHint("eclipselink.maintain-cache", (Object)cacheable).setHint("eclipselink.refresh", (Object)(!cacheable ? 1 : 0));
            }
            if (this.provider != Provider.OPENJPA) {
                typedQuery.setHint("javax.persistence.cache.storeMode", (Object)(cacheable ? CacheStoreMode.USE : CacheStoreMode.REFRESH)).setHint("javax.persistence.cache.retrieveMode", (Object)(cacheable ? CacheRetrieveMode.USE : CacheRetrieveMode.BYPASS));
            }
        };
    }

    protected Consumer<EntityManager> afterPage() {
        return entityManager -> BaseEntityService.noop();
    }

    public PartialResultList<E> getPage(Page page, boolean count) {
        return this.getPage(page, count, true, this.entityType, (CriteriaBuilder builder, AbstractQuery<T> query, Root<T> root) -> (LinkedHashMap)BaseEntityService.noop());
    }

    protected PartialResultList<E> getPage(Page page, boolean count, String ... fetchFields) {
        return this.getPage(page, count, true, fetchFields);
    }

    protected PartialResultList<E> getPage(Page page, boolean count, boolean cacheable, String ... fetchFields) {
        return this.getPage(page, count, cacheable, this.entityType, (CriteriaBuilder builder, AbstractQuery<T> query, Root<T> root) -> {
            for (String fetchField : fetchFields) {
                Root fetchParent = root;
                for (String attribute : fetchField.split("\\.")) {
                    fetchParent = fetchParent.fetch(attribute);
                }
            }
            return null;
        });
    }

    protected PartialResultList<E> getPage(Page page, boolean count, QueryBuilder<E> queryBuilder) {
        return this.getPage(page, count, true, queryBuilder);
    }

    protected PartialResultList<E> getPage(Page page, boolean count, boolean cacheable, QueryBuilder<E> queryBuilder) {
        return this.getPage(page, count, cacheable, this.entityType, (CriteriaBuilder builder, AbstractQuery<T> query, Root<T> root) -> {
            queryBuilder.build(builder, query, root);
            return new LinkedHashMap(0);
        });
    }

    protected <T extends E> PartialResultList<T> getPage(Page page, boolean count, Class<T> resultType, MappedQueryBuilder<T> mappedQueryBuilder) {
        return this.getPage(page, count, true, resultType, mappedQueryBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends E> PartialResultList<T> getPage(Page page, boolean count, boolean cacheable, Class<T> resultType, MappedQueryBuilder<T> queryBuilder) {
        this.beforePage().accept(this.getEntityManager());
        try {
            logger.log(Level.FINER, () -> String.format(LOG_FINER_GET_PAGE, page, count, cacheable, resultType));
            PageBuilder<T> pageBuilder = new PageBuilder<T>(page, cacheable, resultType, queryBuilder);
            CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
            TypedQuery<T> entityQuery = this.buildEntityQuery(pageBuilder, criteriaBuilder);
            TypedQuery<Long> countQuery = count ? this.buildCountQuery(pageBuilder, criteriaBuilder) : null;
            PartialResultList<T> partialResultList = this.executeQuery(pageBuilder, entityQuery, countQuery);
            return partialResultList;
        }
        finally {
            this.afterPage().accept(this.getEntityManager());
        }
    }

    private <T extends E> TypedQuery<T> buildEntityQuery(PageBuilder<T> pageBuilder, CriteriaBuilder criteriaBuilder) {
        CriteriaQuery entityQuery = criteriaBuilder.createQuery(pageBuilder.getResultType());
        Root<E> entityQueryRoot = this.buildRoot((AbstractQuery<T>)entityQuery);
        PathResolver pathResolver = this.buildSelection(pageBuilder, (AbstractQuery<T>)entityQuery, entityQueryRoot, criteriaBuilder);
        this.buildOrderBy(pageBuilder, entityQuery, criteriaBuilder, pathResolver);
        Map<String, Object> parameters = this.buildRestrictions(pageBuilder, (AbstractQuery<T>)entityQuery, criteriaBuilder, pathResolver);
        return this.buildTypedQuery(pageBuilder, entityQuery, entityQueryRoot, parameters);
    }

    private <T extends E> TypedQuery<Long> buildCountQuery(PageBuilder<T> pageBuilder, CriteriaBuilder criteriaBuilder) {
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root countQueryRoot = countQuery.from(this.entityType);
        countQuery.select((Selection)criteriaBuilder.count((Expression)countQueryRoot));
        Map<String, Object> parameters = pageBuilder.shouldBuildCountSubquery() ? this.buildCountSubquery(pageBuilder, (CriteriaQuery<Long>)countQuery, countQueryRoot, criteriaBuilder) : Collections.emptyMap();
        return this.buildTypedQuery(pageBuilder, countQuery, null, parameters);
    }

    private <T extends E> Map<String, Object> buildCountSubquery(PageBuilder<T> pageBuilder, CriteriaQuery<Long> countQuery, Root<E> countRoot, CriteriaBuilder criteriaBuilder) {
        Subquery countSubquery = countQuery.subquery(pageBuilder.getResultType());
        Root<E> countSubqueryRoot = this.buildRoot((AbstractQuery<T>)countSubquery);
        PathResolver subqueryPathResolver = this.buildSelection(pageBuilder, (AbstractQuery<T>)countSubquery, countSubqueryRoot, criteriaBuilder);
        Map<String, Object> parameters = this.buildRestrictions(pageBuilder, (AbstractQuery<T>)countSubquery, criteriaBuilder, subqueryPathResolver);
        if (this.provider == Provider.HIBERNATE) {
            countQuery.where((Expression)criteriaBuilder.in(countRoot).value((Expression)countSubquery));
        } else if (this.provider == Provider.OPENJPA) {
            countQuery.where((Expression)criteriaBuilder.in((Expression)countRoot.get("id")).value((Expression)countSubquery));
        } else {
            countQuery.where((Expression)criteriaBuilder.exists(countSubquery.where((Expression)BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, countSubquery.getRestriction(), criteriaBuilder.equal((Expression)countSubqueryRoot.get("id"), (Expression)countRoot.get("id"))))));
        }
        return parameters;
    }

    private <T extends E, Q> TypedQuery<Q> buildTypedQuery(PageBuilder<T> pageBuilder, CriteriaQuery<Q> criteriaQuery, Root<E> root, Map<String, Object> parameters) {
        TypedQuery typedQuery = this.getEntityManager().createQuery(criteriaQuery);
        this.buildRange(pageBuilder, (Query)typedQuery, root);
        this.setMappedParameters(typedQuery, parameters);
        this.onPage(pageBuilder.getResultType(), pageBuilder.isCacheable()).accept(typedQuery);
        return typedQuery;
    }

    private <Q> void setPositionalParameters(TypedQuery<Q> typedQuery, Object[] positionalParameters) {
        logger.log(Level.FINER, () -> String.format(LOG_FINER_SET_PARAMETER_VALUES, Arrays.toString(positionalParameters)));
        IntStream.range(0, positionalParameters.length).forEach(i -> typedQuery.setParameter(i, positionalParameters[i]));
    }

    private <Q> void setMappedParameters(TypedQuery<Q> typedQuery, Map<String, Object> mappedParameters) {
        logger.log(Level.FINER, () -> String.format(LOG_FINER_SET_PARAMETER_VALUES, mappedParameters));
        mappedParameters.entrySet().forEach(parameter -> typedQuery.setParameter((String)parameter.getKey(), parameter.getValue()));
    }

    private <Q> void setSuppliedParameters(TypedQuery<Q> typedQuery, Consumer<Map<String, Object>> suppliedParameters) {
        HashMap<String, Object> mappedParameters = new HashMap<String, Object>();
        suppliedParameters.accept(mappedParameters);
        this.setMappedParameters(typedQuery, mappedParameters);
    }

    private <T extends E> PartialResultList<T> executeQuery(PageBuilder<T> pageBuilder, TypedQuery<T> entityQuery, TypedQuery<Long> countQuery) {
        Page page = pageBuilder.getPage();
        List entities = entityQuery.getResultList();
        if (pageBuilder.canBuildValueBasedPagingPredicate() && page.isReversed()) {
            Collections.reverse(entities);
        }
        int estimatedTotalNumberOfResults = countQuery != null ? ((Long)countQuery.getSingleResult()).intValue() : -1;
        logger.log(Level.FINER, () -> String.format(LOG_FINER_QUERY_RESULT, entities, estimatedTotalNumberOfResults));
        return new PartialResultList(entities, page.getOffset(), estimatedTotalNumberOfResults);
    }

    private <T extends E> Root<E> buildRoot(AbstractQuery<T> query) {
        EclipseLinkRoot root = query.from(this.entityType);
        return query instanceof Subquery ? new SubqueryRoot(root) : (this.provider == Provider.ECLIPSELINK ? new EclipseLinkRoot(root) : root);
    }

    private <T extends E> PathResolver buildSelection(PageBuilder<T> pageBuilder, AbstractQuery<T> query, Root<E> root, CriteriaBuilder criteriaBuilder) {
        LinkedHashMap<Getter<T>, Expression<?>> mapping = pageBuilder.getQueryBuilder().build(criteriaBuilder, query, root);
        if (query instanceof Subquery) {
            ((Subquery)query).select((Expression)root.get("id"));
        }
        if (!Lang.isEmpty(mapping)) {
            Set aggregatedFields;
            Map paths = Streams.stream(mapping).collect(Collectors.toMap(e -> ((Getter)e.getKey()).getPropertyName(), e -> (Expression)e.getValue(), (l, r) -> l, LinkedHashMap::new));
            if (query instanceof CriteriaQuery) {
                ((CriteriaQuery)query).multiselect(Streams.stream((Map)paths).map(Alias::as).collect(Collectors.toList()));
            }
            if (!(aggregatedFields = paths.entrySet().stream().filter(e -> this.provider.isAggregation((Expression)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet())).isEmpty()) {
                BaseEntityService.groupByIfNecessary(query, root);
            }
            boolean orderingContainsAggregatedFields = aggregatedFields.removeAll(pageBuilder.getPage().getOrdering().keySet());
            pageBuilder.shouldBuildCountSubquery(true);
            pageBuilder.canBuildValueBasedPagingPredicate(this.provider != Provider.HIBERNATE || !orderingContainsAggregatedFields);
            return new MappedPathResolver(root, paths, ELEMENT_COLLECTION_MAPPINGS.get(this.entityType), MANY_OR_ONE_TO_ONE_MAPPINGS.get(this.entityType));
        }
        if (pageBuilder.getResultType() == this.entityType) {
            pageBuilder.shouldBuildCountSubquery(mapping != null);
            pageBuilder.canBuildValueBasedPagingPredicate(mapping == null);
            return new RootPathResolver(root, ELEMENT_COLLECTION_MAPPINGS.get(this.entityType), MANY_OR_ONE_TO_ONE_MAPPINGS.get(this.entityType));
        }
        throw new IllegalArgumentException(ERROR_ILLEGAL_MAPPING);
    }

    private <T extends E> void buildRange(PageBuilder<T> pageBuilder, Query query, Root<E> root) {
        if (root == null) {
            return;
        }
        boolean hasJoins = BaseEntityService.hasJoins(root);
        Page page = pageBuilder.getPage();
        if ((hasJoins || page.getOffset() > 0) && !pageBuilder.canBuildValueBasedPagingPredicate()) {
            query.setFirstResult(page.getOffset());
        }
        if (hasJoins || page.getLimit() != Integer.MAX_VALUE) {
            query.setMaxResults(page.getLimit());
        }
        if (hasJoins && root instanceof EclipseLinkRoot) {
            ((EclipseLinkRoot)root).runPostponedFetches(query);
        }
    }

    private <T extends E> void buildOrderBy(PageBuilder<T> pageBuilder, CriteriaQuery<T> criteriaQuery, CriteriaBuilder criteriaBuilder, PathResolver pathResolver) {
        Page page = pageBuilder.getPage();
        Map<String, Boolean> ordering = page.getOrdering();
        if (ordering.isEmpty() || page.getLimit() - page.getOffset() == 1) {
            return;
        }
        boolean reversed = pageBuilder.canBuildValueBasedPagingPredicate() && page.isReversed();
        criteriaQuery.orderBy(Streams.stream(ordering).map(order -> this.buildOrder((Map.Entry<String, Boolean>)order, criteriaBuilder, pathResolver, reversed)).collect(Collectors.toList()));
    }

    private Order buildOrder(Map.Entry<String, Boolean> order, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, boolean reversed) {
        String field = order.getKey();
        if (this.oneToManys.test(field) || this.elementCollections.contains(field)) {
            if (this.provider == Provider.ECLIPSELINK) {
                throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ONETOMANY_ORDERBY_ECLIPSELINK);
            }
            if (this.provider == Provider.OPENJPA) {
                throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ONETOMANY_ORDERBY_OPENJPA);
            }
        }
        Expression<?> path = pathResolver.get(field);
        return order.getValue() ^ reversed ? criteriaBuilder.asc(path) : criteriaBuilder.desc(path);
    }

    private <T extends E> Map<String, Object> buildRestrictions(PageBuilder<T> pageBuilder, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver) {
        Page page = pageBuilder.getPage();
        HashMap<String, Object> parameters = new HashMap<String, Object>(page.getRequiredCriteria().size() + page.getOptionalCriteria().size());
        List<Predicate> requiredPredicates = this.buildPredicates(page.getRequiredCriteria(), query, criteriaBuilder, pathResolver, parameters);
        List<Predicate> optionalPredicates = this.buildPredicates(page.getOptionalCriteria(), query, criteriaBuilder, pathResolver, parameters);
        Predicate restriction = null;
        if (!optionalPredicates.isEmpty()) {
            pageBuilder.shouldBuildCountSubquery(true);
            restriction = criteriaBuilder.or(BaseEntityService.toArray(optionalPredicates));
        }
        if (!requiredPredicates.isEmpty()) {
            pageBuilder.shouldBuildCountSubquery(true);
            List<Predicate> wherePredicates = requiredPredicates.stream().filter(Alias::isWhere).collect(Collectors.toList());
            if (!wherePredicates.isEmpty()) {
                restriction = BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, restriction, wherePredicates);
            }
            List inPredicates = wherePredicates.stream().filter(Alias::isIn).collect(Collectors.toList());
            for (Predicate inPredicate : inPredicates) {
                Predicate countPredicate = BaseEntityService.buildCountPredicateIfNecessary(inPredicate, criteriaBuilder, query, pathResolver);
                if (countPredicate == null) continue;
                requiredPredicates.add(countPredicate);
            }
            List<Predicate> havingPredicates = requiredPredicates.stream().filter(Alias::isHaving).collect(Collectors.toList());
            if (!havingPredicates.isEmpty()) {
                BaseEntityService.groupByIfNecessary(query, pathResolver.get(null));
                query.having((Expression)BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, query.getGroupRestriction(), havingPredicates));
            }
        }
        if (!(query instanceof Subquery) && pageBuilder.canBuildValueBasedPagingPredicate()) {
            restriction = BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, restriction, this.buildValueBasedPagingPredicate(page, criteriaBuilder, pathResolver, parameters));
        }
        if (restriction != null) {
            boolean distinct = !optionalPredicates.isEmpty() || BaseEntityService.hasFetches((From)pathResolver.get(null));
            query.distinct(distinct).where((Expression)BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, query.getRestriction(), restriction));
        }
        return parameters;
    }

    private <T extends E, V extends Comparable<V>> Predicate buildValueBasedPagingPredicate(Page page, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Map<String, Object> parameters) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(page.getOrdering().size());
        HashMap orderByFields = new HashMap();
        BaseEntity last = (BaseEntity)page.getLast();
        for (Map.Entry<String, Boolean> order : page.getOrdering().entrySet()) {
            String field = order.getKey();
            Comparable value = (Comparable)Reflections.invokeGetter((Object)last, (String)field);
            Expression<?> path = pathResolver.get(field);
            ParameterExpression parameter = new UncheckedParameterBuilder(field, criteriaBuilder, parameters).create(value);
            Predicate predicate = order.getValue() ^ page.isReversed() ? criteriaBuilder.greaterThan(path, parameter) : criteriaBuilder.lessThan(path, parameter);
            for (Map.Entry previousOrderByField : orderByFields.entrySet()) {
                Expression previousPath = (Expression)previousOrderByField.getKey();
                ParameterExpression previousParameter = (ParameterExpression)previousOrderByField.getValue();
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)(previousParameter == null ? criteriaBuilder.isNull(previousPath) : criteriaBuilder.equal(previousPath, (Expression)previousParameter)));
            }
            orderByFields.put(path, value == null ? null : parameter);
            predicates.add(predicate);
        }
        return criteriaBuilder.or(BaseEntityService.toArray(predicates));
    }

    private <T extends E> List<Predicate> buildPredicates(Map<String, Object> criteria, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Map<String, Object> parameters) {
        return Streams.stream(criteria).map(parameter -> this.buildPredicate((Map.Entry<String, Object>)parameter, query, criteriaBuilder, pathResolver, parameters)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T extends E> Predicate buildPredicate(Map.Entry<String, Object> parameter, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Map<String, Object> parameters) {
        String field = parameter.getKey();
        Expression<?> path = pathResolver.get(this.elementCollections.contains(field) ? pathResolver.join(field) : field);
        Class type = "id".equals(field) ? this.identifierType : path.getJavaType();
        return this.buildTypedPredicate(path, type, field, parameter.getValue(), query, criteriaBuilder, pathResolver, new UncheckedParameterBuilder(field, criteriaBuilder, parameters));
    }

    private <T extends E> Predicate buildTypedPredicate(Expression<?> path, Class<?> type, String field, Object criteria, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Criteria.ParameterBuilder parameterBuilder) {
        Predicate predicate;
        boolean negated;
        Alias alias;
        block13: {
            alias = Alias.create(this.provider, path, field);
            Object value = criteria;
            negated = value instanceof Not;
            if (negated) {
                value = ((Not)value).getValue();
            }
            try {
                if (value == null || value instanceof Criteria && ((Criteria)value).getValue() == null) {
                    predicate = criteriaBuilder.isNull(path);
                    break block13;
                }
                if (value instanceof Criteria) {
                    predicate = ((Criteria)value).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                if (this.elementCollections.contains(field)) {
                    predicate = this.buildElementCollectionPredicate(alias, path, type, field, value, query, criteriaBuilder, pathResolver, parameterBuilder);
                    break block13;
                }
                if (value instanceof Iterable || value.getClass().isArray()) {
                    predicate = this.buildArrayPredicate(path, type, field, value, query, criteriaBuilder, pathResolver, parameterBuilder);
                    break block13;
                }
                if (value instanceof BaseEntity) {
                    predicate = criteriaBuilder.equal(path, parameterBuilder.create(value));
                    break block13;
                }
                if (type.isEnum()) {
                    predicate = org.omnifaces.persistence.criteria.Enumerated.parse(value, type).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                if (Number.class.isAssignableFrom(type)) {
                    predicate = Numeric.parse(value, type).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                if (Boolean.class.isAssignableFrom(type)) {
                    predicate = Bool.parse(value).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                if (String.class.isAssignableFrom(type) || value instanceof String) {
                    predicate = IgnoreCase.value(value.toString()).build(path, criteriaBuilder, parameterBuilder);
                    break block13;
                }
                throw new UnsupportedOperationException(String.format(ERROR_UNSUPPORTED_CRITERIA, field, type, value, value.getClass()));
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, e, () -> String.format(LOG_WARNING_ILLEGAL_CRITERIA_VALUE, field, type, criteria, criteria != null ? criteria.getClass() : null));
                return null;
            }
        }
        if (negated) {
            predicate = criteriaBuilder.not((Expression)predicate);
        }
        alias.set(predicate);
        return predicate;
    }

    private <T extends E> Predicate buildElementCollectionPredicate(Alias alias, Expression<?> path, Class<?> type, String field, Object value, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Criteria.ParameterBuilder parameterBuilder) {
        if (this.provider == Provider.ECLIPSELINK || this.provider == Provider.HIBERNATE && this.database == Database.POSTGRESQL) {
            return this.buildArrayPredicate(path, type, field, value, query, criteriaBuilder, pathResolver, parameterBuilder);
        }
        return this.buildInPredicate(alias, path, type, value, parameterBuilder);
    }

    private Predicate buildInPredicate(Alias alias, Expression<?> path, Class<?> type, Object value, Criteria.ParameterBuilder parameterBuilder) {
        List<Expression> in = Streams.stream((Object)value).map(item -> this.createElementCollectionCriteria(type, item).getValue()).filter(Objects::nonNull).map(parameterBuilder::create).collect(Collectors.toList());
        if (in.isEmpty()) {
            throw new IllegalArgumentException(value.toString());
        }
        alias.in(in.size());
        return path.in(in.toArray(new Expression[in.size()]));
    }

    private <T extends E> Predicate buildArrayPredicate(Expression<?> path, Class<?> type, String field, Object value, AbstractQuery<T> query, CriteriaBuilder criteriaBuilder, PathResolver pathResolver, Criteria.ParameterBuilder parameterBuilder) {
        Expression<?> fieldPath;
        boolean oneToManyField = this.oneToManys.test(field);
        if (oneToManyField) {
            if (this.provider == Provider.ECLIPSELINK) {
                throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ONETOMANY_CRITERIA_ECLIPSELINK);
            }
            if (this.provider == Provider.OPENJPA) {
                throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ONETOMANY_CRITERIA_OPENJPA);
            }
        }
        boolean elementCollectionField = this.elementCollections.contains(field);
        Subquery subquery = null;
        if (oneToManyField || elementCollectionField) {
            subquery = query.subquery(Long.class);
            Root subqueryRoot = subquery.from(this.entityType);
            fieldPath = new RootPathResolver(subqueryRoot, this.elementCollections, this.manyOrOneToOnes).get(pathResolver.join(field));
            subquery.select(criteriaBuilder.countDistinct(fieldPath)).where((Expression)criteriaBuilder.equal((Expression)subqueryRoot.get("id"), pathResolver.get("id")));
        } else {
            fieldPath = path;
        }
        List<Predicate> predicates = Streams.stream((Object)value).map(item -> elementCollectionField ? this.createElementCollectionCriteria(type, item).build(fieldPath, criteriaBuilder, parameterBuilder) : this.buildTypedPredicate(fieldPath, type, field, item, query, criteriaBuilder, pathResolver, parameterBuilder)).filter(Objects::nonNull).collect(Collectors.toList());
        if (predicates.isEmpty()) {
            throw new IllegalArgumentException(value.toString());
        }
        Predicate predicate = criteriaBuilder.or(BaseEntityService.toArray(predicates));
        if (subquery != null) {
            Long actualCount = predicates.size();
            predicate = criteriaBuilder.equal((Expression)subquery.where((Expression)criteriaBuilder.and((Expression)predicate, (Expression)subquery.getRestriction())), (Object)actualCount);
        }
        return predicate;
    }

    private Criteria<?> createElementCollectionCriteria(Class<?> type, Object value) {
        return type.isEnum() ? org.omnifaces.persistence.criteria.Enumerated.parse(value, type) : IgnoreCase.value(value.toString());
    }

    public static BaseEntityService<?, ?> getCurrentInstance() {
        try {
            SessionContext ejbContext = (SessionContext)new InitialContext().lookup("java:comp/EJBContext");
            return (BaseEntityService)ejbContext.getBusinessObject(ejbContext.getInvokedBusinessInterface());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Predicate[] toArray(List<Predicate> predicates) {
        return predicates.toArray(new Predicate[predicates.size()]);
    }

    private static Predicate conjunctRestrictionsIfNecessary(CriteriaBuilder criteriaBuilder, Predicate nullable, Predicate nonnullable) {
        return nullable == null ? nonnullable : criteriaBuilder.and((Expression)nullable, (Expression)nonnullable);
    }

    private static Predicate conjunctRestrictionsIfNecessary(CriteriaBuilder criteriaBuilder, Predicate nullable, List<Predicate> nonnullable) {
        return BaseEntityService.conjunctRestrictionsIfNecessary(criteriaBuilder, nullable, criteriaBuilder.and(BaseEntityService.toArray(nonnullable)));
    }

    private static Predicate buildCountPredicateIfNecessary(Predicate inPredicate, CriteriaBuilder criteriaBuilder, AbstractQuery<?> query, PathResolver pathResolver) {
        Map.Entry<String, Long> fieldAndCount = Alias.getFieldAndCount(inPredicate);
        if (fieldAndCount.getValue() > 1L) {
            Expression<?> join = pathResolver.get(pathResolver.join(fieldAndCount.getKey()));
            Predicate countPredicate = criteriaBuilder.equal(criteriaBuilder.countDistinct(join), (Object)fieldAndCount.getValue());
            Alias.setHaving(inPredicate, countPredicate);
            BaseEntityService.groupByIfNecessary(query, pathResolver.get(fieldAndCount.getKey()));
            return countPredicate;
        }
        return null;
    }

    private static void groupByIfNecessary(AbstractQuery<?> query, Expression<?> path) {
        Expression<?> groupByPath;
        Object object = groupByPath = path instanceof RootWrapper ? ((RootWrapper)path).getWrapped() : path;
        if (!query.getGroupList().contains(groupByPath)) {
            ArrayList groupList = new ArrayList(query.getGroupList());
            groupList.add(groupByPath);
            query.groupBy(groupList);
        }
    }

    private static boolean hasJoins(From<?, ?> from) {
        return !from.getJoins().isEmpty() || BaseEntityService.hasFetches(from);
    }

    private static boolean hasFetches(From<?, ?> from) {
        return from.getFetches().stream().anyMatch(fetch -> fetch instanceof Path) || from instanceof EclipseLinkRoot && ((EclipseLinkRoot)from).hasPostponedFetches();
    }

    private static <T> T noop() {
        return null;
    }

    @FunctionalInterface
    protected static interface MappedQueryBuilder<T> {
        public LinkedHashMap<Getter<T>, Expression<?>> build(CriteriaBuilder var1, AbstractQuery<T> var2, Root<? super T> var3);
    }

    @FunctionalInterface
    protected static interface QueryBuilder<E> {
        public void build(CriteriaBuilder var1, AbstractQuery<E> var2, Root<E> var3);
    }

    @FunctionalInterface
    protected static interface CriteriaQueryBuilder<E> {
        public void build(CriteriaBuilder var1, CriteriaQuery<E> var2, Root<E> var3);
    }
}

