/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.util.AbstractMap;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.omnifaces.persistence.Provider;

class Alias {
    private static final String AS = "as_";
    private static final String WHERE = "where_";
    private static final String HAVING = "having_";
    private static final String IN = "_in";
    private String value;

    private Alias(String alias) {
        this.value = alias;
    }

    public static Selection<?> as(Map.Entry<String, Expression<?>> mappingEntry) {
        Selection selection = (Selection)mappingEntry.getValue();
        return selection.getAlias() != null ? selection : selection.alias(AS + mappingEntry.getKey().replace('.', '$'));
    }

    public static Alias create(Provider provider, Expression<?> expression, String field) {
        return new Alias((provider.isAggregation(expression) ? HAVING : WHERE) + field.replace('.', '$'));
    }

    public void in(int count) {
        this.value = this.value + "_" + count + IN;
    }

    public void set(Predicate predicate) {
        predicate.alias(this.value);
    }

    public static boolean isWhere(Predicate predicate) {
        return predicate.getAlias().startsWith(WHERE);
    }

    public static boolean isIn(Predicate predicate) {
        return predicate.getAlias().endsWith(IN);
    }

    public static boolean isHaving(Predicate predicate) {
        return predicate.getAlias().startsWith(HAVING);
    }

    public static Map.Entry<String, Long> getFieldAndCount(Predicate inPredicate) {
        String alias = inPredicate.getAlias();
        String fieldAndCount = alias.substring(alias.indexOf(95) + 1, alias.lastIndexOf(95));
        String field = fieldAndCount.substring(0, fieldAndCount.lastIndexOf(95)).replace('$', '.');
        long count = Long.valueOf(fieldAndCount.substring(field.length() + 1));
        return new AbstractMap.SimpleEntry<String, Long>(field, count);
    }

    public static void setHaving(Predicate inPredicate, Predicate countPredicate) {
        countPredicate.alias(HAVING + inPredicate.getAlias().substring(inPredicate.getAlias().indexOf(95) + 1));
    }
}

