/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.model;

import java.io.Serializable;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.model.Timestamped;

@MappedSuperclass
public abstract class TimestampedBaseEntity<I extends Comparable<I> & Serializable>
extends BaseEntity<I>
implements Timestamped {
    private static final long serialVersionUID = 1L;
    @Column(nullable=false)
    private Instant created;
    @Column(nullable=false)
    private Instant lastModified;
    @Transient
    private boolean skipAdjustLastModified;

    @PrePersist
    public void onPrePersist() {
        Instant timestamp = Instant.now();
        this.setCreated(timestamp);
        this.setLastModified(timestamp);
    }

    @PreUpdate
    public void onPreUpdate() {
        if (!this.skipAdjustLastModified) {
            Instant timestamp = Instant.now();
            this.setLastModified(timestamp);
        }
    }

    public void skipAdjustLastModified() {
        this.skipAdjustLastModified = true;
    }

    @Override
    public void setCreated(Instant created) {
        this.created = created;
    }

    @Override
    public Instant getCreated() {
        return this.created;
    }

    @Override
    public void setLastModified(Instant lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public Instant getLastModified() {
        return this.lastModified;
    }
}

