/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Table;
import javax.persistence.criteria.Expression;
import javax.persistence.metamodel.Attribute;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.service.BaseEntityService;
import org.omnifaces.utils.Collections;
import org.omnifaces.utils.Lang;
import org.omnifaces.utils.reflect.Reflections;

public enum Provider {
    HIBERNATE{

        @Override
        public String getDialectName(EntityManagerFactory entityManagerFactory) {
            if (((Class)HIBERNATE_SESSION_FACTORY.get()).isInstance(entityManagerFactory)) {
                return Reflections.invokeMethod((Object)Reflections.invokeMethod((Object)Reflections.invokeMethod((Object)entityManagerFactory, (String)"getJdbcServices", (Object[])new Object[0]), (String)"getJdbcEnvironment", (Object[])new Object[0]), (String)"getDialect", (Object[])new Object[0]).getClass().getSimpleName();
            }
            return Reflections.invokeMethod((Object)Reflections.invokeMethod((Object)entityManagerFactory, (String)"getSessionFactory", (Object[])new Object[0]), (String)"getDialect", (Object[])new Object[0]).getClass().getSimpleName();
        }

        @Override
        public boolean isAggregation(Expression<?> expression) {
            return ((Class)HIBERNATE_BASIC_FUNCTION_EXPRESSION.get()).isInstance(expression) && (Boolean)Reflections.invokeMethod(expression, (String)"isAggregation", (Object[])new Object[0]) != false || ((Class)HIBERNATE_COMPARISON_PREDICATE.get()).isInstance(expression) && (this.isAggregation((Expression)Reflections.invokeMethod(expression, (String)"getLeftHandOperand", (Object[])new Object[0])) || this.isAggregation((Expression)Reflections.invokeMethod(expression, (String)"getRightHandOperand", (Object[])new Object[0])));
        }

        @Override
        public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> boolean isProxy(E entity) {
            return ((Class)HIBERNATE_PROXY.get()).isInstance(entity);
        }

        @Override
        public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> boolean isProxyUninitialized(E entity) {
            return this.invokeOnProxy(entity, "isUninitialized", x$0 -> super.isProxyUninitialized(x$0));
        }

        @Override
        public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> E dereferenceProxy(E entity) {
            return (E)this.invokeOnProxy(entity, "getImplementation", x$0 -> super.dereferenceProxy(x$0));
        }

        @Override
        public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> Class<E> getEntityType(E entity) {
            return this.invokeOnProxy(entity, "getPersistentClass", x$0 -> super.getEntityType(x$0));
        }

        @Override
        public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> I getIdentifier(E entity) {
            return (I)this.invokeOnProxy(entity, "getIdentifier", x$0 -> super.getIdentifier(x$0));
        }

        private <T, I extends Comparable<I> & Serializable, E extends BaseEntity<I>> T invokeOnProxy(E entity, String methodName, Function<E, T> fallback) {
            return (T)(this.isProxy(entity) ? Reflections.invokeMethod((Object)Reflections.invokeMethod(entity, (String)"getHibernateLazyInitializer", (Object[])new Object[0]), (String)methodName, (Object[])new Object[0]) : fallback.apply(entity));
        }
    }
    ,
    ECLIPSELINK{

        @Override
        public String getDialectName(EntityManagerFactory entityManagerFactory) {
            return Reflections.invokeMethod((Object)Reflections.invokeMethod((Object)entityManagerFactory, (String)"getDatabaseSession", (Object[])new Object[0]), (String)"getDatasourcePlatform", (Object[])new Object[0]).getClass().getSimpleName();
        }

        @Override
        public boolean isAggregation(Expression<?> expression) {
            return ((Class)ECLIPSELINK_FUNCTION_EXPRESSION_IMPL.get()).isInstance(expression) && AGGREGATE_FUNCTIONS.contains(Reflections.invokeMethod(expression, (String)"getOperation", (Object[])new Object[0]));
        }
    }
    ,
    OPENJPA{

        @Override
        public String getDialectName(EntityManagerFactory entityManagerFactory) {
            Optional getDelegate = Reflections.findMethod((Object)entityManagerFactory, (String)"getDelegate", (Object[])new Object[0]);
            EntityManagerFactory openjpaEntityManagerFactory = getDelegate.isPresent() ? Reflections.invokeMethod((Object)entityManagerFactory, (Method)((Method)getDelegate.get()), (Object[])new Object[0]) : entityManagerFactory;
            return Reflections.invokeMethod((Object)Reflections.invokeMethod((Object)openjpaEntityManagerFactory, (String)"getConfiguration", (Object[])new Object[0]), (String)"getDBDictionaryInstance", (Object[])new Object[0]).getClass().getSimpleName();
        }

        @Override
        public boolean isAggregation(Expression<?> expression) {
            return AGGREGATE_FUNCTIONS.contains(expression.getClass().getSimpleName().toUpperCase());
        }

        @Override
        public boolean isElementCollection(Attribute<?, ?> attribute) {
            return ((Field)attribute.getJavaMember()).getAnnotation(ElementCollection.class) != null;
        }

        @Override
        public boolean isOneToMany(Attribute<?, ?> attribute) {
            return !this.isElementCollection(attribute) && super.isOneToMany(attribute);
        }
    }
    ,
    UNKNOWN;

    public static final String QUERY_HINT_HIBERNATE_CACHEABLE = "org.hibernate.cacheable";
    public static final String QUERY_HINT_HIBERNATE_CACHE_REGION = "org.hibernate.cacheRegion";
    public static final String QUERY_HINT_ECLIPSELINK_MAINTAIN_CACHE = "eclipselink.maintain-cache";
    public static final String QUERY_HINT_ECLIPSELINK_REFRESH = "eclipselink.refresh";
    private static final Optional<Class<Object>> HIBERNATE_PROXY;
    private static final Optional<Class<Object>> HIBERNATE_SESSION_FACTORY;
    private static final Optional<Class<Object>> HIBERNATE_3_5_0_BASIC_FUNCTION_EXPRESSION;
    private static final Optional<Class<Object>> HIBERNATE_4_3_0_BASIC_FUNCTION_EXPRESSION;
    private static final Optional<Class<Object>> HIBERNATE_5_2_0_BASIC_FUNCTION_EXPRESSION;
    private static final Optional<Class<Object>> HIBERNATE_BASIC_FUNCTION_EXPRESSION;
    private static final Optional<Class<Object>> HIBERNATE_3_5_0_COMPARISON_PREDICATE;
    private static final Optional<Class<Object>> HIBERNATE_4_3_0_COMPARISON_PREDICATE;
    private static final Optional<Class<Object>> HIBERNATE_5_2_0_COMPARISON_PREDICATE;
    private static final Optional<Class<Object>> HIBERNATE_COMPARISON_PREDICATE;
    private static final Optional<Class<Object>> ECLIPSELINK_FUNCTION_EXPRESSION_IMPL;
    private static final Set<String> AGGREGATE_FUNCTIONS;

    public static Provider of(EntityManager entityManager) {
        String packageName = entityManager.getDelegate().getClass().getPackage().getName();
        if (packageName.startsWith("org.hibernate.")) {
            return HIBERNATE;
        }
        if (packageName.startsWith("org.eclipse.persistence.")) {
            return ECLIPSELINK;
        }
        if (packageName.startsWith("org.apache.openjpa.")) {
            return OPENJPA;
        }
        return UNKNOWN;
    }

    public static boolean is(Provider provider) {
        return BaseEntityService.getCurrentInstance().getProvider() == provider;
    }

    public String getDialectName(EntityManagerFactory entityManagerFactory) {
        throw new UnsupportedOperationException(String.valueOf(entityManagerFactory));
    }

    public boolean isAggregation(Expression<?> expression) {
        throw new UnsupportedOperationException(String.valueOf(expression));
    }

    public boolean isElementCollection(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }

    public boolean isOneToMany(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY;
    }

    public boolean isManyOrOneToOne(Attribute<?, ?> attribute) {
        return Lang.isOneOf((Object)attribute.getPersistentAttributeType(), (Object[])new Attribute.PersistentAttributeType[]{Attribute.PersistentAttributeType.MANY_TO_ONE, Attribute.PersistentAttributeType.ONE_TO_ONE});
    }

    public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> boolean isProxy(E entity) {
        return false;
    }

    public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> boolean isProxyUninitialized(E entity) {
        return false;
    }

    public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> E dereferenceProxy(E entity) {
        return entity;
    }

    public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> Class<E> getEntityType(E entity) {
        if (entity == null) {
            return null;
        }
        Class<?> entityType = entity.getClass();
        while (BaseEntity.class.isAssignableFrom(entityType) && entityType.getAnnotation(Entity.class) == null) {
            entityType = entityType.getSuperclass();
        }
        return entityType;
    }

    public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> I getIdentifier(E entity) {
        return entity == null ? null : (I)entity.getId();
    }

    public <I extends Comparable<I> & Serializable, E extends BaseEntity<I>> String getTableName(E entity) {
        if (entity == null) {
            return null;
        }
        Class<E> entityType = this.getEntityType(entity);
        Table table = entityType.getAnnotation(Table.class);
        return table != null ? table.name() : entityType.getSimpleName().toUpperCase();
    }

    static {
        HIBERNATE_PROXY = Reflections.findClass((String)"org.hibernate.proxy.HibernateProxy");
        HIBERNATE_SESSION_FACTORY = Reflections.findClass((String)"org.hibernate.SessionFactory");
        HIBERNATE_3_5_0_BASIC_FUNCTION_EXPRESSION = Reflections.findClass((String)"org.hibernate.ejb.criteria.expression.function.BasicFunctionExpression");
        HIBERNATE_4_3_0_BASIC_FUNCTION_EXPRESSION = Reflections.findClass((String)"org.hibernate.jpa.criteria.expression.function.BasicFunctionExpression");
        HIBERNATE_5_2_0_BASIC_FUNCTION_EXPRESSION = Reflections.findClass((String)"org.hibernate.query.criteria.internal.expression.function.BasicFunctionExpression");
        HIBERNATE_BASIC_FUNCTION_EXPRESSION = Stream.of(HIBERNATE_5_2_0_BASIC_FUNCTION_EXPRESSION, HIBERNATE_4_3_0_BASIC_FUNCTION_EXPRESSION, HIBERNATE_3_5_0_BASIC_FUNCTION_EXPRESSION).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
        HIBERNATE_3_5_0_COMPARISON_PREDICATE = Reflections.findClass((String)"org.hibernate.ejb.criteria.predicate.ComparisonPredicate");
        HIBERNATE_4_3_0_COMPARISON_PREDICATE = Reflections.findClass((String)"org.hibernate.jpa.criteria.predicate.ComparisonPredicate");
        HIBERNATE_5_2_0_COMPARISON_PREDICATE = Reflections.findClass((String)"org.hibernate.query.criteria.internal.predicate.ComparisonPredicate");
        HIBERNATE_COMPARISON_PREDICATE = Stream.of(HIBERNATE_5_2_0_COMPARISON_PREDICATE, HIBERNATE_4_3_0_COMPARISON_PREDICATE, HIBERNATE_3_5_0_COMPARISON_PREDICATE).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
        ECLIPSELINK_FUNCTION_EXPRESSION_IMPL = Reflections.findClass((String)"org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl");
        AGGREGATE_FUNCTIONS = Collections.unmodifiableSet((Object[])new Object[]{"MIN", "MAX", "SUM", "AVG", "COUNT"});
    }
}

