/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.Typed;
import javax.persistence.EntityManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.ValidationMode;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.omnifaces.persistence.Database;
import org.omnifaces.persistence.Provider;
import org.omnifaces.utils.stream.Streams;

@Typed
public final class JPA {
    public static final String QUERY_HINT_LOAD_GRAPH = "javax.persistence.loadgraph";
    public static final String QUERY_HINT_FETCH_GRAPH = "javax.persistence.fetchgraph";
    public static final String QUERY_HINT_CACHE_STORE_MODE = "javax.persistence.cache.storeMode";
    public static final String QUERY_HINT_CACHE_RETRIEVE_MODE = "javax.persistence.cache.retrieveMode";
    public static final String PROPERTY_VALIDATION_MODE = "javax.persistence.validation.mode";

    private JPA() {
        throw new AssertionError();
    }

    public static ValidationMode getValidationMode(EntityManager entityManager) {
        Object validationMode = entityManager.getEntityManagerFactory().getProperties().get(PROPERTY_VALIDATION_MODE);
        return validationMode != null ? ValidationMode.valueOf((String)validationMode.toString().toUpperCase()) : ValidationMode.AUTO;
    }

    public static <T> Optional<T> getOptionalSingleResult(TypedQuery<T> typedQuery) {
        return Optional.ofNullable(JPA.getSingleResultOrNull(typedQuery));
    }

    public static <T> Optional<T> getOptionalSingleResult(Query query) {
        return Optional.ofNullable(JPA.getSingleResultOrNull(query));
    }

    public static <T> T getSingleResultOrNull(TypedQuery<T> typedQuery) {
        try {
            return (T)typedQuery.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public static <T> T getSingleResultOrNull(Query query) {
        try {
            return (T)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public static <T> Optional<T> getOptionalFirstResult(TypedQuery<T> typedQuery) {
        typedQuery.setMaxResults(1);
        return typedQuery.getResultList().stream().findFirst();
    }

    public static <T> Optional<T> getOptionalFirstResult(Query query) {
        query.setMaxResults(1);
        return query.getResultList().stream().findFirst();
    }

    public static <T> T getFirstResultOrNull(TypedQuery<T> typedQuery) {
        return JPA.getOptionalFirstResult(typedQuery).orElse(null);
    }

    public static <T> T getFirstResultOrNull(Query query) {
        return JPA.getOptionalFirstResult(query).orElse(null);
    }

    public static <K, T> Map<K, T> getResultMap(TypedQuery<T> typedQuery, Function<? super T, ? extends K> keyMapper) {
        return (Map)typedQuery.getResultList().stream().collect(org.omnifaces.utils.stream.Collectors.toMap(keyMapper));
    }

    public static <K, T, V> Map<K, V> getResultMap(TypedQuery<T> typedQuery, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return typedQuery.getResultList().stream().collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public static <T, I> long countForeignKeyReferences(EntityManager entityManager, Class<T> entityType, Class<I> identifierType, I id) {
        Metamodel metamodel = entityManager.getMetamodel();
        SingularAttribute idAttribute = metamodel.entity(entityType).getId(identifierType);
        return metamodel.getEntities().stream().flatMap(entity -> JPA.getAttributesOfType(entity, entityType)).distinct().mapToLong(attribute -> JPA.countReferencesTo(entityManager, attribute, idAttribute, id)).sum();
    }

    private static <E, T> Stream<Attribute<?, ?>> getAttributesOfType(EntityType<E> entity, Class<T> entityType) {
        return entity.getAttributes().stream().filter(attribute -> entityType.equals(JPA.getJavaType(attribute))).map(attribute -> attribute);
    }

    private static <E> Class<?> getJavaType(Attribute<? super E, ?> attribute) {
        return attribute instanceof PluralAttribute ? ((PluralAttribute)attribute).getElementType().getJavaType() : attribute.getJavaType();
    }

    private static <E, T, I> Long countReferencesTo(EntityManager entityManager, Attribute<E, ?> attribute, SingularAttribute<? super T, I> idAttribute, I id) {
        Join join;
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
        Root root = query.from(attribute.getDeclaringType().getJavaType());
        if (attribute instanceof SingularAttribute) {
            join = root.join((SingularAttribute)attribute);
        } else if (attribute instanceof ListAttribute) {
            join = root.join((ListAttribute)attribute);
        } else if (attribute instanceof SetAttribute) {
            join = root.join((SetAttribute)attribute);
        } else if (attribute instanceof MapAttribute) {
            join = root.join((MapAttribute)attribute);
        } else if (attribute instanceof CollectionAttribute) {
            join = root.join((CollectionAttribute)attribute);
        } else {
            return 0L;
        }
        query.select((Selection)criteriaBuilder.count((Expression)root)).where((Expression)criteriaBuilder.equal((Expression)join.get(idAttribute), id));
        return (Long)entityManager.createQuery(query).getSingleResult();
    }

    public static Expression<String> concat(CriteriaBuilder builder, Object ... expressionsOrStrings) {
        if (expressionsOrStrings.length < 2) {
            throw new IllegalArgumentException("There must be at least 2 expressions or strings");
        }
        List<Expression> expressions = Streams.stream((Object[])expressionsOrStrings).map(expressionOrString -> {
            if (expressionOrString instanceof Expression) {
                return JPA.castAsString(builder, (Expression)expressionOrString);
            }
            return builder.literal(expressionOrString);
        }).collect(Collectors.toList());
        return builder.function("CONCAT", String.class, expressions.toArray(new Expression[expressions.size()]));
    }

    public static Expression<String> castAsString(CriteriaBuilder builder, Expression<?> expression) {
        if (Provider.is(Provider.HIBERNATE)) {
            return expression.as(String.class);
        }
        if (Database.is(Database.POSTGRESQL)) {
            String pattern = null;
            if (Number.class.isAssignableFrom(expression.getJavaType())) {
                pattern = "FM999999999999999999";
            } else if (LocalDate.class.isAssignableFrom(expression.getJavaType())) {
                pattern = "YYYY-MM-DD";
            } else if (LocalTime.class.isAssignableFrom(expression.getJavaType())) {
                pattern = "HH24:MI:SS";
            } else if (LocalDateTime.class.isAssignableFrom(expression.getJavaType())) {
                pattern = "YYYY-MM-DD'T'HH24:MI:SS'Z'";
            } else if (OffsetTime.class.isAssignableFrom(expression.getJavaType())) {
                pattern = "HH24:MI:SS-OF";
            } else if (OffsetDateTime.class.isAssignableFrom(expression.getJavaType())) {
                pattern = "YYYY-MM-DD'T'HH24:MI:SS-OF";
            }
            if (pattern != null) {
                return builder.function("TO_CHAR", String.class, new Expression[]{expression, builder.literal((Object)pattern)});
            }
        }
        return expression;
    }

    public static boolean isEnumeratedByOrdinal(Path<?> path) {
        Enumerated enumerated;
        Member member;
        Bindable model = path.getModel();
        if (model instanceof Attribute && (member = ((Attribute)model).getJavaMember()) instanceof AnnotatedElement && (enumerated = ((AnnotatedElement)((Object)member)).getAnnotation(Enumerated.class)) != null) {
            return enumerated.value() == EnumType.ORDINAL;
        }
        return false;
    }
}

