/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.test.service;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.test.model.Address;
import org.omnifaces.persistence.test.model.Comment;
import org.omnifaces.persistence.test.model.Gender;
import org.omnifaces.persistence.test.model.Group;
import org.omnifaces.persistence.test.model.Person;
import org.omnifaces.persistence.test.model.Phone;
import org.omnifaces.persistence.test.model.Product;
import org.omnifaces.persistence.test.model.ProductStatus;
import org.omnifaces.persistence.test.model.Text;
import org.omnifaces.persistence.test.model.UserRole;
import org.omnifaces.persistence.test.service.CommentService;
import org.omnifaces.persistence.test.service.PersonService;
import org.omnifaces.persistence.test.service.ProductService;
import org.omnifaces.persistence.test.service.TextService;

@Startup
@Singleton
public class StartupService {
    public static final int TOTAL_RECORDS = 200;
    public static final int ROWS_PER_PAGE = 10;
    @Inject
    private TextService textService;
    @Inject
    private CommentService commentService;
    @Inject
    private PersonService personService;
    @Inject
    private ProductService productService;

    @PostConstruct
    public void init() {
        this.createTestPersons();
        this.createTestTexts();
        this.createTestComments();
        this.createTestProducts();
    }

    private void createTestPersons() {
        Gender[] genders = Gender.values();
        Phone.Type[] phoneTypes = Phone.Type.values();
        List<Group> groups = Arrays.asList(Group.values());
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 200; ++i) {
            Person person = new Person();
            person.setEmail("name" + i + "@example.com");
            person.setGender(genders[random.nextInt(genders.length)]);
            person.setDateOfBirth(LocalDate.ofEpochDay(random.nextLong(LocalDate.of(1900, 1, 1).toEpochDay(), LocalDate.of(2000, 1, 1).toEpochDay())));
            Address address = new Address();
            address.setStreet("Street" + i);
            address.setHouseNumber("" + i);
            address.setPostcode("Postcode" + i);
            address.setCity("City" + i);
            address.setCountry("Country" + i);
            person.setAddress(address);
            int totalPhones = random.nextInt(1, 6);
            for (int j = 0; j < totalPhones; ++j) {
                Phone phone = new Phone();
                phone.setType(phoneTypes[random.nextInt(phoneTypes.length)]);
                phone.setNumber("0" + Math.abs(random.nextInt()));
                phone.setOwner(person);
                person.getPhones().add(phone);
            }
            Collections.shuffle(groups, random);
            person.getGroups().addAll(groups.subList(0, random.nextInt(1, groups.size() + 1)));
            this.personService.persist((BaseEntity)person);
        }
    }

    private void createTestTexts() {
        this.textService.persist((BaseEntity)new Text());
        this.textService.persist((BaseEntity)new Text());
    }

    private void createTestComments() {
        this.commentService.persist((BaseEntity)new Comment());
        this.commentService.persist((BaseEntity)new Comment());
    }

    private void createTestProducts() {
        Product product = new Product();
        product.setProductStatus(ProductStatus.IN_STOCK);
        product.addUserRole(UserRole.USER);
        this.productService.persist((BaseEntity)product);
        product = new Product();
        product.setProductStatus(ProductStatus.DISCONTINUED);
        product.addUserRole(UserRole.EMPLOYEE);
        product.addUserRole(UserRole.MANAGER);
        this.productService.persist((BaseEntity)product);
    }
}

