/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.test.service;

import java.util.LinkedHashMap;
import javax.ejb.Stateless;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import org.omnifaces.persistence.JPA;
import org.omnifaces.persistence.model.GeneratedIdEntity;
import org.omnifaces.persistence.model.dto.Page;
import org.omnifaces.persistence.service.BaseEntityService;
import org.omnifaces.persistence.test.model.Person;
import org.omnifaces.persistence.test.model.dto.PersonCard;
import org.omnifaces.utils.collection.PartialResultList;

@Stateless
public class PersonService
extends BaseEntityService<Long, Person> {
    public PartialResultList<Person> getPageWithAddress(Page page, boolean count) {
        return this.getPage(page, count, new String[]{"address"});
    }

    public PartialResultList<Person> getPageWithPhones(Page page, boolean count) {
        return this.getPage(page, count, new String[]{"phones"});
    }

    public PartialResultList<Person> getPageWithGroups(Page page, boolean count) {
        return this.getPage(page, count, new String[]{"groups"});
    }

    public PartialResultList<PersonCard> getPageOfPersonCards(Page page, boolean count) {
        return this.getPage(page, count, PersonCard.class, (builder, query, person) -> {
            Join personAddress = person.join("address");
            Join personPhones = person.join("phones");
            LinkedHashMap<Object, Object> mapping = new LinkedHashMap<Object, Object>();
            mapping.put(GeneratedIdEntity::getId, person.get("id"));
            mapping.put(Person::getEmail, person.get("email"));
            mapping.put(PersonCard::getAddressString, JPA.concat((CriteriaBuilder)builder, (Object[])new Object[]{personAddress.get("street"), " ", personAddress.get("houseNumber"), ", ", personAddress.get("postcode"), " ", personAddress.get("city"), ", ", personAddress.get("country")}));
            mapping.put(PersonCard::getTotalPhones, builder.count((Expression)personPhones));
            query.groupBy(new Expression[]{personAddress});
            return mapping;
        });
    }

    public PartialResultList<Person> getAllWithAddress() {
        return this.getPageWithAddress(Page.ALL, false);
    }

    public PartialResultList<Person> getAllWithPhones() {
        return this.getPageWithPhones(Page.ALL, false);
    }

    public PartialResultList<Person> getAllWithGroups() {
        return this.getPageWithGroups(Page.ALL, false);
    }

    public PartialResultList<PersonCard> getAllPersonCards() {
        return this.getPageOfPersonCards(Page.ALL, false);
    }
}

