/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.test;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.ejb.EJB;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.MavenImporter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.omnifaces.persistence.exception.IllegalEntityStateException;
import org.omnifaces.persistence.exception.NonSoftDeletableEntityException;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.model.dto.Page;
import org.omnifaces.persistence.test.model.Comment;
import org.omnifaces.persistence.test.model.EnumEntity;
import org.omnifaces.persistence.test.model.Gender;
import org.omnifaces.persistence.test.model.Lookup;
import org.omnifaces.persistence.test.model.Person;
import org.omnifaces.persistence.test.model.Product;
import org.omnifaces.persistence.test.model.ProductStatus;
import org.omnifaces.persistence.test.model.Text;
import org.omnifaces.persistence.test.model.UserRole;
import org.omnifaces.persistence.test.model.enums.HardDeleteCodeEnum;
import org.omnifaces.persistence.test.model.enums.HardDeleteCodeTable;
import org.omnifaces.persistence.test.model.enums.HardDeleteIdEnum;
import org.omnifaces.persistence.test.model.enums.HardDeleteIdTable;
import org.omnifaces.persistence.test.model.enums.HardDeleteOnlyCodeEnum;
import org.omnifaces.persistence.test.model.enums.HardDeleteOnlyCodeTable;
import org.omnifaces.persistence.test.model.enums.HardDeleteOnlyIdEnum;
import org.omnifaces.persistence.test.model.enums.HardDeleteOnlyIdTable;
import org.omnifaces.persistence.test.model.enums.IdCodeEnumTableNonDefault;
import org.omnifaces.persistence.test.model.enums.IdCodeEnumWithoutTable;
import org.omnifaces.persistence.test.model.enums.SoftDeleteCodeEnum;
import org.omnifaces.persistence.test.model.enums.SoftDeleteCodeTable;
import org.omnifaces.persistence.test.model.enums.SoftDeleteIdEnum;
import org.omnifaces.persistence.test.model.enums.SoftDeleteIdTable;
import org.omnifaces.persistence.test.model.enums.SoftDeleteOnlyCodeEnum;
import org.omnifaces.persistence.test.model.enums.SoftDeleteOnlyCodeTable;
import org.omnifaces.persistence.test.model.enums.SoftDeleteOnlyIdEnum;
import org.omnifaces.persistence.test.model.enums.SoftDeleteOnlyIdTable;
import org.omnifaces.persistence.test.service.CommentService;
import org.omnifaces.persistence.test.service.EnumEntityService;
import org.omnifaces.persistence.test.service.LookupService;
import org.omnifaces.persistence.test.service.PersonService;
import org.omnifaces.persistence.test.service.ProductService;
import org.omnifaces.persistence.test.service.TextService;
import org.omnifaces.utils.collection.PartialResultList;

@RunWith(value=Arquillian.class)
public class OmniPersistenceTest {
    @EJB
    private PersonService personService;
    @EJB
    private TextService textService;
    @EJB
    private CommentService commentService;
    @EJB
    private LookupService lookupService;
    @EJB
    private ProductService productService;
    @EJB
    private EnumEntityService enumEntityService;

    @Deployment
    public static WebArchive createDeployment() {
        MavenResolverSystem maven = Maven.resolver();
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{OmniPersistenceTest.class.getPackage()})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsWebInfResource("web.xml")).addAsResource("META-INF/persistence.xml")).addAsResource("META-INF/sql/create-test.sql")).addAsResource("META-INF/sql/drop-test.sql")).addAsResource("META-INF/sql/load-test.sql")).addAsLibrary((Archive)((MavenImporter)ShrinkWrap.create(MavenImporter.class)).loadPomFromFile("pom.xml").importBuildOutput().as(JavaArchive.class))).addAsLibraries(((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)maven.loadPomFromFile("pom.xml")).importRuntimeDependencies()).resolve()).withTransitivity()).asFile())).addAsLibraries(((MavenFormatStage)((MavenStrategyStage)maven.resolve("com.h2database:h2:" + System.getProperty("test.h2.version"))).withTransitivity()).asFile());
    }

    @Test
    public void testFindPerson() {
        Optional existingPerson = this.personService.findById(Long.valueOf(1L));
        Assert.assertTrue((String)"Existing person", (boolean)existingPerson.isPresent());
        Optional nonExistingPerson = this.personService.findById(Long.valueOf(0L));
        Assert.assertTrue((String)"Non-existing person", (!nonExistingPerson.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testGetPerson() {
        Person existingPerson = (Person)this.personService.getById(Long.valueOf(1L));
        Assert.assertTrue((String)"Existing person", (existingPerson != null ? 1 : 0) != 0);
        Person nonExistingPerson = (Person)this.personService.getById(Long.valueOf(0L));
        Assert.assertTrue((String)"Non-existing person", (nonExistingPerson == null ? 1 : 0) != 0);
    }

    @Test
    public void testPersistAndDeleteNewPerson() {
        Person newPerson = OmniPersistenceTest.createNewPerson("testPersistNewPerson@example.com");
        this.personService.persist((BaseEntity)newPerson);
        Long expectedNewId = 201L;
        Assert.assertEquals((String)"New person ID", (Object)expectedNewId, (Object)newPerson.getId());
        Assert.assertEquals((String)"Total records", (long)201L, (long)this.personService.list().size());
        this.personService.delete((BaseEntity)newPerson);
        Assert.assertEquals((String)"Total records", (long)200L, (long)this.personService.list().size());
    }

    @Test(expected=IllegalEntityStateException.class)
    public void testPersistExistingPerson() {
        Person existingPerson = OmniPersistenceTest.createNewPerson("testPersistExistingPerson@example.com");
        existingPerson.setId(Long.valueOf(1L));
        this.personService.persist((BaseEntity)existingPerson);
    }

    @Test
    public void testUpdateExistingPerson() {
        Person existingPerson = (Person)this.personService.getById(Long.valueOf(1L));
        Assert.assertTrue((String)"Existing person", (existingPerson != null ? 1 : 0) != 0);
        String newEmail = "testUpdateExistingPerson@example.com";
        existingPerson.setEmail(newEmail);
        this.personService.update((BaseEntity)existingPerson);
        Person existingPersonAfterUpdate = (Person)this.personService.getById(Long.valueOf(1L));
        Assert.assertEquals((String)"Email updated", (Object)newEmail, (Object)existingPersonAfterUpdate.getEmail());
    }

    @Test(expected=IllegalEntityStateException.class)
    public void testUpdateNewPerson() {
        Person newPerson = OmniPersistenceTest.createNewPerson("testUpdateNewPerson@example.com");
        this.personService.update((BaseEntity)newPerson);
    }

    @Test
    public void testResetExistingPerson() {
        Person existingPerson = (Person)this.personService.getById(Long.valueOf(1L));
        Assert.assertTrue((String)"Existing person", (existingPerson != null ? 1 : 0) != 0);
        String oldEmail = existingPerson.getEmail();
        existingPerson.setEmail("testResetExistingPerson@example.com");
        this.personService.reset((BaseEntity)existingPerson);
        Assert.assertEquals((String)"Email resetted", (Object)oldEmail, (Object)existingPerson.getEmail());
    }

    @Test(expected=IllegalEntityStateException.class)
    public void testResetNonExistingPerson() {
        Person nonExistingPerson = OmniPersistenceTest.createNewPerson("testResetNonExistingPerson@example.com");
        this.personService.reset((BaseEntity)nonExistingPerson);
    }

    @Test(expected=IllegalEntityStateException.class)
    public void testDeleteNonExistingPerson() {
        Person nonExistingPerson = OmniPersistenceTest.createNewPerson("testDeleteNonExistingPerson@example.com");
        this.personService.delete((BaseEntity)nonExistingPerson);
    }

    private static Person createNewPerson(String email) {
        Person person = new Person();
        person.setEmail(email);
        person.setGender(Gender.OTHER);
        person.setDateOfBirth(LocalDate.now());
        return person;
    }

    @Test
    public void testPage() {
        PartialResultList persons = this.personService.getPage(Page.ALL, true);
        Assert.assertEquals((String)"There are 200 records", (long)200L, (long)persons.size());
        PartialResultList males = this.personService.getPage(Page.with().anyMatch(Collections.singletonMap("gender", Gender.MALE)).build(), true);
        Assert.assertTrue((String)"There are less than 200 records", (males.size() < 200 ? 1 : 0) != 0);
    }

    @Test
    public void testSoftDelete() {
        List allTexts = this.textService.list();
        List allComments = this.commentService.list();
        Text activeText = (Text)this.textService.getById(Long.valueOf(1L));
        this.textService.softDelete((BaseEntity)activeText);
        Text activeTextAfterSoftDelete = (Text)this.textService.getSoftDeletedById(Long.valueOf(1L));
        Assert.assertTrue((String)"Text entity was soft deleted", (!activeTextAfterSoftDelete.isActive() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Total records for texts", (long)this.textService.list().size(), (long)(allTexts.size() - 1));
        Assert.assertEquals((String)"Total deleted records for texts", (long)this.textService.listSoftDeleted().size(), (long)1L);
        Comment activeComment = (Comment)this.commentService.getById(Long.valueOf(1L));
        this.commentService.softDelete((BaseEntity)activeComment);
        Comment activeCommentAfterSoftDelete = (Comment)this.commentService.getSoftDeletedById(Long.valueOf(1L));
        Assert.assertTrue((String)"Comment entity was soft deleted", (boolean)activeCommentAfterSoftDelete.isDeleted());
        Assert.assertEquals((String)"Total records for comments", (long)this.commentService.list().size(), (long)(allComments.size() - 1));
        Assert.assertEquals((String)"Total deleted records for comments", (long)this.commentService.listSoftDeleted().size(), (long)1L);
        Text deletedText = (Text)this.textService.getSoftDeletedById(Long.valueOf(1L));
        this.textService.softUndelete((BaseEntity)deletedText);
        Text deletedTextAfterSoftUndelete = (Text)this.textService.getById(Long.valueOf(1L));
        Assert.assertTrue((String)"Text entity was soft undeleted", (boolean)deletedTextAfterSoftUndelete.isActive());
        Assert.assertEquals((String)"Total records for texts", (long)this.textService.list().size(), (long)allTexts.size());
        Assert.assertEquals((String)"Total deleted records for texts", (long)this.textService.listSoftDeleted().size(), (long)0L);
        Comment deletedComment = (Comment)this.commentService.getSoftDeletedById(Long.valueOf(1L));
        this.commentService.softUndelete((BaseEntity)deletedComment);
        Comment deletedCommentAfterSoftUndelete = (Comment)this.commentService.getById(Long.valueOf(1L));
        Assert.assertTrue((String)"Comment entity was soft undeleted", (!deletedCommentAfterSoftUndelete.isDeleted() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Total records for comments", (long)this.commentService.list().size(), (long)allComments.size());
        Assert.assertEquals((String)"Total deleted records for comments", (long)this.commentService.listSoftDeleted().size(), (long)0L);
        this.textService.softDelete(allTexts);
        Assert.assertEquals((String)"Total records for texts", (long)this.textService.list().size(), (long)0L);
        Assert.assertEquals((String)"Total deleted records for texts", (long)this.textService.listSoftDeleted().size(), (long)allTexts.size());
        this.commentService.softDelete(allComments);
        Assert.assertEquals((String)"Total records for comments", (long)this.commentService.list().size(), (long)0L);
        Assert.assertEquals((String)"Total deleted records for comments", (long)this.commentService.listSoftDeleted().size(), (long)allComments.size());
    }

    @Test(expected=NonSoftDeletableEntityException.class)
    public void testGetAllSoftDeletedForNonSoftDeletable() {
        this.personService.listSoftDeleted();
    }

    @Test(expected=NonSoftDeletableEntityException.class)
    public void testSoftDeleteNonSoftDeletable() {
        Person person = (Person)this.personService.getById(Long.valueOf(1L));
        this.personService.softDelete((BaseEntity)person);
    }

    @Test(expected=NonSoftDeletableEntityException.class)
    public void testSoftUndeleteNonSoftDeletable() {
        Person person = (Person)this.personService.getById(Long.valueOf(1L));
        this.personService.softUndelete((BaseEntity)person);
    }

    @Test
    public void testGetSoftDeletableById() {
        this.lookupService.persist(new Lookup("aa"));
        Lookup activeLookup = (Lookup)this.lookupService.getById((Comparable)((Object)"aa"));
        Assert.assertTrue((String)"Got active entity with getById method", (activeLookup != null ? 1 : 0) != 0);
        this.lookupService.softDelete(activeLookup);
        Lookup softDeletedLookup = (Lookup)this.lookupService.getById((Comparable)((Object)"aa"));
        Assert.assertTrue((String)"Not able to get deleted entity with getById method", (softDeletedLookup == null ? 1 : 0) != 0);
        softDeletedLookup = (Lookup)this.lookupService.getSoftDeletedById((Comparable)((Object)"aa"));
        Assert.assertTrue((String)"Got deleted entity with getSoftDeletedById method", (softDeletedLookup != null ? 1 : 0) != 0);
    }

    @Test
    public void testFindSoftDeletableById() {
        this.lookupService.persist(new Lookup("bb"));
        Optional activeLookup = this.lookupService.findById((Comparable)((Object)"bb"));
        Assert.assertTrue((String)"Got active entity with findById method", (boolean)activeLookup.isPresent());
        this.lookupService.softDelete((BaseEntity)activeLookup.get());
        Optional softDeletedLookup = this.lookupService.findById((Comparable)((Object)"bb"));
        Assert.assertTrue((String)"Not able to get deleted entity with findById method", (!softDeletedLookup.isPresent() ? 1 : 0) != 0);
        softDeletedLookup = this.lookupService.findSoftDeletedById((Comparable)((Object)"bb"));
        Assert.assertTrue((String)"Got deleted entity with findSoftDeletedById method", (boolean)softDeletedLookup.isPresent());
    }

    @Test
    public void testSave() {
        Lookup lookup = new Lookup("cc");
        this.lookupService.save(lookup);
        Lookup persistedLookup = (Lookup)this.lookupService.getById((Comparable)((Object)"cc"));
        Assert.assertTrue((String)"New entity was persisted with save method", (persistedLookup != null ? 1 : 0) != 0);
        persistedLookup.setActive(false);
        this.lookupService.save(persistedLookup);
        persistedLookup = (Lookup)this.lookupService.getSoftDeletedById((Comparable)((Object)"cc"));
        Assert.assertTrue((String)"Entity was merged with save method", (persistedLookup != null && !persistedLookup.isActive() ? 1 : 0) != 0);
        persistedLookup.setActive(true);
        this.lookupService.update(persistedLookup);
        persistedLookup = (Lookup)this.lookupService.getById((Comparable)((Object)"cc"));
        Assert.assertTrue((String)"Entity was merged with update method", (persistedLookup != null && persistedLookup.isActive() ? 1 : 0) != 0);
    }

    @Test(expected=IllegalEntityStateException.class)
    public void testPersistExistingLookup() {
        Lookup lookup = new Lookup("dd");
        this.lookupService.save(lookup);
        Lookup persistedLookup = (Lookup)this.lookupService.getById((Comparable)((Object)"dd"));
        persistedLookup.setActive(false);
        this.lookupService.persist(lookup);
    }

    @Test(expected=IllegalEntityStateException.class)
    public void testUpdateNewLookup() {
        Lookup lookup = new Lookup("ee");
        this.lookupService.update(lookup);
    }

    @Test
    public void testPersistedEntitiesWithEnums() {
        Product product = this.productService.getByIdWithUserRoles(1L);
        Assert.assertEquals((String)"Product status for product 1 was persisted", (Object)((Object)ProductStatus.IN_STOCK), (Object)((Object)product.getProductStatus()));
        Assert.assertEquals((String)"Product status id for product 1 was persisted", (long)ProductStatus.IN_STOCK.getId(), (long)this.productService.getRawProductStatus((Long)product.getId()));
        Assert.assertTrue((String)"User roles for product 1 were persisted", (product.getUserRoles().size() == 1 && product.getUserRoles().contains((Object)UserRole.USER) ? 1 : 0) != 0);
        Assert.assertTrue((String)"User roles code for product 1 were persisted", (boolean)this.productService.getRawUserRoles((Long)product.getId()).contains(UserRole.USER.getCode()));
        product = this.productService.getByIdWithUserRoles(2L);
        Assert.assertEquals((String)"Product status for product 2 was persisted", (Object)((Object)ProductStatus.DISCONTINUED), (Object)((Object)product.getProductStatus()));
        Assert.assertEquals((String)"Product status id for product 2 was persisted", (long)ProductStatus.DISCONTINUED.getId(), (long)this.productService.getRawProductStatus((Long)product.getId()));
        Assert.assertTrue((String)"User roles for product 2 were persisted", (product.getUserRoles().size() == 2 && product.getUserRoles().containsAll(Arrays.asList(UserRole.EMPLOYEE, UserRole.MANAGER)) ? 1 : 0) != 0);
        Assert.assertTrue((String)"User roles code for product 2 were persisted", (boolean)this.productService.getRawUserRoles((Long)product.getId()).containsAll(Arrays.asList(UserRole.EMPLOYEE.getCode(), UserRole.MANAGER.getCode())));
    }

    @Test
    public void testTwoValuedEnumMappingTable() {
        List<Object> hardDeleteIdEnumResultList = this.enumEntityService.getHardDeleteIdEnumTable();
        Assert.assertTrue((String)"Hard delete id enum table size = 3", (hardDeleteIdEnumResultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Hard delete id enum values size = 3", (Arrays.asList(HardDeleteIdEnum.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 3L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(HardDeleteIdEnum.class, hardDeleteIdEnumResultList, false, true, false);
        List<Object> hardDeleteIdTableResultList = this.enumEntityService.getHardDeleteIdTableTable();
        Assert.assertTrue((String)"Hard delete id table table size = 2", (hardDeleteIdTableResultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Hard delete id table values size = 2", (Arrays.asList(HardDeleteIdTable.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 2L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(HardDeleteIdTable.class, hardDeleteIdTableResultList, false, true, false);
        List<Object> softDeleteIdEnumResultList = this.enumEntityService.getSoftDeleteIdEnumTable();
        Assert.assertTrue((String)"Soft delete id enum table size = 3", (softDeleteIdEnumResultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Soft delete id enum values size = 3", (Arrays.asList(SoftDeleteIdEnum.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 3L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteIdEnum.class, softDeleteIdEnumResultList, false, true, false);
        List<Object> softDeleteIdEnumHistoryResultList = this.enumEntityService.getSoftDeleteIdEnumHistoryTable();
        Assert.assertTrue((String)"Soft delete id enum history table size = 1", (softDeleteIdEnumHistoryResultList.size() == 1 ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteIdEnum.class, softDeleteIdEnumHistoryResultList, false, true, true);
        List<Object> softDeleteIdTableResultList = this.enumEntityService.getSoftDeleteIdTableTable();
        Assert.assertTrue((String)"Soft delete id table table size = 2", (softDeleteIdTableResultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Soft delete id table values size = 2", (Arrays.asList(SoftDeleteIdTable.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 2L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteIdTable.class, softDeleteIdTableResultList, false, true, false);
        List<Object> softDeleteIdTableHistoryResultList = this.enumEntityService.getSoftDeleteIdTableHistoryTable();
        Assert.assertTrue((String)"Soft delete id table history table size = 2", (softDeleteIdTableHistoryResultList.size() == 2 ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteIdTable.class, softDeleteIdTableHistoryResultList, false, true, true);
        List<Object> hardDeleteCodeEnumResultList = this.enumEntityService.getHardDeleteCodeEnumTable();
        Assert.assertTrue((String)"Hard delete code enum table size = 3", (hardDeleteCodeEnumResultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Hard delete code enum values size = 3", (Arrays.asList(HardDeleteCodeEnum.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 3L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(HardDeleteCodeEnum.class, hardDeleteCodeEnumResultList, false, false, false);
        List<Object> hardDeleteCodeTableResultList = this.enumEntityService.getHardDeleteCodeTableTable();
        Assert.assertTrue((String)"Hard delete code table table size = 2", (hardDeleteCodeTableResultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Hard delete code table values size = 2", (Arrays.asList(HardDeleteCodeTable.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 2L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(HardDeleteCodeTable.class, hardDeleteCodeTableResultList, false, false, false);
        List<Object> softDeleteCodeEnumResultList = this.enumEntityService.getSoftDeleteCodeEnumTable();
        Assert.assertTrue((String)"Soft delete code enum table size = 3", (softDeleteCodeEnumResultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Soft delete code enum values size = 3", (Arrays.asList(SoftDeleteCodeEnum.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 3L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteCodeEnum.class, softDeleteCodeEnumResultList, false, false, false);
        List<Object> softDeleteCodeEnumHistoryResultList = this.enumEntityService.getSoftDeleteCodeEnumHistoryTable();
        Assert.assertTrue((String)"Soft delete code enum history table size = 2", (softDeleteCodeEnumHistoryResultList.size() == 2 ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteCodeEnum.class, softDeleteCodeEnumHistoryResultList, false, false, true);
        List<Object> softDeleteCodeTableResultList = this.enumEntityService.getSoftDeleteCodeTableTable();
        Assert.assertTrue((String)"Soft delete code table table size = 2", (softDeleteCodeTableResultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Soft delete code table values size = 2", (Arrays.asList(SoftDeleteCodeTable.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 2L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteCodeTable.class, softDeleteCodeTableResultList, false, false, false);
        List<Object> softDeleteCodeTableHistoryResultList = this.enumEntityService.getSoftDeleteCodeTableHistoryTable();
        Assert.assertTrue((String)"Soft delete code table history table size = 3", (softDeleteCodeTableHistoryResultList.size() == 3 ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteCodeTable.class, softDeleteCodeTableHistoryResultList, false, false, true);
    }

    @Test
    public void testOneValuedEnumMappingTable() {
        List<Object> hardDeleteOnlyIdEnumResultList = this.enumEntityService.getHardDeleteOnlyIdEnumTable();
        Assert.assertTrue((String)"Hard delete only id enum table size = 3", (hardDeleteOnlyIdEnumResultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Hard delete only id enum values size = 3", (Arrays.asList(HardDeleteOnlyIdEnum.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 3L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(HardDeleteOnlyIdEnum.class, hardDeleteOnlyIdEnumResultList, true, true, false);
        List<Object> hardDeleteOnlyIdTableResultList = this.enumEntityService.getHardDeleteOnlyIdTableTable();
        Assert.assertTrue((String)"Hard delete only id table table size = 2", (hardDeleteOnlyIdTableResultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Hard delete only id table values size = 2", (Arrays.asList(HardDeleteOnlyIdTable.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 2L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(HardDeleteOnlyIdTable.class, hardDeleteOnlyIdTableResultList, true, true, false);
        List<Object> softDeleteOnlyIdEnumResultList = this.enumEntityService.getSoftDeleteOnlyIdEnumTable();
        Assert.assertTrue((String)"Soft delete only id enum table size = 3", (softDeleteOnlyIdEnumResultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Soft delete only id enum values size = 3", (Arrays.asList(SoftDeleteOnlyIdEnum.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 3L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteOnlyIdEnum.class, softDeleteOnlyIdEnumResultList, true, true, false);
        List<Object> softDeleteOnlyIdEnumHistoryResultList = this.enumEntityService.getSoftDeleteOnlyIdEnumHistoryTable();
        Assert.assertTrue((String)"Soft delete only id enum history table size = 1", (softDeleteOnlyIdEnumHistoryResultList.size() == 1 ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteOnlyIdEnum.class, softDeleteOnlyIdEnumHistoryResultList, true, true, true);
        List<Object> softDeleteOnlyIdTableResultList = this.enumEntityService.getSoftDeleteOnlyIdTableTable();
        Assert.assertTrue((String)"Soft delete only id table table size = 2", (softDeleteOnlyIdTableResultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Soft delete only id table values size = 2", (Arrays.asList(SoftDeleteOnlyIdTable.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 2L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteOnlyIdTable.class, softDeleteOnlyIdTableResultList, true, true, false);
        List<Object> softDeleteOnlyIdTableHistoryResultList = this.enumEntityService.getSoftDeleteOnlyIdTableHistoryTable();
        Assert.assertTrue((String)"Soft delete only id table history table size = 2", (softDeleteOnlyIdTableHistoryResultList.size() == 2 ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteOnlyIdTable.class, softDeleteOnlyIdTableHistoryResultList, true, true, true);
        List<Object> hardDeleteOnlyCodeEnumResultList = this.enumEntityService.getHardDeleteOnlyCodeEnumTable();
        Assert.assertTrue((String)"Hard delete only code enum table size = 3", (hardDeleteOnlyCodeEnumResultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Hard delete only code enum values size = 3", (Arrays.asList(HardDeleteOnlyCodeEnum.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 3L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(HardDeleteOnlyCodeEnum.class, hardDeleteOnlyCodeEnumResultList, true, false, false);
        List<Object> hardDeleteOnlyCodeTableResultList = this.enumEntityService.getHardDeleteOnlyCodeTableTable();
        Assert.assertTrue((String)"Hard delete only code table table size = 2", (hardDeleteOnlyCodeTableResultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Hard delete only code table values size = 2", (Arrays.asList(HardDeleteOnlyCodeTable.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 2L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(HardDeleteOnlyCodeTable.class, hardDeleteOnlyCodeTableResultList, true, false, false);
        List<Object> softDeleteOnlyCodeEnumResultList = this.enumEntityService.getSoftDeleteOnlyCodeEnumTable();
        Assert.assertTrue((String)"Soft delete only code enum table size = 3", (softDeleteOnlyCodeEnumResultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Soft delete only code enum values size = 3", (Arrays.asList(SoftDeleteOnlyCodeEnum.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 3L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteOnlyCodeEnum.class, softDeleteOnlyCodeEnumResultList, true, false, false);
        List<Object> softDeleteOnlyCodeEnumHistoryResultList = this.enumEntityService.getSoftDeleteOnlyCodeEnumHistoryTable();
        Assert.assertTrue((String)"Soft delete only code enum history table size = 2", (softDeleteOnlyCodeEnumHistoryResultList.size() == 2 ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteOnlyCodeEnum.class, softDeleteOnlyCodeEnumHistoryResultList, true, false, true);
        List<Object> softDeleteOnlyCodeTableResultList = this.enumEntityService.getSoftDeleteOnlyCodeTableTable();
        Assert.assertTrue((String)"Soft delete only code table table size = 2", (softDeleteOnlyCodeTableResultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Soft delete only code table values size = 2", (Arrays.asList(SoftDeleteOnlyCodeTable.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 2L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteOnlyCodeTable.class, softDeleteOnlyCodeTableResultList, true, false, false);
        List<Object> softDeleteOnlyCodeTableHistoryResultList = this.enumEntityService.getSoftDeleteOnlyCodeTableHistoryTable();
        Assert.assertTrue((String)"Soft delete only code table history table size = 3", (softDeleteOnlyCodeTableHistoryResultList.size() == 3 ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(SoftDeleteOnlyCodeTable.class, softDeleteOnlyCodeTableHistoryResultList, true, false, true);
    }

    @Test
    public void testEnumMappingTableSpecials() {
        List<Object> idCodeEnumWithoutTableResultList = this.enumEntityService.getIdCodeEnumWithoutTableTable();
        Assert.assertTrue((String)"Non-default enum mapping table size = 3", (idCodeEnumWithoutTableResultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Non-default enum values size = 3", (Arrays.asList(IdCodeEnumWithoutTable.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 3L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(IdCodeEnumWithoutTable.class, idCodeEnumWithoutTableResultList, false, true, false);
        List<Object> idCodeEnumWithoutTableHistoryResultList = this.enumEntityService.getIdCodeEnumWithoutTableHistoryTable();
        Assert.assertTrue((String)"Non-default enum mapping history table size = 0", (boolean)idCodeEnumWithoutTableHistoryResultList.isEmpty());
        List<Object> idCodeEnumTableNonDefaultResultList = this.enumEntityService.getIdCodeEnumTableNonDefaultTable();
        Assert.assertTrue((String)"Non-default table enum mapping table size = 2", (idCodeEnumTableNonDefaultResultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Non-default table enum values size = 2", (Arrays.asList(IdCodeEnumTableNonDefault.class.getEnumConstants()).stream().filter(Objects::nonNull).count() == 2L ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(IdCodeEnumTableNonDefault.class, idCodeEnumTableNonDefaultResultList, false, true, false);
        List<Object> idCodeEnumTableNonDefaultHistoryResultList = this.enumEntityService.getIdCodeEnumTableNonDefaultHistoryTable();
        Assert.assertTrue((String)"Non-default table enum mapping history table size = 2", (idCodeEnumTableNonDefaultHistoryResultList.size() == 2 ? 1 : 0) != 0);
        this.testEnumToTableCorrespondence(IdCodeEnumTableNonDefault.class, idCodeEnumTableNonDefaultHistoryResultList, false, true, true);
    }

    @Test
    public void testEnumMappingPersistence() {
        EnumEntity newEnumEntity = new EnumEntity();
        newEnumEntity.setHardDeleteCodeEnum(HardDeleteCodeEnum.FIRST);
        newEnumEntity.setHardDeleteCodeTable(HardDeleteCodeTable.valueOf("DEF"));
        newEnumEntity.setHardDeleteIdEnum(HardDeleteIdEnum.FIRST);
        newEnumEntity.setHardDeleteIdTable(HardDeleteIdTable.valueOf("DEF"));
        newEnumEntity.setSoftDeleteCodeEnum(SoftDeleteCodeEnum.FIRST);
        newEnumEntity.setSoftDeleteCodeTable(SoftDeleteCodeTable.valueOf("DEF"));
        newEnumEntity.setSoftDeleteIdEnum(SoftDeleteIdEnum.FIRST);
        newEnumEntity.setSoftDeleteIdTable(SoftDeleteIdTable.valueOf("DEF"));
        newEnumEntity.setHardDeleteOnlyCodeEnum(HardDeleteOnlyCodeEnum.FIRST);
        newEnumEntity.setHardDeleteOnlyCodeTable(HardDeleteOnlyCodeTable.valueOf("DEF"));
        newEnumEntity.setHardDeleteOnlyIdEnum(HardDeleteOnlyIdEnum.FIRST);
        newEnumEntity.setHardDeleteOnlyIdTable(HardDeleteOnlyIdTable.valueOf("DEFAULT_2"));
        newEnumEntity.setSoftDeleteOnlyCodeEnum(SoftDeleteOnlyCodeEnum.FIRST);
        newEnumEntity.setSoftDeleteOnlyCodeTable(SoftDeleteOnlyCodeTable.valueOf("DEF"));
        newEnumEntity.setSoftDeleteOnlyIdEnum(SoftDeleteOnlyIdEnum.FIRST);
        newEnumEntity.setSoftDeleteOnlyIdTable(SoftDeleteOnlyIdTable.valueOf("DEFAULT_2"));
        newEnumEntity.setIdCodeEnumWithoutTable(IdCodeEnumWithoutTable.FIRST);
        newEnumEntity.setIdCodeEnumTableNonDefault(IdCodeEnumTableNonDefault.valueOf("DEF"));
        this.enumEntityService.persist((BaseEntity)newEnumEntity);
        Assert.assertEquals((String)"New enum entity id", (Object)1L, (Object)newEnumEntity.getId());
        EnumEntity persistedEnumEntity = (EnumEntity)this.enumEntityService.getById(Long.valueOf(1L));
        boolean equality = newEnumEntity.getHardDeleteCodeEnum() == persistedEnumEntity.getHardDeleteCodeEnum() && newEnumEntity.getHardDeleteCodeTable() == persistedEnumEntity.getHardDeleteCodeTable() && newEnumEntity.getHardDeleteIdEnum() == persistedEnumEntity.getHardDeleteIdEnum() && newEnumEntity.getHardDeleteIdTable() == persistedEnumEntity.getHardDeleteIdTable() && newEnumEntity.getSoftDeleteCodeEnum() == persistedEnumEntity.getSoftDeleteCodeEnum() && newEnumEntity.getSoftDeleteCodeTable() == persistedEnumEntity.getSoftDeleteCodeTable() && newEnumEntity.getSoftDeleteIdEnum() == persistedEnumEntity.getSoftDeleteIdEnum() && newEnumEntity.getSoftDeleteIdTable() == persistedEnumEntity.getSoftDeleteIdTable() && newEnumEntity.getHardDeleteOnlyCodeEnum() == persistedEnumEntity.getHardDeleteOnlyCodeEnum() && newEnumEntity.getHardDeleteOnlyCodeTable() == persistedEnumEntity.getHardDeleteOnlyCodeTable() && newEnumEntity.getHardDeleteOnlyIdEnum() == persistedEnumEntity.getHardDeleteOnlyIdEnum() && newEnumEntity.getHardDeleteOnlyIdTable() == persistedEnumEntity.getHardDeleteOnlyIdTable() && newEnumEntity.getSoftDeleteOnlyCodeEnum() == persistedEnumEntity.getSoftDeleteOnlyCodeEnum() && newEnumEntity.getSoftDeleteOnlyCodeTable() == persistedEnumEntity.getSoftDeleteOnlyCodeTable() && newEnumEntity.getSoftDeleteOnlyIdEnum() == persistedEnumEntity.getSoftDeleteOnlyIdEnum() && newEnumEntity.getSoftDeleteOnlyIdTable() == persistedEnumEntity.getSoftDeleteOnlyIdTable() && newEnumEntity.getIdCodeEnumWithoutTable() == persistedEnumEntity.getIdCodeEnumWithoutTable() && newEnumEntity.getIdCodeEnumTableNonDefault() == persistedEnumEntity.getIdCodeEnumTableNonDefault();
        Assert.assertTrue((String)"Enum entity from the database equals persisted one", (boolean)equality);
    }

    private void testEnumToTableCorrespondence(Class<? extends Enum<?>> enumClass, List<Object> tableResultList, boolean isOneValue, boolean isOrdinal, boolean isHistory) {
        Arrays.asList(enumClass.getEnumConstants()).stream().filter(Objects::nonNull).forEach(enumConstant -> {
            int number = tableResultList.stream().mapToInt(object -> {
                String code;
                int id;
                Object[] result;
                Object[] objectArray = result = isOneValue ? null : (Object[])object;
                int n = isOneValue ? (isOrdinal ? (Integer)object : -1) : (id = ((Integer)result[0]).intValue());
                String string = isOneValue ? (isOrdinal ? null : (String)object) : (code = (String)result[1]);
                return isOneValue ? ((isOrdinal ? id == enumConstant.ordinal() : enumConstant.name().equals(code)) ? 1 : 0) : (id == enumConstant.ordinal() && enumConstant.name().equals(code) ? 1 : 0);
            }).sum();
            if (isHistory) {
                Assert.assertTrue((String)"No matches found between enum constant and database table", (number == 0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)"Exactly one enum constant found and corresponds to the database table", (number == 1 ? 1 : 0) != 0);
            }
        });
    }
}

