/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.hql.internal.ast.ASTQueryTranslatorFactory;
import org.hibernate.hql.spi.ParameterTranslations;
import org.hibernate.hql.spi.QueryTranslator;
import org.hibernate.internal.AbstractQueryImpl;
import org.omnifaces.persistence.JPA;
import org.omnifaces.persistence.model.BaseEntity;
import org.omnifaces.persistence.model.dto.SortFilterPage;
import org.omnifaces.persistence.service.CapturingStatement;
import org.omnifaces.utils.Lang;
import org.omnifaces.utils.collection.PartialResultList;

public class GenericEntityService {
    private static final Predicate[] PREDICATE_ARRAY = new Predicate[0];
    private EntityManager entityManager;
    private EntityManagerFactory entityManagerFactory;
    private Consumer<EntityManager> setupHandler;
    private Consumer<EntityManager> teardownHandler;

    public static void sort(CriteriaBuilder builder, CriteriaQuery<?> query, String sortOrder, Expression<?> ... sortExpressions) {
        query.orderBy(Arrays.stream(sortExpressions).map(e -> "ASCENDING".equals(sortOrder) ? builder.asc(e) : builder.desc(e)).collect(Collectors.toList()));
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setSetupHandler(Consumer<EntityManager> setupHandler) {
        this.setupHandler = setupHandler;
    }

    public void setTeardownHandler(Consumer<EntityManager> teardownHandler) {
        this.teardownHandler = teardownHandler;
    }

    public BaseEntity<? extends Number> find(Class<BaseEntity<? extends Number>> type, Number id) {
        return (BaseEntity)this.entityManager.find(type, (Object)id);
    }

    public BaseEntity<? extends Number> findWithDepth(Class<BaseEntity<? extends Number>> type, Number id, String ... fetchRelations) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(type);
        Root root = criteriaQuery.from(type);
        for (String relation : fetchRelations) {
            Root fetch = root;
            for (String pathSegment : relation.split(Pattern.quote("."))) {
                fetch = fetch.fetch(pathSegment, JoinType.LEFT);
            }
        }
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get("id"), (Object)id));
        return (BaseEntity)JPA.getOptionalSingleResult(this.entityManager.createQuery(criteriaQuery));
    }

    public <T> PartialResultList<T> getAllPagedAndSortedByType(Class<T> resultType, SortFilterPage sortFilterPage, boolean getCount) {
        return this.getAllPagedAndSorted(resultType, (builder, query, tp) -> query.from(resultType), Collections.emptyMap(), sortFilterPage, getCount);
    }

    public <T> PartialResultList<T> getAllPaged(Class<T> resultType, QueryBuilder<?> queryBuilder, Map<String, Object> parameters, SortFilterPage sortFilterPage, boolean getCount) {
        return this.getAllPagedAndSorted(resultType, queryBuilder, parameters, sortFilterPage, getCount, true, true);
    }

    public <T> PartialResultList<T> getAllPagedUncached(Class<T> resultType, QueryBuilder<?> queryBuilder, Map<String, Object> parameters, SortFilterPage sortFilterPage, boolean getCount) {
        return this.getAllPagedAndSorted(resultType, queryBuilder, parameters, sortFilterPage, getCount, true, false);
    }

    public <T extends BaseEntity<? extends Number>> PartialResultList<T> getAllPagedAndSorted(Class<T> resultType, SortFilterPage sortFilterPage) {
        return this.getAllPagedAndSorted(resultType, (builder, query, type) -> query.from(type), new HashMap<String, Object>(), sortFilterPage, true, false, true);
    }

    public <T extends BaseEntity<? extends Number>> PartialResultList<T> getAllPagedAndSorted(Class<T> resultType, SortFilterPage sortFilterPage, boolean getCount) {
        return this.getAllPagedAndSorted(resultType, (builder, query, type) -> query.from(type), new HashMap<String, Object>(), sortFilterPage, getCount, false, true);
    }

    public <T> PartialResultList<T> getAllPagedAndSorted(Class<T> resultType, QueryBuilder<?> queryBuilder, SortFilterPage sortFilterPage) {
        return this.getAllPagedAndSorted(resultType, queryBuilder, new HashMap<String, Object>(), sortFilterPage, true, false, true);
    }

    public <T> PartialResultList<T> getAllPagedAndSorted(Class<T> resultType, QueryBuilder<?> queryBuilder, SortFilterPage sortFilterPage, boolean getCount) {
        return this.getAllPagedAndSorted(resultType, queryBuilder, new HashMap<String, Object>(), sortFilterPage, getCount, false, true);
    }

    public <T> PartialResultList<T> getAllPagedAndSorted(Class<T> resultType, QueryBuilder<?> queryBuilder, Map<String, Object> parameters, SortFilterPage sortFilterPage, boolean getCount) {
        return this.getAllPagedAndSorted(resultType, queryBuilder, parameters, sortFilterPage, getCount, false, true);
    }

    public <T> PartialResultList<T> getAllPagedAndSortedUncached(Class<T> resultType, QueryBuilder<?> queryBuilder, Map<String, Object> parameters, SortFilterPage sortFilterPage, boolean getCount) {
        return this.getAllPagedAndSorted(resultType, queryBuilder, parameters, sortFilterPage, getCount, false, false);
    }

    public <T> Root<T> getRootQuery(CriteriaBuilder criteriaBuilder, CriteriaQuery<?> criteriaQuery, Class<T> entityType) {
        return criteriaQuery.from(entityType);
    }

    public QueryTranslator translateFromQuery(Query query) {
        return this.translateFromHql(((org.hibernate.Query)query.unwrap(org.hibernate.Query.class)).getQueryString());
    }

    public QueryTranslator translateFromHql(String hqlQueryText) {
        ASTQueryTranslatorFactory translatorFactory = new ASTQueryTranslatorFactory();
        QueryTranslator translator = translatorFactory.createQueryTranslator(hqlQueryText, hqlQueryText, Collections.EMPTY_MAP, (SessionFactoryImplementor)this.entityManagerFactory.unwrap(SessionFactory.class), null);
        translator.compile(Collections.EMPTY_MAP, false);
        return translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> PartialResultList<T> getAllPagedAndSorted(Class<T> resultType, QueryBuilder<?> queryBuilder, Map<String, Object> parameters, SortFilterPage sortFilterPage, boolean getCount, boolean isSorted, boolean isCached) {
        if (this.setupHandler != null) {
            this.setupHandler.accept(this.entityManager);
        }
        try {
            CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(resultType);
            Root root = queryBuilder.build(criteriaBuilder, criteriaQuery, resultType);
            if (!isSorted && !Lang.isEmpty((String)sortFilterPage.getSortField())) {
                criteriaQuery.orderBy(new Order[]{"ASCENDING".equals(sortFilterPage.getSortOrder()) ? criteriaBuilder.asc((Expression)root.get(sortFilterPage.getSortField())) : criteriaBuilder.desc((Expression)root.get(sortFilterPage.getSortField()))});
            }
            HashMap<String, Object> searchParameters = new HashMap<String, Object>(parameters);
            ArrayList searchPredicates = new ArrayList();
            ArrayList exactPredicates = new ArrayList();
            sortFilterPage.getFilterValues().entrySet().forEach(e -> {
                Class type;
                String key = (String)e.getKey();
                Object value = e.getValue();
                String searchKey = key + "Search";
                String searchValue = value.toString();
                try {
                    type = root.get(key).getJavaType();
                }
                catch (IllegalArgumentException ignore) {
                    return;
                }
                if (type.isEnum()) {
                    try {
                        boolean negated = searchValue.startsWith("!");
                        if (negated) {
                            searchValue = searchValue.substring(1);
                        }
                        Object enumValue = Enum.valueOf(type, searchValue.toUpperCase());
                        searchParameters.put(searchKey, enumValue);
                        if (negated) {
                            exactPredicates.add(criteriaBuilder.notEqual((Expression)root.get(key), (Expression)criteriaBuilder.parameter(type, searchKey)));
                        }
                        exactPredicates.add(criteriaBuilder.equal((Expression)root.get(key), (Expression)criteriaBuilder.parameter(type, searchKey)));
                    }
                    catch (IllegalArgumentException ignore) {
                        return;
                    }
                } else if (Boolean.class.isAssignableFrom(type)) {
                    exactPredicates.add(criteriaBuilder.equal((Expression)root.get(key), (Expression)criteriaBuilder.parameter(type, searchKey)));
                    searchParameters.put(searchKey, Boolean.valueOf(searchValue));
                } else if (Long.class.isAssignableFrom(type)) {
                    if (Lang.isOneOf((Object)searchValue, (Object[])new String[]{"true", "false"})) {
                        Path path = root.get(key);
                        ParameterExpression parameter = criteriaBuilder.parameter(Long.class, searchKey);
                        exactPredicates.add("true".equals(searchValue) ? criteriaBuilder.gt((Expression)path, (Expression)parameter) : criteriaBuilder.le((Expression)path, (Expression)parameter));
                        searchParameters.put(searchKey, 0L);
                    } else if (key.matches("(id|.+Id$)") && sortFilterPage.getFilterValues().size() == 1) {
                        exactPredicates.add(criteriaBuilder.equal((Expression)root.get(key), (Expression)criteriaBuilder.parameter(type, searchKey)));
                        searchParameters.put(searchKey, Long.valueOf(searchValue));
                    } else if (value instanceof Long[]) {
                        exactPredicates.add(criteriaBuilder.between((Expression)root.get(key), (Expression)criteriaBuilder.parameter(Long.class, "min_" + searchKey), (Expression)criteriaBuilder.parameter(Long.class, "max_" + searchKey)));
                        searchParameters.put("min_" + searchKey, ((Long[])value)[0]);
                        searchParameters.put("max_" + searchKey, ((Long[])value)[1]);
                        searchParameters.put(searchKey, null);
                    } else {
                        searchParameters.put(searchKey, null);
                    }
                } else if (Collection.class.isAssignableFrom(type)) {
                    Object[] values;
                    if (value instanceof Object[] && (values = (Object[])value).length > 0) {
                        ArrayList<ParameterExpression> in = new ArrayList<ParameterExpression>(values.length);
                        for (Object item : values) {
                            String name = searchKey + item;
                            in.add(criteriaBuilder.parameter(value.getClass().getComponentType(), name));
                            searchParameters.put(name, item);
                        }
                        exactPredicates.add(root.join(key).in(in.toArray(new Expression[in.size()])));
                    }
                    searchParameters.put(searchKey, null);
                } else if (!sortFilterPage.getFilterableFields().contains(key)) {
                    exactPredicates.add(criteriaBuilder.equal((Expression)root.get(key), (Expression)criteriaBuilder.parameter(type, searchKey)));
                    searchParameters.put(searchKey, searchValue);
                }
                if (!searchParameters.containsKey(searchKey)) {
                    searchPredicates.add(criteriaBuilder.like(criteriaBuilder.lower(criteriaBuilder.function("str", String.class, new Expression[]{root.get(key)})), (Expression)criteriaBuilder.parameter(String.class, searchKey)));
                    searchParameters.put(searchKey, "%" + searchValue.toLowerCase() + "%");
                }
            });
            Predicate newRestrictions = null;
            if (!searchPredicates.isEmpty()) {
                Predicate predicate = newRestrictions = sortFilterPage.isFilterWithAND() ? criteriaBuilder.and(searchPredicates.toArray(PREDICATE_ARRAY)) : criteriaBuilder.or(searchPredicates.toArray(PREDICATE_ARRAY));
            }
            if (!exactPredicates.isEmpty()) {
                Predicate exactRestrictions = criteriaBuilder.and(exactPredicates.toArray(PREDICATE_ARRAY));
                Predicate predicate = newRestrictions = newRestrictions != null ? criteriaBuilder.and((Expression)newRestrictions, (Expression)exactRestrictions) : exactRestrictions;
            }
            if (newRestrictions != null) {
                Predicate originalRestrictions = criteriaQuery.getRestriction();
                if (originalRestrictions != null) {
                    criteriaQuery.where((Expression)criteriaBuilder.and((Expression)originalRestrictions, (Expression)newRestrictions));
                } else {
                    criteriaQuery.where((Expression)newRestrictions);
                }
            }
            TypedQuery typedQuery = this.entityManager.createQuery(criteriaQuery).setFirstResult(sortFilterPage.getOffset()).setMaxResults(sortFilterPage.getLimit()).setHint("org.hibernate.cacheable", (Object)(isCached ? "true" : "false")).setHint("org.hibernate.cacheRegion", (Object)"genericEntityServiceRegion");
            searchParameters.values().removeAll(Collections.singleton(null));
            searchParameters.entrySet().forEach(e -> typedQuery.setParameter((String)e.getKey(), e.getValue()));
            List entities = typedQuery.getResultList();
            Long count = -1L;
            if (getCount) {
                TypedQuery countQuery = this.entityManager.createQuery(criteriaQuery.orderBy(new Order[0]));
                for (Map.Entry parameterEntry : searchParameters.entrySet()) {
                    countQuery.setParameter((String)parameterEntry.getKey(), parameterEntry.getValue());
                }
                QueryTranslator translator = this.translateFromQuery((Query)countQuery);
                Query nativeQuery = this.entityManager.createNativeQuery("select count(*) from (" + translator.getSQLString() + ") x");
                ParameterTranslations parameterTranslations = translator.getParameterTranslations();
                org.hibernate.Query query = (org.hibernate.Query)typedQuery.unwrap(org.hibernate.Query.class);
                Map namedParams = null;
                SessionImplementor session = null;
                try {
                    Method method = AbstractQueryImpl.class.getDeclaredMethod("getNamedParams", new Class[0]);
                    method.setAccessible(true);
                    Object map = method.invoke((Object)query, new Object[0]);
                    namedParams = (Map)map;
                    method = AbstractQueryImpl.class.getDeclaredMethod("getSession", new Class[0]);
                    method.setAccessible(true);
                    Object sessionObject = method.invoke((Object)query, new Object[0]);
                    session = (SessionImplementor)sessionObject;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                    throw new IllegalStateException(e1);
                }
                CapturingStatement capturingStatement = new CapturingStatement();
                for (Parameter parameter : countQuery.getParameters()) {
                    for (int position : parameterTranslations.getNamedParameterSqlLocations(parameter.getName())) {
                        TypedValue typedValue = (TypedValue)namedParams.get(parameter.getName());
                        try {
                            typedValue.getType().nullSafeSet((PreparedStatement)capturingStatement, typedValue.getValue(), position + 1, session);
                        }
                        catch (SQLException | HibernateException e1) {
                            throw new IllegalArgumentException(e1);
                        }
                        nativeQuery.setParameter(position + 1, capturingStatement.getObject());
                    }
                }
                count = ((Number)nativeQuery.getSingleResult()).longValue();
            }
            PartialResultList partialResultList = new PartialResultList(entities, sortFilterPage.getOffset(), count.intValue());
            return partialResultList;
        }
        finally {
            if (this.teardownHandler != null) {
                this.teardownHandler.accept(this.entityManager);
            }
        }
    }

    public static interface QueryBuilder<T> {
        public Root<?> build(CriteriaBuilder var1, CriteriaQuery<?> var2, Class<?> var3);
    }
}

