/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.persistence.model.dto;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SortFilterPage {
    public static final SortFilterPage ONE = new SortFilterPage(0, 1, null, null, Collections.emptyList(), Collections.emptyMap(), true);
    public static final SortFilterPage ALL = new SortFilterPage(0, Integer.MAX_VALUE, null, null, Collections.emptyList(), Collections.emptyMap(), true);
    private final int offset;
    private final int limit;
    private final String sortField;
    private final String sortOrder;
    private final List<String> filterableFields;
    private final Map<String, Object> filterValues;
    private final boolean filterWithAND;

    public SortFilterPage(int offset, int limit, String sortField, String sortOrder, List<String> filterableFields, Map<String, Object> filterValues, boolean filterWithAND) {
        this.offset = offset;
        this.limit = limit;
        this.sortField = sortField;
        this.sortOrder = sortOrder;
        this.filterableFields = Collections.unmodifiableList(filterableFields);
        this.filterValues = Collections.unmodifiableMap(filterValues);
        this.filterWithAND = filterWithAND;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getSortField() {
        return this.sortField;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public List<String> getFilterableFields() {
        return this.filterableFields;
    }

    public Map<String, Object> getFilterValues() {
        return this.filterValues;
    }

    public boolean isFilterWithAND() {
        return this.filterWithAND;
    }

    public static SortFilterPageBuilder with() {
        return new SortFilterPageBuilder();
    }

    public static class SortFilterPageBuilder {
        private int offset;
        private int limit;
        private String sortField;
        private String sortOrder;
        private List<String> filterableFields;
        private Map<String, Object> filterValues;
        private boolean filterWithAND;

        public SortFilterPageBuilder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public SortFilterPageBuilder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public SortFilterPageBuilder sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public SortFilterPageBuilder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public SortFilterPageBuilder filterableFields(List<String> filterableFields) {
            this.filterableFields = filterableFields;
            return this;
        }

        public SortFilterPageBuilder filterValues(Map<String, Object> filterValues) {
            this.filterValues = filterValues;
            return this;
        }

        public SortFilterPageBuilder filterWithAND(boolean filterWithAND) {
            this.filterWithAND = filterWithAND;
            return this;
        }

        public SortFilterPage build() {
            return new SortFilterPage(this.offset, this.limit, this.sortField, this.sortOrder, this.filterableFields == null ? Collections.emptyList() : this.filterableFields, this.filterValues == null ? Collections.emptyMap() : this.filterValues, this.filterWithAND);
        }
    }
}

